/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils.database;

import com.avaya.zephyr.common.testutils.deencapsulation.Deencapsulation;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mockito.Mockito;

public abstract class JPATest<T> {
    private static final Logger logger = Logger.getLogger(JPATest.class);
    private static EntityManagerFactory entityManagerFactory;
    protected static EntityManager entityManager;
    protected static EntityManager entityManagerSpy;
    protected T classUnderTest;

    @BeforeClass
    public static void initEntityManager() throws Exception {
        entityManagerFactory = Persistence.createEntityManagerFactory((String)"testDB");
        entityManager = entityManagerFactory.createEntityManager();
        entityManagerSpy = (EntityManager)Mockito.spy((Object)entityManager);
        logger.debug((Object)"Successfully setup entityManager and entityManagerSpy");
    }

    @AfterClass
    public static void closeEntityManager() {
        if (entityManager != null) {
            entityManager.close();
        }
        if (entityManagerFactory != null) {
            entityManagerFactory.close();
        }
    }

    @Before
    public final void jpaTestRunBeforeTest() {
        this.classUnderTest = this.createClassUnderTest();
        if (this.classUnderTest != null) {
            Deencapsulation.setField(this.classUnderTest, "em", (Object)entityManagerSpy);
            logger.debug((Object)"Successfully injected entityManager into classUnderTest");
        }
        Mockito.reset((Object[])new EntityManager[]{entityManagerSpy});
        entityManager.getTransaction().begin();
        logger.debug((Object)"started transaction");
    }

    @After
    public final void jpaTestRunAfterTest() {
        entityManager.getTransaction().rollback();
        logger.debug((Object)"rolled back transaction");
    }

    protected abstract T createClassUnderTest();
}

