/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.client.Logger;
import com.avaya.common.logging.helper.LogRecordJDO;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CommonLogManager {
    static ConcurrentMap<String, Logger> staticLoggerList = new ConcurrentHashMap<String, Logger>();
    static ThreadLocalJDOList jdoHolder = new ThreadLocalJDOList();
    static HashMap<String, LogRecordJDO> staticJdoList = new HashMap();
    static Logger rootLogger = null;

    public static Logger getLogger(String name) {
        Logger logger = (Logger)staticLoggerList.get(name);
        if (logger == null) {
            Logger newLogger = new Logger(name);
            newLogger.setJDO(name);
            logger = staticLoggerList.putIfAbsent(name, newLogger);
            if (logger == null) {
                logger = newLogger;
            }
        }
        return logger;
    }

    public static Logger getLogger(String name, UID jdoId) {
        Logger logger = (Logger)staticLoggerList.get(name + ":" + jdoId);
        if (logger == null) {
            logger = new Logger(name);
            logger.setJDO(jdoId.toString());
            staticLoggerList.put(name + ":" + jdoId, logger);
        }
        return logger;
    }

    public static Logger getRootLogger() {
        if (rootLogger == null) {
            rootLogger = new Logger();
            rootLogger.setJDO("rootLogger");
        }
        return rootLogger;
    }

    public static void initializeJDO(String loggerName, String hostname, String processId, String processName, TimeZone timeZone, String logProductType) {
        CommonLogManager.initializeLogRecordJDO(loggerName, hostname, processId, processName, timeZone, logProductType);
    }

    public static void initializeJDO(UID jdoId, String hostname, String processId, String processName, TimeZone timeZone, String logProductType) {
        CommonLogManager.initializeLogRecordJDO(jdoId.toString(), hostname, processId, processName, timeZone, logProductType);
    }

    private static void initializeLogRecordJDO(String jdoIdent, String hostname, String processId, String processName, TimeZone timeZone, String logProductType) {
        LogRecordJDO logRecordJDO = new LogRecordJDO();
        logRecordJDO.setHostname(hostname);
        logRecordJDO.setProcessId(processId);
        logRecordJDO.setProcessName(processName);
        logRecordJDO.setTimeZone(timeZone);
        logRecordJDO.setLogProductType(logProductType);
        staticJdoList.put(jdoIdent, logRecordJDO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static LogRecordJDO getLogRecordJDO(String jdoIdent) {
        LogRecordJDO returnJDO = null;
        LogRecordJDO initialLogRecordJDO = null;
        returnJDO = jdoHolder.getList().get(jdoIdent);
        HashMap<String, LogRecordJDO> hashMap = staticJdoList;
        synchronized (hashMap) {
            initialLogRecordJDO = staticJdoList.get(jdoIdent);
            if (initialLogRecordJDO == null) {
                initialLogRecordJDO = new LogRecordJDO();
                staticJdoList.put(jdoIdent, initialLogRecordJDO);
            }
        }
        if (returnJDO == null) {
            returnJDO = initialLogRecordJDO.clone();
        }
        return returnJDO;
    }

    protected static void updateLogRecordJDO(String jdoIdent, LogRecordJDO jdoObject) {
        jdoHolder.getList().clear();
        staticJdoList.put(jdoIdent, jdoObject);
    }

    protected static void updateInstanceLogRecordJDO(String jdoIdent, LogRecordJDO jdoObject) {
        jdoHolder.getList().put(jdoIdent, jdoObject);
    }

    static class ThreadLocalJDOList
    extends ThreadLocal<HashMap<String, LogRecordJDO>> {
        ThreadLocalJDOList() {
        }

        @Override
        public HashMap<String, LogRecordJDO> initialValue() {
            return new HashMap<String, LogRecordJDO>();
        }

        public HashMap<String, LogRecordJDO> getList() {
            return (HashMap)super.get();
        }
    }
}

