/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;

public class LogRecordJDO {
    public static StringBuilder inetHost = null;
    private int severity = 7;
    private StringBuilder hostname = new StringBuilder("noHostname");
    private StringBuilder processName = new StringBuilder("NoProcessName");
    private StringBuilder processId = new StringBuilder("");
    private StringBuilder logProductType = new StringBuilder("noProdType");
    private Object logMessage = "";
    private TimeZone timeZone = null;

    public LogRecordJDO() {
        this.setHostname(null);
    }

    public LogRecordJDO(String hostname, String processName, String processId, String logProductType, TimeZone timeZone, Object logMessage) {
        this.setHostname(hostname);
        this.setProcessName(processName);
        this.setProcessId(processId);
        this.setLogProductType(logProductType);
        this.setTimeZone(timeZone);
        this.setLogMessage(logMessage);
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public String getHostname() {
        return this.hostname.toString();
    }

    public void setHostname(String hostname) {
        if (hostname != null && hostname.length() > 0) {
            this.hostname = new StringBuilder(hostname);
        } else if (inetHost != null) {
            this.hostname = inetHost;
        } else {
            try {
                inetHost = this.hostname = new StringBuilder(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException uhe) {
                this.hostname = new StringBuilder("NoHostname");
            }
        }
    }

    public String getProcessId() {
        if (this.processId != null) {
            return this.processId.toString();
        }
        return null;
    }

    public void setProcessId(String processId) {
        this.processId = processId != null && processId.length() > 0 ? new StringBuilder(processId) : null;
    }

    public String getLogProductType() {
        return this.logProductType.toString();
    }

    public void setLogProductType(String logProductType) {
        this.logProductType = logProductType != null && logProductType.length() > 0 ? new StringBuilder(logProductType) : new StringBuilder("noProdType");
    }

    public Object getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(Object logMessage) {
        this.logMessage = logMessage;
    }

    public String getProcessName() {
        return this.processName.toString();
    }

    public void setProcessName(String processName) {
        if (processName == null) {
            processName = "NoProcessName";
        }
        this.processName = new StringBuilder(processName);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        if (null != this.logMessage) {
            return this.logMessage.toString();
        }
        return "";
    }

    public LogRecordJDO clone() {
        LogRecordJDO clone = new LogRecordJDO();
        clone.severity = this.severity;
        clone.hostname = this.hostname;
        clone.processName = this.processName;
        clone.processId = this.processId;
        clone.logProductType = this.logProductType;
        clone.logMessage = this.logMessage;
        clone.timeZone = this.timeZone;
        return clone;
    }

    public static enum Database {
        NONE,
        ORACLE,
        POSTGRES;

    }
}

