/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.StringTokenizer;

public class PluginResource {
    protected StringBuilder resourceDirectory = new StringBuilder("");

    public PluginResource() {
        this.setResourceDirectory(System.getenv("AVAYA_LOG"));
    }

    protected void setResourceDirectory(String avayaLogEnv) {
        if (avayaLogEnv == null) {
            avayaLogEnv = "";
        }
        this.resourceDirectory = new StringBuilder(avayaLogEnv).append(System.getProperty("file.separator")).append("mgmt").append(System.getProperty("file.separator")).append("resource");
    }

    public FileInputStream getPropertiesFile(String localeString, String nameSpace) throws FileNotFoundException {
        FileInputStream fis = null;
        File properties = null;
        if (nameSpace != null) {
            nameSpace = this.convertNameSpace(nameSpace);
        }
        String propertiesName = this.resourceDirectory + System.getProperty("file.separator") + nameSpace + System.getProperty("file.separator") + "EventCodes";
        StringTokenizer tokens = new StringTokenizer(localeString, "_");
        properties = new File(propertiesName + ".properties");
        if (properties.exists()) {
            fis = new FileInputStream(properties);
        }
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            properties = new File((propertiesName = propertiesName + "_" + token) + ".properties");
            if (!properties.exists()) continue;
            fis = new FileInputStream(properties);
        }
        return fis;
    }

    private String convertNameSpace(String nameSpace) {
        StringBuffer returnValue = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(nameSpace, ".");
        String seperator = "";
        while (tokens.hasMoreTokens()) {
            returnValue.append(seperator);
            returnValue.append(tokens.nextToken());
            seperator = System.getProperty("file.separator");
        }
        return returnValue.toString();
    }
}

