/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils.deencapsulation;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public final class DefaultValues {
    private static final Integer ZERO_INT = 0;
    private static final Long ZERO_LONG = 0L;
    private static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    private static final Double ZERO_DOUBLE = 0.0;
    private static final Byte ZERO_BYTE = 0;
    private static final Short ZERO_SHORT = 0;
    private static final Character ZERO_CHAR = Character.valueOf('\u0000');
    private static final Map<String, Object> TYPE_DESC_TO_VALUE_MAP = new HashMap<String, Object>();
    private static final Map<String, Object> ELEM_TYPE_TO_ONE_D_ARRAY = new HashMap<String, Object>();

    private DefaultValues() {
    }

    public static String getReturnTypeDesc(String methodNameAndDesc) {
        if (methodNameAndDesc == null) {
            return null;
        }
        int rightParen = methodNameAndDesc.indexOf(41) + 1;
        return methodNameAndDesc.substring(rightParen);
    }

    public static Object computeForType(Class<?> type) {
        if (type.isArray()) {
            return Array.newInstance(type.getComponentType(), 0);
        }
        if (type != Void.TYPE && type.isPrimitive()) {
            return DefaultValues.defaultValueForPrimitiveType(type);
        }
        return null;
    }

    public static Object defaultValueForPrimitiveType(Class<?> type) {
        if (type == Integer.TYPE) {
            return ZERO_INT;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Long.TYPE) {
            return ZERO_LONG;
        }
        if (type == Double.TYPE) {
            return ZERO_DOUBLE;
        }
        if (type == Float.TYPE) {
            return ZERO_FLOAT;
        }
        if (type == Character.TYPE) {
            return ZERO_CHAR;
        }
        if (type == Byte.TYPE) {
            return ZERO_BYTE;
        }
        return ZERO_SHORT;
    }

    public static <T> T computeForWrapperType(Type type) {
        if (type == Integer.class) {
            return (T)ZERO_INT;
        }
        if (type == Boolean.class) {
            return (T)Boolean.FALSE;
        }
        if (type == Long.class) {
            return (T)ZERO_LONG;
        }
        if (type == Double.class) {
            return (T)ZERO_DOUBLE;
        }
        if (type == Float.class) {
            return (T)ZERO_FLOAT;
        }
        if (type == Character.class) {
            return (T)ZERO_CHAR;
        }
        if (type == Byte.class) {
            return (T)ZERO_BYTE;
        }
        if (type == Short.class) {
            return (T)ZERO_SHORT;
        }
        return null;
    }

    static {
        TYPE_DESC_TO_VALUE_MAP.put("Z", Boolean.FALSE);
        TYPE_DESC_TO_VALUE_MAP.put("C", ZERO_CHAR);
        TYPE_DESC_TO_VALUE_MAP.put("B", ZERO_BYTE);
        TYPE_DESC_TO_VALUE_MAP.put("S", ZERO_SHORT);
        TYPE_DESC_TO_VALUE_MAP.put("I", ZERO_INT);
        TYPE_DESC_TO_VALUE_MAP.put("F", ZERO_FLOAT);
        TYPE_DESC_TO_VALUE_MAP.put("J", ZERO_LONG);
        TYPE_DESC_TO_VALUE_MAP.put("D", ZERO_DOUBLE);
        TYPE_DESC_TO_VALUE_MAP.put("Ljava/util/Enumeration;", Collections.enumeration(Collections.emptyList()));
        TYPE_DESC_TO_VALUE_MAP.put("Ljava/util/Collection;", Collections.emptyList());
        TYPE_DESC_TO_VALUE_MAP.put("Ljava/util/List;", Collections.emptyList());
        TYPE_DESC_TO_VALUE_MAP.put("Ljava/util/Set;", Collections.emptySet());
        TYPE_DESC_TO_VALUE_MAP.put("Ljava/util/SortedSet;", Collections.unmodifiableSortedSet(new TreeSet()));
        TYPE_DESC_TO_VALUE_MAP.put("Ljava/util/Map;", Collections.emptyMap());
        TYPE_DESC_TO_VALUE_MAP.put("Ljava/util/SortedMap;", Collections.unmodifiableSortedMap(new TreeMap()));
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[Z", new boolean[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[C", new char[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[B", new byte[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[S", new short[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[I", new int[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[F", new float[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[J", new long[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[D", new double[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[Ljava/lang/Object;", new Object[0]);
        ELEM_TYPE_TO_ONE_D_ARRAY.put("[Ljava/lang/String;", new String[0]);
    }
}

