/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils.deencapsulation;

import com.avaya.zephyr.common.testutils.deencapsulation.AutoBoxing;
import java.lang.reflect.Type;
import java.util.Arrays;

public final class ParameterReflection {
    static final Class<?>[] NO_PARAMETERS = new Class[0];

    static String getParameterTypesDescription(Type[] paramTypes) {
        String paramTypesDesc = Arrays.asList(paramTypes).toString();
        return paramTypesDesc.replace("class ", "").replace('[', '(').replace(']', ')');
    }

    public static Class<?>[] getArgumentTypesFromArgumentValues(Object ... args) {
        if (args.length == 0) {
            return NO_PARAMETERS;
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = ParameterReflection.getArgumentTypeFromArgumentValue(i, args);
        }
        return argTypes;
    }

    private static Class<?> getArgumentTypeFromArgumentValue(int i, Object[] args) {
        Class<?> argType;
        Object arg = args[i];
        if (arg == null) {
            throw new IllegalArgumentException("Invalid null value passed as argument " + i);
        }
        if (arg instanceof Class) {
            argType = (Class<?>)arg;
            args[i] = null;
        } else {
            argType = arg.getClass();
        }
        return argType;
    }

    public static Object[] argumentsWithExtraFirstValue(Object[] args, Object firstValue) {
        Object[] args2 = new Object[1 + args.length];
        args2[0] = firstValue;
        System.arraycopy(args, 0, args2, 1, args.length);
        return args2;
    }

    static boolean hasMoreSpecificTypes(Class<?>[] currentTypes, Class<?>[] previousTypes) {
        for (int i = 0; i < currentTypes.length; ++i) {
            Class<?> previous;
            Class<?> current = ParameterReflection.wrappedIfPrimitive(currentTypes[i]);
            if (current == (previous = ParameterReflection.wrappedIfPrimitive(previousTypes[i])) || !previous.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    private static Class<?> wrappedIfPrimitive(Class<?> parameterType) {
        return parameterType.isPrimitive() ? AutoBoxing.getWrapperType(parameterType) : parameterType;
    }

    static boolean acceptsArgumentTypes(Class<?>[] paramTypes, Class<?>[] argTypes, int firstParameter) {
        for (int i = firstParameter; i < paramTypes.length; ++i) {
            Class<?> parType = paramTypes[i];
            Class<?> argType = argTypes[i - firstParameter];
            if (ParameterReflection.isSameTypeIgnoringAutoBoxing(parType, argType) || parType.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    static boolean isSameTypeIgnoringAutoBoxing(Class<?> firstType, Class<?> secondType) {
        return firstType == secondType || firstType.isPrimitive() && ParameterReflection.isWrapperOfPrimitiveType(firstType, secondType) || secondType.isPrimitive() && ParameterReflection.isWrapperOfPrimitiveType(secondType, firstType);
    }

    private static boolean isWrapperOfPrimitiveType(Class<?> primitiveType, Class<?> otherType) {
        return primitiveType == AutoBoxing.getPrimitiveType(otherType);
    }

    static int indexOfFirstRealParameter(Class<?>[] mockParameterTypes, Class<?>[] realParameterTypes) {
        int extraParameters = mockParameterTypes.length - realParameterTypes.length;
        if (extraParameters == 1) {
            return -1;
        }
        if (extraParameters != 0) {
            return -1;
        }
        return 0;
    }

    static boolean matchesParameterTypes(Class<?>[] declaredTypes, Class<?>[] specifiedTypes, int firstParameter) {
        for (int i = firstParameter; i < declaredTypes.length; ++i) {
            Class<?> declaredType = declaredTypes[i];
            Class<?> specifiedType = specifiedTypes[i - firstParameter];
            if (ParameterReflection.isSameTypeIgnoringAutoBoxing(declaredType, specifiedType)) continue;
            return false;
        }
        return true;
    }
}

