/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils.deencapsulation;

public final class ClassLoad {
    public static <T> Class<T> loadClass(String className) {
        Class<?> loadedClass = null;
        loadedClass = ClassLoad.loadClass(Thread.currentThread().getContextClassLoader(), className);
        if (loadedClass == null && (loadedClass = ClassLoad.loadClass(ClassLoad.class.getClassLoader(), className)) == null) {
            throw new IllegalArgumentException("No class with name \"" + className + "\" found");
        }
        return loadedClass;
    }

    private static Class<?> loadClass(ClassLoader loader, String className) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }
}

