/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 ****************************************************************************/
package com.avaya.zephyr.sdk.authorization.samples.client.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.avaya.zephyr.sdk.authorization.samples.client.model.Task;
import com.avaya.zephyr.sdk.authorization.samples.client.repository.TaskRepository;

/**
 * A Spring controller to serve CRUD operations on user tasks.
 *
 * @author Avaya
 */
@RestController
@RequestMapping("/tasks")
public class TaskHandler
{
    @Autowired
    private final TaskRepository repo;

    // For Unit Testing
    @Autowired
    TaskHandler(TaskRepository repo)
    {
        this.repo = repo;
    }

    @RequestMapping(method = RequestMethod.GET)
    public List<Task> findTasks()
    {
        return repo.findAll();
    }

    @RequestMapping(method = RequestMethod.POST)
    public Task addTask(@RequestBody Task task)
    {
        task.setId(null);
        return repo.saveAndFlush(task);
    }

    @RequestMapping(value = "/{id}", method = RequestMethod.PUT)
    public Task updateTask(@RequestBody Task updatedTask, @PathVariable Integer id)
    {
        updatedTask.setId(id);
        return repo.saveAndFlush(updatedTask);
    }

    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    public void deleteTask(@PathVariable Integer id)
    {
        //repo.delete(id);
        repo.deleteById(id);
    }
}