/**
 * The Task service provides the AppController to make CRUD operations on tasks
 * /tasks is mapped to the Spring RestCOntroller
 * 
 * The BearerHeaderInterceptor service retrieves the authorization data from the cookie 
 * and includes it in the Authorization Bearer header for each operation made on the Task service. 
 * 
 */
(function(angular) {
  var TaskFactory = function($resource) {
    return $resource('/tasks/:id', 
    {
      id: '@id'
    }, {
      update: {
        method: "PUT"
      },
      remove: {
        method: "DELETE"
      }
    });
  };
  
  TaskFactory.$inject = ['$resource'];
  angular.module("myApp.services").factory("Task", TaskFactory);
  
  angular.module("myApp.services").service('BearerHeaderInterceptor', ['$cookies', function($cookies) {
	  var token = JSON.parse($cookies.getObject('UserSession')).currentUser.authdata,
	  	service = this;
	  
	  service.request = function(config) {
		  config.headers['Authorization'] = 'Bearer ' + token;
		  return config;
	  };
  }]);
  
  angular.module("myApp.services").config([ '$httpProvider',   function($httpProvider) {
	  $httpProvider.interceptors.push('BearerHeaderInterceptor');
  }]);
  
}(angular));