/*****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya  Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/

package com.avaya.collaboration.authorization;

import java.util.List;

/**
 * Represents a token returned by the Authorization Service to a client. The client uses the token to authorize with a resource server and
 * get a resource.
 *
 *
 * @author Avaya
 * @since 3.2
 */
public interface AccessToken
{
    /**
     * Returns the number of seconds in which the token will expire. Defaults to 32400.
     *
     * @return the token's expiry
     */
    int getExpiresIn();

    /**
     * Returns a list of scopes associated with the token. A client can ask for a specific set of scopes while making a token request. When
     * the client gets the token, it can use this method to verify that the scopes it had asked for, were acknowledged by the Authorization
     * Service while granting the token.
     *
     * @return a list of token scopes
     */
    List<String> getScopes();

    /**
     * Returns the subject of the token. If the token is for a user, this returns the user's handle. If the token is for a client
     * application, this returns the client's unique id.
     *
     * @return the token's subject
     */
    String getSubject();

    /**
     * The token type provides the client with the information required to successfully utilize the access token to make a protected
     * resource request. The default type is Bearer.
     *
     * @return the token type
     */
    String getTokenType();
}
