package com.avaya.collaboration.authorization.http;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.when;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import com.avaya.collaboration.authorization.AccessToken;
import com.avaya.collaboration.authorization.AuthorizationHelperException;
import com.avaya.collaboration.authorization.HttpResponseException;

public class HttpRequestExecutorTest
{
    @Mock
    CloseableHttpClient mockHttpClient;

    @Mock
    HttpContext mockHttpContext;

    @Mock
    CloseableHttpResponse mockCloseableHttpResponse;

    @Mock
    HttpPost mockHttpPost;

    @Mock
    StatusLine mockStatusLine;

    @Mock
    HttpEntity mockHttpEntity;

    HttpRequestExecutor classToTest;

    @Before
    public void setUp() throws Exception
    {
        MockitoAnnotations.initMocks(this);
        classToTest = new HttpRequestExecutor(mockHttpClient, mockHttpPost);

        when(mockHttpClient.execute(any(HttpPost.class))).thenReturn(mockCloseableHttpResponse);
        when(mockCloseableHttpResponse.getStatusLine()).thenReturn(mockStatusLine);
        when(mockStatusLine.getStatusCode()).thenReturn(HttpStatus.SC_OK);
        when(mockCloseableHttpResponse.getEntity()).thenReturn(mockHttpEntity);

        final ClassLoader classLoader = getClass().getClassLoader();
        final File file = new File(classLoader.getResource("sampleResponse.json").getFile());
        final InputStream fileInputStream = new FileInputStream(file);

        when(mockHttpEntity.getContent()).thenReturn(fileInputStream);
    }

    @Test
    public void testSunnyDay() throws HttpResponseException, AuthorizationHelperException
    {
        final AccessToken tokenResponse = classToTest.execute();

        assertNotNull(tokenResponse);
        assertEquals("asdasdadadadad", tokenResponse.toString());
    }

    @Test(expected = HttpResponseException.class)
    public void testExecutorGets401Response() throws HttpResponseException, AuthorizationHelperException
    {
        when(mockStatusLine.getStatusCode()).thenReturn(HttpStatus.SC_UNAUTHORIZED);
        classToTest.execute();
    }

    @Test(expected = AuthorizationHelperException.class)
    public void testExecutorThrowsIOException() throws ClientProtocolException, IOException,
    HttpResponseException,
    AuthorizationHelperException
    {
        when(mockHttpClient.execute(any(HttpPost.class))).thenThrow(new IOException());
        classToTest.execute();
    }

    @After
    public void tearDown() throws Exception
    {
    }
}