package com.avaya.collaboration.authorization;

/**
 * Represents an aggregation of tokens returned by the Authorization Service to a client. A TokenAggregate contains both an access token and
 * a refresh token. The client uses the access token to authorize with a resource server and get a resource. When an access token expires,
 * its refresh token counterpart can be used to get a new set of access and refresh tokens.
 *
 *
 * @author Avaya
 * @since 3.8
 */
public interface TokenAggregate
{
    AccessToken getAccessToken();

    RefreshToken getRefreshToken();
}