#!/usr/bin/env bash

#SDK_MVN_OPT is used to provide extra maven options during installer testing.

# install_jar installs a jar artifact to the local maven repository
# usage: install_jar file pom_file
install_jar() {
        mvn $SDK_MVN_OPT install:install-file \
                -Dfile=$1 \
                -DpomFile=$2
        if [ $? -ne 0 ]; then fail; fi;
}

install_jar_javadoc() {
	mvn $SDK_MVN_OPT install:install-file \
		-Dfile=$1 \
		-DpomFile=$2 \
		-Djavadoc=$3
	if [ $? -ne 0 ]; then fail; fi;
}


fail() {
	echo "Install failed."
	while true; do
        read -p "Please enter Y/y to close the prompt.)" yn
        case $yn in
            [Yy]* ) exit 1;;
                * ) echo "Please enter Y/y.";;
        esac
done
	exit 1
}

more ./LICENSE.txt

while true; do
        read -p "Accept above End User License Agreement(EULA)? (Y/N)" yn
        case $yn in
            [Yy]* ) break;;
            [Nn]* ) echo "EULA is not accepted, install terminated!!!.";exit 1;;
                * ) echo "Please answer Y/y or N/n.";;
        esac
done

install_jar_javadoc "lib/external-authorization-client-helper.jar" "lib/external-authorization-client-helper.pom" "lib/external-authorization-client-helper-javadoc.jar"
install_jar "lib/main.pom" "lib/main.pom"
install_jar "lib/sdk.pom" "lib/sdk.pom"
install_jar "lib/authorization.pom" "lib/authorization.pom"
install_jar "lib/avaya-commons-pom.pom" "lib/avaya-commons-pom.pom"
install_jar "lib/sample-apps-java.pom" "lib/sample-apps-java.pom"
install_jar "lib/unit-test-utils.jar" "lib/unit-test-utils.pom"
install_jar "lib/zephyrCommon.pom" "lib/zephyrCommon.pom"
install_jar "lib/avaya-logging-client.jar" "lib/avaya-logging-client.pom"

echo "Install successful."
	while true; do
        read -p "Please enter Y/y to close the prompt.)" yn
        case $yn in
            [Yy]* ) exit 1;;
                * ) echo "Please enter Y/y.";;
        esac
done
	exit 1
