/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 ****************************************************************************/
package com.avaya.zephyr.sdk.authorization.samples.client.interceptors;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.when;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.core.env.Environment;

@RunWith(MockitoJUnitRunner.class)
public class AuthorizationCodeInterceptorTest
{
    AuthorizationCodeInterceptor classToTest;
    private static final String AUTH_CODE_GRANT_TYPE = "code";

    @Mock
    HttpServletRequest mockRequest;

    @Mock
    HttpServletResponse mockResponse;

    @Mock
    Environment mockEnv;

    @Mock
    Object mockHandler;

    Cookie[] requestCookies;

    @Before
    public void setUp() throws Exception
    {
        classToTest = new AuthorizationCodeInterceptor(mockEnv);
    }

    @Test
    public void testReturnsTrueIfRequestHasValidCookie() throws Exception
    {
        requestCookies = new Cookie[1];
        requestCookies[0] = new Cookie("UserSession", "auth_data");

        when(mockRequest.getCookies()).thenReturn(requestCookies);
        when(mockEnv.getProperty("sessionCookieName")).thenReturn("UserSession");

        assertTrue(classToTest.preHandle(mockRequest, mockResponse, mockHandler));
    }

    @Test
    public void testRedirectionIfRequestHasNoCookie() throws Exception
    {
        requestCookies = new Cookie[1];
        requestCookies[0] = new Cookie("LocalSession", "auth_data");

        when(mockRequest.getCookies()).thenReturn(requestCookies);
        when(mockEnv.getProperty("sessionCookieName")).thenReturn("UserSession");
        when(mockEnv.getProperty("clientId")).thenReturn("client_id");
        when(mockEnv.getProperty("authorizeEndpointURL")).thenReturn("https://127.0.0.1:9443/services/AuthorizationService/authorize");
        when(mockRequest.getRequestURL()).thenReturn(new StringBuffer("http://localhost"));

        assertFalse(classToTest.preHandle(mockRequest, mockResponse, mockHandler));
        Mockito.verify(mockResponse, Mockito.times(1)).sendRedirect(Mockito.anyString());
    }

    @Test
    public void testReturnsTrueIfRequestHasAuthCode() throws Exception
    {
        when(mockRequest.getParameter(AUTH_CODE_GRANT_TYPE)).thenReturn("auth_code");

        assertTrue(classToTest.preHandle(mockRequest, mockResponse, mockHandler));
    }
}