/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.account.profile.ep.jaxb;

import com.avaya.account.profile.ep.jaxb.AccountCommProfileType;
import com.avaya.account.profile.ep.jaxb.AccountPropertyType;
import com.avaya.account.profile.ep.jaxb.EquivalenceDeterminer;
import com.avaya.account.profile.ep.jpa.AccountCommProfile;
import com.avaya.account.profile.ep.jpa.AccountProperty;
import com.avaya.account.profile.ep.logic.TargetSupplier;
import com.avaya.account.profile.ep.logic.UpmTargetIdSupplier;
import com.avaya.commons.lang.ArgAssert;
import com.avaya.quantumapi.ManagedElementNameByIdSupplier;
import com.avaya.quantumapi.ManagedElementNameSupplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class AccountCommProfileTypeToAccountCommProfileComparison
implements EquivalenceDeterminer<AccountCommProfileType, AccountCommProfile> {
    private final ManagedElementNameSupplier<String> managedElementNameByIdSupplier;
    private final TargetSupplier upmTargetIdSupplier;

    AccountCommProfileTypeToAccountCommProfileComparison() {
        this((ManagedElementNameSupplier<String>)new ManagedElementNameByIdSupplier(), (TargetSupplier)new UpmTargetIdSupplier());
    }

    AccountCommProfileTypeToAccountCommProfileComparison(ManagedElementNameSupplier<String> managedElementNameByIdSupplier, TargetSupplier upmTargetIdSupplier) {
        ArgAssert.assertNotNull(managedElementNameByIdSupplier, (String)"managedElementNameByIdSupplier");
        ArgAssert.assertNotNull((Object)upmTargetIdSupplier, (String)"upmTargetIdSupplier");
        this.managedElementNameByIdSupplier = managedElementNameByIdSupplier;
        this.upmTargetIdSupplier = upmTargetIdSupplier;
    }

    @Override
    public boolean areEquivalent(AccountCommProfileType acctType, AccountCommProfile acct) {
        ArgAssert.assertNotNull((Object)((Object)acctType), (String)"acctType");
        ArgAssert.assertNotNull((Object)acct, (String)"acct");
        if (!this.areStringsEmptyOrEqual(acctType.getServiceType(), acct.getCommProfileType())) {
            return false;
        }
        if (!this.areStringsEmptyOrEqual(acctType.getElement(), this.managedElementNameByIdSupplier.get((Object)acct.getElement()))) {
            return false;
        }
        if (!this.areStringsEmptyOrEqual(this.upmTargetIdSupplier.get(acct.getElement(), acctType.getTarget()), acct.getTarget())) {
            return false;
        }
        if (!this.areStringsEmptyOrEqual(acctType.getTemplate(), acct.getTemplate())) {
            return false;
        }
        if (!this.areStringsEmptyOrEqual(acctType.getServiceDetails(), acct.getServiceDetails())) {
            return false;
        }
        if (!this.areStringsEmptyOrEqual(acctType.getAccountDetails(), acct.getAccountDetails())) {
            return false;
        }
        return this.compareProperties(this.getAccountPropertyList(acctType), this.getAccountPropertiesSet(acct));
    }

    private List<AccountPropertyType> getAccountPropertyList(AccountCommProfileType acctType) {
        if (null != acctType.getProperties()) {
            return acctType.getProperties().getProperty();
        }
        return Lists.newArrayList();
    }

    private Set<AccountProperty> getAccountPropertiesSet(AccountCommProfile acct) {
        if (null == acct.getAccountProperties()) {
            return Sets.newHashSet();
        }
        return acct.getAccountProperties();
    }

    private boolean compareProperties(List<AccountPropertyType> accountPropertyList, Set<AccountProperty> accountPropertiesSet) {
        if (accountPropertyList.size() == 0) {
            return true;
        }
        if (accountPropertyList.size() != accountPropertiesSet.size()) {
            return false;
        }
        for (AccountPropertyType accountPropertyType : accountPropertyList) {
            if (this.doesPropertyExistWithValue(accountPropertiesSet, accountPropertyType.getName(), accountPropertyType.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean doesPropertyExistWithValue(Set<AccountProperty> accountPropertiesSet, String propertyName, String propertyValue) {
        for (AccountProperty accountProperty : accountPropertiesSet) {
            if (!propertyName.equals(accountProperty.getPropertyName())) continue;
            return propertyValue.equals(accountProperty.getPropertyValue());
        }
        return false;
    }

    private boolean areStringsEmptyOrEqual(String a, String b) {
        return this.bothStringsEmpty(a, b) || StringUtils.equals((String)a, (String)b);
    }

    private boolean bothStringsEmpty(String a, String b) {
        return StringUtils.isEmpty((String)a) && StringUtils.isEmpty((String)b);
    }
}

