/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.account.profile.ep.jaxb;

import com.avaya.account.profile.ep.jaxb.AccountCommProfileType;
import com.avaya.account.profile.ep.jaxb.AccountCommProfileTypeToAccountCommProfileComparison;
import com.avaya.account.profile.ep.jaxb.EquivalenceDeterminer;
import com.avaya.account.profile.ep.jaxb.ProfileConversionException;
import com.avaya.account.profile.ep.jpa.AccountCommProfile;
import com.avaya.account.profile.ep.logic.ElementSupplier;
import com.avaya.account.profile.ep.logic.TargetSupplier;
import com.avaya.account.profile.ep.logic.TemplateIdSupplier;
import com.avaya.account.profile.ep.logic.UpmElementIdSupplier;
import com.avaya.account.profile.ep.logic.UpmTargetIdSupplier;
import com.avaya.account.profile.ep.logic.UpmTemplateIdSupplier;
import com.avaya.commons.lang.ArgAssert;
import com.avaya.coreservice.persistence.comm.CsCommProfile;
import com.avaya.coreservice.um.fileimport.comm.CommProfileXMLConverter;
import com.avaya.coreservice.um.xml.XmlCommProfileType;

public final class AccountCommProfileXmlConverter
implements CommProfileXMLConverter {
    private final ElementSupplier upmElementIdSupplier;
    private final TargetSupplier upmTargetIdSupplier;
    private final TemplateIdSupplier upmTemplateIdSupplier;
    private final EquivalenceDeterminer<AccountCommProfileType, AccountCommProfile> accountCommProfileTypeToAccountCommProfileComparison;

    public AccountCommProfileXmlConverter() {
        this((ElementSupplier)new UpmElementIdSupplier(), (TargetSupplier)new UpmTargetIdSupplier(), (TemplateIdSupplier)new UpmTemplateIdSupplier(), new AccountCommProfileTypeToAccountCommProfileComparison());
    }

    AccountCommProfileXmlConverter(ElementSupplier upmElementIdSupplier, TargetSupplier upmTargetIdSupplier, TemplateIdSupplier upmTemplateIdSupplier, EquivalenceDeterminer<AccountCommProfileType, AccountCommProfile> accountCommProfileTypeToAccountCommProfileComparison) {
        ArgAssert.assertNotNull((Object)upmElementIdSupplier, (String)"upmElementIdSupplier");
        ArgAssert.assertNotNull((Object)upmTargetIdSupplier, (String)"upmTargetIdSupplier");
        ArgAssert.assertNotNull((Object)upmTemplateIdSupplier, (String)"upmTemplateIdSupplier");
        ArgAssert.assertNotNull(accountCommProfileTypeToAccountCommProfileComparison, (String)"accountCommProfileTypeToAccountCommProfileComparison");
        this.upmElementIdSupplier = upmElementIdSupplier;
        this.upmTargetIdSupplier = upmTargetIdSupplier;
        this.upmTemplateIdSupplier = upmTemplateIdSupplier;
        this.accountCommProfileTypeToAccountCommProfileComparison = accountCommProfileTypeToAccountCommProfileComparison;
    }

    public CsCommProfile convertToJPA(XmlCommProfileType xmlCommProfile) {
        ArgAssert.assertNotNull((Object)xmlCommProfile, (String)"xmlCommProfile");
        AccountCommProfile commProfile = new AccountCommProfile();
        if (xmlCommProfile instanceof AccountCommProfileType) {
            AccountCommProfileType accountCommProfileType = (AccountCommProfileType)xmlCommProfile;
            commProfile.setCommProfileType(accountCommProfileType.getServiceType());
            String elementName = accountCommProfileType.getElement();
            String elementId = this.upmElementIdSupplier.get(elementName);
            String targetName = accountCommProfileType.getTarget();
            String targetId = this.upmTargetIdSupplier.get(elementId, targetName);
            String templateName = accountCommProfileType.getTemplate();
            String templateId = this.upmTemplateIdSupplier.get(elementId, targetId, templateName);
            commProfile.setElement(elementId);
            commProfile.setTarget(targetId);
            commProfile.setTemplate(templateId);
            commProfile.setServiceDetails(accountCommProfileType.getServiceDetails());
            commProfile.setAccountDetails(accountCommProfileType.getAccountDetails());
            if (null != accountCommProfileType.isPublished()) {
                commProfile.setPublished(accountCommProfileType.isPublished().booleanValue());
            } else {
                commProfile.setPublished(true);
            }
            if (null != accountCommProfileType.isToBeDeleted()) {
                commProfile.setToBeDeleted(accountCommProfileType.isToBeDeleted().booleanValue());
            } else {
                commProfile.setToBeDeleted(false);
            }
        } else {
            throw new ProfileConversionException("Failed to convert XML to AccountCommProfile: " + xmlCommProfile);
        }
        return commProfile;
    }

    public void updateJPA(CsCommProfile oldCommProfile, XmlCommProfileType xmlCommProfile) {
        this.assertXmlCommProfileCorrectType(xmlCommProfile);
        AccountCommProfileType updatedAccountCommProfileType = (AccountCommProfileType)xmlCommProfile;
        this.assertCommProfileCorrectType(oldCommProfile);
        AccountCommProfile originalAccountCommProfile = (AccountCommProfile)oldCommProfile;
        this.assertNoDifferencesBetweenProfiles(originalAccountCommProfile, updatedAccountCommProfileType);
        if (null != updatedAccountCommProfileType.isPublished()) {
            originalAccountCommProfile.setPublished(updatedAccountCommProfileType.isPublished().booleanValue());
        }
        if (null != updatedAccountCommProfileType.isToBeDeleted()) {
            originalAccountCommProfile.setToBeDeleted(updatedAccountCommProfileType.isToBeDeleted().booleanValue());
        }
    }

    private void assertXmlCommProfileCorrectType(XmlCommProfileType xmlCommProfile) {
        if (!(xmlCommProfile instanceof AccountCommProfileType)) {
            throw new UnsupportedOperationException("xmlCommProfile is not an instance of AccountCommProfileType as expected: " + xmlCommProfile);
        }
    }

    private void assertCommProfileCorrectType(CsCommProfile oldCommProfile) {
        if (!(oldCommProfile instanceof AccountCommProfile)) {
            throw new UnsupportedOperationException("Old profile cannot be cast to AccountCommProfile as expected: " + oldCommProfile);
        }
    }

    private void assertNoDifferencesBetweenProfiles(AccountCommProfile original, AccountCommProfileType updated) {
        if (!this.accountCommProfileTypeToAccountCommProfileComparison.areEquivalent(updated, original)) {
            throw new UnsupportedOperationException("Updates to communication profile of type " + original.getCommProfileType() + " cannot be performed as it already exists for this user.");
        }
    }
}

