/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.abg.eps.upm.bulkimportexport.converters;

import com.avaya.abg.eps.logging.ABGLoggerTypes;
import com.avaya.abg.eps.upm.bulkimportexport.jaxbgen.abguserprofile.XmlB5800UserProfile;
import com.avaya.abg.eps.upm.bulkimportexport.jaxbgen.abguserprofile.XmlB5800UserProfileData;
import com.avaya.abg.eps.upm.bulkimportexport.utils.Copier;
import com.avaya.abg.eps.upm.jpa.entities.ABGCommProfile;
import com.avaya.abg.eps.upm.jpa.entities.ABGExtensionType;
import com.avaya.abg.eps.upm.ui.utils.ABGUPMUtil;
import com.avaya.abg.omodels.ABGData;
import com.avaya.abg.service.ABGUserProfileServiceInterface;
import com.avaya.common.eps.logging.IptcmCommonLogger;
import com.avaya.coreservice.persistence.comm.CsCommProfile;
import com.avaya.coreservice.um.fileimport.comm.CommProfileXMLConverter;
import com.avaya.coreservice.um.xml.XmlCommProfileType;
import com.avaya.panther.config.rts.service.common.entity.ApplicationSystemEntity;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class ABGUserProfileXmlConverter
implements CommProfileXMLConverter {
    private ABGUserProfileServiceInterface abgUserProfileService;

    public CsCommProfile convertToJPA(XmlCommProfileType xmlCommProfile) {
        String self = "ABGUserProfileXmlConverter.convertToJPA():";
        IptcmCommonLogger.finest((Object)ABGLoggerTypes.DEBUG, (Object)self);
        ABGCommProfile abgCommProfile = new ABGCommProfile();
        try {
            XmlB5800UserProfile profile;
            if (xmlCommProfile instanceof XmlB5800UserProfile) {
                Long rtsAppId;
                profile = (XmlB5800UserProfile)xmlCommProfile;
                abgCommProfile.setCommProfileType(profile.getCommProfileType());
                abgCommProfile.setAbgName(profile.getDeviceName());
                abgCommProfile.setExtension(profile.getExtension());
                abgCommProfile.setUserTemplate(profile.getUserTemplate());
                abgCommProfile.setExtensionType(ABGExtensionType.valueOf((String)profile.getExtensionType()));
                abgCommProfile.setDeleteExtOnUserDelete(profile.isDeleteExtOnUserDelete());
                abgCommProfile.setModulePort(profile.getModulePort());
                if (profile.getUseExistingExt() == null) {
                    abgCommProfile.setExistingExt(false);
                } else {
                    abgCommProfile.setExistingExt(profile.getUseExistingExt().booleanValue());
                }
                if (profile.getData() != null) {
                    abgCommProfile.setXmlData(this.importXmlToUserXML(profile.getData()));
                }
                abgCommProfile.setIsBulkImportObject(Boolean.valueOf(true));
                try {
                    this.abgUserProfileService = ABGUPMUtil.getABGUserProfileServiceBean();
                }
                catch (Exception e) {
                    IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Could not read AbgUserProfileServiceBean."));
                    throw new RuntimeException(e.getMessage());
                }
                ABGData abgData = null;
                try {
                    abgData = this.abgUserProfileService.getDeviceDataByName(profile.getDeviceName());
                }
                catch (Exception e) {
                    IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Could not read B5800 device: " + e.getMessage()), (Throwable)e);
                    throw new RuntimeException("Could not read IP Office device: " + e.getMessage(), e);
                }
                if (abgData != null) {
                    rtsAppId = abgData.getRtsappsystemid();
                    if (rtsAppId == null) {
                        IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + profile.getDeviceName() + "Device not found in RTS."));
                        throw new RuntimeException(profile.getDeviceName() + "Device not found in RTS.");
                    }
                } else {
                    IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Could not read IP Office from System."));
                    throw new RuntimeException("Could not read IP Office from System.");
                }
                ApplicationSystemEntity appSystemEntity = new ApplicationSystemEntity();
                appSystemEntity.setId(rtsAppId);
                abgCommProfile.setApplicationSystemEntity(appSystemEntity);
            } else {
                IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Incompatible Profile Type."));
                throw new RuntimeException("Incompatible Profile Type.");
            }
            this.updateBulkImportJobMap(profile.getJobId(), profile.getDeviceName());
        }
        catch (Exception e) {
            IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + e.getMessage()));
            throw new RuntimeException(e.getMessage(), e);
        }
        return abgCommProfile;
    }

    public String importXmlToUserXML(XmlB5800UserProfileData userData) {
        String self = "ABGUserProfileXmlConverter.importXmlToUserXML():";
        JAXBContext jaxbC = null;
        String result = null;
        try {
            jaxbC = JAXBContext.newInstance((Class[])new Class[]{XmlB5800UserProfileData.class});
            Marshaller marshal = jaxbC.createMarshaller();
            marshal.setProperty("jaxb.fragment", (Object)true);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            marshal.marshal((Object)userData, (OutputStream)os);
            StringBuffer strBuff = new StringBuffer(os.toString().replaceAll(" xmlns=\"http://xml.avaya.com/schema/import_csm_b5800\"", ""));
            result = strBuff.toString();
        }
        catch (Exception exp) {
            IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + exp.getMessage()));
            throw new RuntimeException(exp.getMessage());
        }
        return result;
    }

    public void updateJPA(CsCommProfile oldCommProfile, XmlCommProfileType xmlCommProfile) {
        String self = "ABGUserProfileXmlConverter.updateJPA():";
        if (xmlCommProfile instanceof XmlB5800UserProfile) {
            if (oldCommProfile instanceof ABGCommProfile) {
                try {
                    ABGCommProfile oldAbgCommProfile = (ABGCommProfile)oldCommProfile;
                    Object appSystemForAbg = null;
                    CsCommProfile clonedOldComm = (CsCommProfile)Copier.xerox(oldCommProfile);
                    XmlB5800UserProfile profile = (XmlB5800UserProfile)xmlCommProfile;
                    String oldABGName = oldAbgCommProfile.getApplicationSystemEntity().getName();
                    String newABGName = profile.getDeviceName();
                    if (!oldABGName.equals(newABGName)) {
                        String errorDesc = "Can not move Endpoint from IP Office " + oldABGName + " to IP Office " + newABGName;
                        IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + errorDesc));
                        throw new RuntimeException(errorDesc);
                    }
                    oldAbgCommProfile.setCommProfileType(xmlCommProfile.getCommProfileType());
                    oldAbgCommProfile.setAbgName(profile.getDeviceName());
                    oldAbgCommProfile.setExtension(profile.getExtension());
                    oldAbgCommProfile.setUserTemplate(profile.getUserTemplate());
                    oldAbgCommProfile.setExtensionType(ABGExtensionType.valueOf((String)profile.getExtensionType()));
                    oldAbgCommProfile.setDeleteExtOnUserDelete(profile.isDeleteExtOnUserDelete());
                    if (profile.getUseExistingExt() == null) {
                        oldAbgCommProfile.setExistingExt(false);
                    } else {
                        oldAbgCommProfile.setExistingExt(profile.getUseExistingExt().booleanValue());
                    }
                    if (profile.getData() != null) {
                        oldAbgCommProfile.setXmlData(this.importXmlToUserXML(profile.getData()));
                    }
                    oldAbgCommProfile.setIsBulkImportObject(Boolean.valueOf(true));
                    try {
                        this.abgUserProfileService = ABGUPMUtil.getABGUserProfileServiceBean();
                    }
                    catch (Exception e) {
                        IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Could not read AbgUserProfileServiceBean: " + e.getMessage()), (Throwable)e);
                        throw new RuntimeException(e.getMessage());
                    }
                    ABGData abgData = null;
                    try {
                        abgData = this.abgUserProfileService.getDeviceDataByName(profile.getDeviceName());
                    }
                    catch (Exception e) {
                        IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Could not read B5800 device: " + e.getMessage()), (Throwable)e);
                        throw new RuntimeException("Could not read IP Office device: " + e.getMessage(), e);
                    }
                    ApplicationSystemEntity appSystemEntity = new ApplicationSystemEntity();
                    if (abgData == null || abgData.getRtsappsystemid() == 0L) {
                        IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + profile.getDeviceName() + "Device not found in RTS."));
                        throw new RuntimeException(profile.getDeviceName() + "Device not found in RTS.");
                    }
                    appSystemEntity.setId(Long.valueOf(abgData.getRtsappsystemid()));
                    oldAbgCommProfile.setApplicationSystemEntity(appSystemEntity);
                    oldAbgCommProfile.setOldCommProfile((ABGCommProfile)clonedOldComm);
                    this.updateBulkImportJobMap(profile.getJobId(), profile.getDeviceName());
                }
                catch (Exception e) {
                    IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Error in updateJPA for ABGCommProfile : " + e.getMessage()));
                    throw new RuntimeException("Error in updateJPA for ABGCommProfile : " + e.getMessage(), e);
                }
            }
            IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Incompatible Type."));
            throw new RuntimeException("Incompatible Type.");
        }
        IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Incompatible Type xml to XmlB5800UserProfile."));
        throw new RuntimeException("Incompatible Type xml to XmlB5800UserProfile.");
    }

    private void updateBulkImportJobMap(String jobId, String deviceName) {
        String self = "AbgUserProfileXmlConverter.updateBulkImportJobMap():";
        if (jobId != null && deviceName != null) {
            try {
                if (this.abgUserProfileService == null) {
                    this.abgUserProfileService = ABGUPMUtil.getABGUserProfileServiceBean();
                }
                this.abgUserProfileService.addEntryToBulkImportJobMap(jobId, deviceName);
            }
            catch (Exception e) {
                IptcmCommonLogger.error((Object)ABGLoggerTypes.DEBUG, (Object)(self + "Could not update device Name " + deviceName + " for jobId " + jobId + ".Reason:" + e.getMessage()));
                throw new RuntimeException("Could not update device Name " + deviceName + " for jobId " + jobId + ".Reason:" + e.getMessage());
            }
        }
    }
}

