/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.mgmt.upm.sample.ep.conv;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.coreservice.persistence.comm.CsCommProfile;
import com.avaya.coreservice.um.fileimport.comm.CommProfileXMLConverter;
import com.avaya.coreservice.um.xml.XmlCommProfileType;
import com.avaya.mgmt.upm.ps.ep.PsSipEntity;
import com.avaya.mgmt.upm.ps.ep.entities.ImGatewaySipEntityRetriever;
import com.avaya.mgmt.upm.ps.ep.entities.PSCommProfile;
import com.avaya.mgmt.upm.ps.ep.entities.PublishViaAesOption;
import com.avaya.mgmt.upm.ps.ep.entities.SipEntityRetriever;
import com.avaya.mgmt.upm.sample.ep.comm.mock.XmlPsCommProfile;
import com.avaya.panther.config.rts.service.common.entity.ApplicationSystemEntity;
import com.avaya.panther.config.rts.service.model.ApplicationSystem;
import com.avaya.presence.profile.ep.jaxb.PresenceServerRetriever;

public final class PsCommProfileXmlConveter
implements CommProfileXMLConverter {
    public CsCommProfile convertToJPA(XmlCommProfileType xmlCommProfile) {
        ArgAssert.assertNotNull((Object)xmlCommProfile);
        PSCommProfile commProfile = new PSCommProfile();
        this.updatePsCommProfile(commProfile, xmlCommProfile);
        return commProfile;
    }

    public void updateJPA(CsCommProfile existingCommProfile, XmlCommProfileType xmlCommProfile) {
        ArgAssert.assertNotNull((Object)existingCommProfile);
        ArgAssert.assertNotNull((Object)xmlCommProfile);
        if (!(existingCommProfile instanceof PSCommProfile)) {
            throw new RuntimeException("Invalid type: existingCommProfile is not a Presence profile");
        }
        PSCommProfile commProfile = (PSCommProfile)existingCommProfile;
        this.updatePsCommProfile(commProfile, xmlCommProfile);
    }

    private void updatePsCommProfile(PSCommProfile commProfile, XmlCommProfileType xmlCommProfile) {
        if (xmlCommProfile instanceof XmlPsCommProfile) {
            XmlPsCommProfile profile = (XmlPsCommProfile)xmlCommProfile;
            commProfile.setCommProfileType(xmlCommProfile.getCommProfileType());
            ApplicationSystemEntity appSystEntity = this.getApplicationSystemEntity(profile);
            commProfile.setApplicationSystemEntity(appSystEntity);
            PsSipEntity sipEntity = new SipEntityRetriever().getByAssociatedPresenceServer(appSystEntity.getId().longValue());
            commProfile.setprimarySipEntityId(sipEntity.getId());
            String normalizedPublishViaAesCollectorId = PublishViaAesOption.getPublishViaAesOptionId((String)profile.getPublishViaAESCollector());
            commProfile.setpublishViaAESCollector(normalizedPublishViaAesCollectorId);
            String imGatewaySipEntityName = profile.getImGatewaySipEntity();
            if (null == imGatewaySipEntityName || imGatewaySipEntityName.isEmpty()) {
                commProfile.setImGatewaySipEntityId(sipEntity.getId());
            } else {
                PsSipEntity imGatewaySipEntity = new ImGatewaySipEntityRetriever().getByName(imGatewaySipEntityName);
                commProfile.setImGatewaySipEntityId(imGatewaySipEntity.getId());
            }
        } else {
            throw new RuntimeException("Invalid type: xmlCommProfile is not a Presence profile");
        }
    }

    private ApplicationSystemEntity getApplicationSystemEntity(XmlPsCommProfile profile) {
        ApplicationSystemEntity appSystEntity = new ApplicationSystemEntity();
        ApplicationSystem system = new PresenceServerRetriever().get(profile.getSystem());
        appSystEntity.setId(system.getId());
        return appSystEntity;
    }
}

