/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.mgmt.upmcomprof.bulkimport;

import com.avaya.asm.mgmt.elementmgr.commprof.UpmPluginRemotingFacade;
import com.avaya.asm.mgmt.elementmgr.model.AsmAppSet;
import com.avaya.asm.mgmt.elementmgr.model.AsmCommProfile;
import com.avaya.asm.mgmt.elementmgr.model.AsmConfFactorySet;
import com.avaya.asm.mgmt.elementmgr.model.AsmInstance;
import com.avaya.asm.mgmt.elementmgr.model.AsmPolicyAssign;
import com.avaya.asm.mgmt.elementmgr.model.AsmRegionCommunity;
import com.avaya.asm.mgmt.elementmgr.model.AsmRegionCommunityAssign;
import com.avaya.asm.mgmt.elementmgr.model.AsmStorageCluster;
import com.avaya.asm.mgmt.elementmgr.model.AsmUserCommunity;
import com.avaya.asm.mgmt.elementmgr.model.AsmUserCommunityAssign;
import com.avaya.asm.mgmt.upmcomprof.bulkimport.genxml.SessionManagerCommProfXML;
import com.avaya.coreservice.persistence.comm.CsCommProfile;
import com.avaya.coreservice.um.fileimport.comm.CommProfileXMLConverter;
import com.avaya.coreservice.um.xml.XmlCommProfileType;
import com.avaya.mgmt.dmodel.scrush.pojo.Routingorigination;
import com.avaya.mgmt.dmodel.scrush.pojo.Sipentity;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BulkImportXmlToJpaConverter
implements CommProfileXMLConverter {
    protected boolean isEjbSetup = false;
    UpmPluginRemotingFacade upmSrv;
    protected static final String FIXED_POLICY_TYPE = "fixed";
    protected static final String FIXED_REGION_POLICY_TYPE = "fixed-region";
    protected static final String LOCATOIN_REGION_POLICY_TYPE = "location-region";
    protected static final String TYPE_REGION = "region";

    protected void setupRemoteEjb() throws NamingException {
        InitialContext ctx = new InitialContext();
        this.upmSrv = (UpmPluginRemotingFacade)ctx.lookup("java:global/asmelementmgr/asmelementmgr.jar/UpmPluginRemotingFacadeBean!com.avaya.asm.mgmt.elementmgr.commprof.UpmPluginRemotingFacade");
    }

    public CsCommProfile convertToJPA(XmlCommProfileType xmlCommProf) {
        if (!(xmlCommProf instanceof SessionManagerCommProfXML)) {
            String clazz = "";
            if (xmlCommProf != null) {
                clazz = xmlCommProf.getClass().toString();
            }
            throw new RuntimeException("Received unkown CommProfileXMLConverter instance of class " + clazz);
        }
        if (!this.isEjbSetup) {
            try {
                this.setupRemoteEjb();
            }
            catch (NamingException e) {
                throw new RuntimeException("EJB setup failed", e);
            }
            this.isEjbSetup = true;
        }
        SessionManagerCommProfXML asmCommProfXml = (SessionManagerCommProfXML)xmlCommProf;
        AsmCommProfile asmCommProfile = new AsmCommProfile();
        boolean commProfilePolicyEnabled = this.upmSrv.isCommProfilePolicyEnabled();
        String termAppSetName = this.filterXmlStr(asmCommProfXml.getTerminationAppSequence());
        String origAppSetName = this.filterXmlStr(asmCommProfXml.getOriginationAppSequence());
        String confFactorySet = this.filterXmlStr(asmCommProfXml.getConfFactorySet());
        String survivabilitySrvName = this.filterXmlStr(asmCommProfXml.getSurvivabilityServer());
        String homeLocationName = this.filterXmlStr(asmCommProfXml.getHomeLocation());
        String emerTermAppSetName = this.filterXmlStr(asmCommProfXml.getEmergencyTerminationAppSequence());
        String emerOrigAppSetName = this.filterXmlStr(asmCommProfXml.getEmergencyOriginationAppSequence());
        AsmUserCommunity userComm = new AsmUserCommunity();
        if (!commProfilePolicyEnabled) {
            String primarySM = this.filterXmlStr(asmCommProfXml.getPrimarySM());
            String secondarySM = this.filterXmlStr(asmCommProfXml.getSecondarySM());
            if (primarySM != null) {
                AsmUserCommunityAssign sm1Assign = new AsmUserCommunityAssign();
                Sipentity sm1 = new Sipentity();
                sm1.setName(primarySM);
                AsmInstance sm1Asm = new AsmInstance();
                sm1Asm.setSipEntityId(sm1);
                sm1Assign.setAsmInstance(sm1Asm);
                sm1Assign.setAsmUserCommunity(userComm);
                sm1Assign.setPriorityOrder(0);
                userComm.getAsmUserCommunityAssigns().add(sm1Assign);
            }
            if (secondarySM != null) {
                AsmUserCommunityAssign sm2Assign = new AsmUserCommunityAssign();
                Sipentity sm2 = new Sipentity();
                sm2.setName(secondarySM);
                AsmInstance sm2Asm = new AsmInstance();
                sm2Asm.setSipEntityId(sm2);
                sm2Assign.setAsmInstance(sm2Asm);
                sm2Assign.setAsmUserCommunity(userComm);
                sm2Assign.setPriorityOrder(1);
                userComm.getAsmUserCommunityAssigns().add(sm2Assign);
            }
            asmCommProfile.setAsmUserCommunity(userComm);
        } else if (commProfilePolicyEnabled) {
            String policyType = null;
            try {
                policyType = this.filterXmlStr(asmCommProfXml.getPolicyType());
            }
            catch (Exception e) {
                throw new RuntimeException("Policy based assignment of session mangers is enabled but Policy Type could not found");
            }
            if (policyType == null) {
                throw new RuntimeException("Policy based assignment of session mangers is enabled but Policy Type could not found");
            }
            AsmPolicyAssign asmPolicyAssign = this.upmSrv.getPolicyTypeByName(policyType);
            asmCommProfile.setAsmPolicyAssign(asmPolicyAssign);
            if (FIXED_POLICY_TYPE.equalsIgnoreCase(policyType)) {
                String primarySM = this.filterXmlStr(asmCommProfXml.getPrimarySM());
                String secondarySM = this.filterXmlStr(asmCommProfXml.getSecondarySM());
                if (primarySM != null) {
                    AsmUserCommunityAssign sm1Assign = new AsmUserCommunityAssign();
                    Sipentity sm1 = new Sipentity();
                    sm1.setName(primarySM);
                    AsmInstance sm1Asm = new AsmInstance();
                    sm1Asm.setSipEntityId(sm1);
                    sm1Assign.setAsmInstance(sm1Asm);
                    sm1Assign.setAsmUserCommunity(userComm);
                    sm1Assign.setPriorityOrder(0);
                    userComm.getAsmUserCommunityAssigns().add(sm1Assign);
                }
                if (secondarySM != null) {
                    AsmUserCommunityAssign sm2Assign = new AsmUserCommunityAssign();
                    Sipentity sm2 = new Sipentity();
                    sm2.setName(secondarySM);
                    AsmInstance sm2Asm = new AsmInstance();
                    sm2Asm.setSipEntityId(sm2);
                    sm2Assign.setAsmInstance(sm2Asm);
                    sm2Assign.setAsmUserCommunity(userComm);
                    sm2Assign.setPriorityOrder(1);
                    userComm.getAsmUserCommunityAssigns().add(sm2Assign);
                }
                String thirdSM = this.filterXmlStr(asmCommProfXml.getThirdSM());
                String fourthSM = this.filterXmlStr(asmCommProfXml.getFourthSM());
                if (thirdSM != null) {
                    AsmUserCommunityAssign sm3Assign = new AsmUserCommunityAssign();
                    Sipentity sm3 = new Sipentity();
                    sm3.setName(thirdSM);
                    AsmInstance sm3Asm = new AsmInstance();
                    sm3Asm.setSipEntityId(sm3);
                    sm3Assign.setAsmInstance(sm3Asm);
                    sm3Assign.setAsmUserCommunity(userComm);
                    sm3Assign.setPriorityOrder(2);
                    userComm.getAsmUserCommunityAssigns().add(sm3Assign);
                }
                if (fourthSM != null) {
                    AsmUserCommunityAssign sm4Assign = new AsmUserCommunityAssign();
                    Sipentity sm4 = new Sipentity();
                    sm4.setName(fourthSM);
                    AsmInstance sm4Asm = new AsmInstance();
                    sm4Asm.setSipEntityId(sm4);
                    sm4Assign.setAsmInstance(sm4Asm);
                    sm4Assign.setAsmUserCommunity(userComm);
                    sm4Assign.setPriorityOrder(3);
                    userComm.getAsmUserCommunityAssigns().add(sm4Assign);
                }
                asmCommProfile.setAsmUserCommunity(userComm);
            } else if (FIXED_REGION_POLICY_TYPE.equalsIgnoreCase(policyType)) {
                AsmRegionCommunity asmRegionCommunity = new AsmRegionCommunity();
                String primaryFixedRegion = this.filterXmlStr(asmCommProfXml.getPrimaryFixedRegion());
                String secondaryFixedRegion = this.filterXmlStr(asmCommProfXml.getSecondaryFixedRegion());
                String thirdFixedRegion = this.filterXmlStr(asmCommProfXml.getThirdFixedRegion());
                String fourthFixedRegion = this.filterXmlStr(asmCommProfXml.getFourthFixedRegion());
                if (primaryFixedRegion != null) {
                    AsmRegionCommunityAssign region1Assign = new AsmRegionCommunityAssign();
                    AsmStorageCluster asmStorageCluster1 = new AsmStorageCluster();
                    asmStorageCluster1.setName(primaryFixedRegion);
                    asmStorageCluster1.setClusterType(TYPE_REGION);
                    region1Assign.setAsmStorageCluster(asmStorageCluster1);
                    region1Assign.setAsmRegionCommunity(asmRegionCommunity);
                    region1Assign.setPriorityOrder(0);
                    asmRegionCommunity.getAsmRegionCommunityAssign().add(region1Assign);
                }
                if (secondaryFixedRegion != null) {
                    AsmRegionCommunityAssign region2Assign = new AsmRegionCommunityAssign();
                    AsmStorageCluster asmStorageCluster2 = new AsmStorageCluster();
                    asmStorageCluster2.setName(secondaryFixedRegion);
                    asmStorageCluster2.setClusterType(TYPE_REGION);
                    region2Assign.setAsmStorageCluster(asmStorageCluster2);
                    region2Assign.setAsmRegionCommunity(asmRegionCommunity);
                    region2Assign.setPriorityOrder(1);
                    asmRegionCommunity.getAsmRegionCommunityAssign().add(region2Assign);
                }
                if (thirdFixedRegion != null) {
                    AsmRegionCommunityAssign region3Assign = new AsmRegionCommunityAssign();
                    AsmStorageCluster asmStorageCluster3 = new AsmStorageCluster();
                    asmStorageCluster3.setName(thirdFixedRegion);
                    asmStorageCluster3.setClusterType(TYPE_REGION);
                    region3Assign.setAsmStorageCluster(asmStorageCluster3);
                    region3Assign.setAsmRegionCommunity(asmRegionCommunity);
                    region3Assign.setPriorityOrder(2);
                    asmRegionCommunity.getAsmRegionCommunityAssign().add(region3Assign);
                }
                if (fourthFixedRegion != null) {
                    AsmRegionCommunityAssign region4Assign = new AsmRegionCommunityAssign();
                    AsmStorageCluster asmStorageCluster4 = new AsmStorageCluster();
                    asmStorageCluster4.setName(fourthFixedRegion);
                    asmStorageCluster4.setClusterType(TYPE_REGION);
                    region4Assign.setAsmStorageCluster(asmStorageCluster4);
                    region4Assign.setAsmRegionCommunity(asmRegionCommunity);
                    region4Assign.setPriorityOrder(3);
                    asmRegionCommunity.getAsmRegionCommunityAssign().add(region4Assign);
                }
                asmCommProfile.setAsmRegionCommunity(asmRegionCommunity);
            }
        }
        if (termAppSetName != null) {
            AsmAppSet termAppSet = new AsmAppSet();
            termAppSet.setName(termAppSetName);
            asmCommProfile.setAsmAppSetByTermAppSetId(termAppSet);
        }
        if (origAppSetName != null) {
            AsmAppSet origAppSet = new AsmAppSet();
            origAppSet.setName(origAppSetName);
            asmCommProfile.setAsmAppSetByOrigAppSetId(origAppSet);
        }
        if (emerTermAppSetName != null) {
            AsmAppSet emerTermAppSet = new AsmAppSet();
            emerTermAppSet.setName(emerTermAppSetName);
            asmCommProfile.setAsmAppSetByEmerTermAppSetId(emerTermAppSet);
        }
        if (emerOrigAppSetName != null) {
            AsmAppSet emerOrigAppSet = new AsmAppSet();
            emerOrigAppSet.setName(emerOrigAppSetName);
            asmCommProfile.setAsmAppSetByEmerOrigAppSetId(emerOrigAppSet);
        }
        if (confFactorySet != null) {
            AsmConfFactorySet confSet = new AsmConfFactorySet();
            confSet.setName(confFactorySet);
            asmCommProfile.setConfFactorySet(confSet);
        }
        if (survivabilitySrvName != null) {
            Sipentity survivabilitySrv = new Sipentity();
            survivabilitySrv.setName(survivabilitySrvName);
            asmCommProfile.setBsm(survivabilitySrv);
        }
        if (homeLocationName != null) {
            Routingorigination homeLocation = new Routingorigination();
            homeLocation.setName(homeLocationName);
            asmCommProfile.setHomeLocation(homeLocation);
        }
        if (asmCommProfXml.getMaxSimultaneousDevices() == null) {
            asmCommProfile.setMaxSimultaneousDevices(1);
        } else {
            asmCommProfile.setMaxSimultaneousDevices(asmCommProfXml.getMaxSimultaneousDevices().intValue());
        }
        if (asmCommProfXml.isBlockNewRegistrationWhenMaxActive() == null) {
            asmCommProfile.setNewRegBlockedWhenMaxActive(false);
        } else {
            asmCommProfile.setNewRegBlockedWhenMaxActive(asmCommProfXml.isBlockNewRegistrationWhenMaxActive().booleanValue());
        }
        if (asmCommProfXml.isEnabledisablecalllog() == null) {
            asmCommProfile.setEnabledisablecalllog(false);
        } else {
            asmCommProfile.setEnabledisablecalllog(asmCommProfXml.isEnabledisablecalllog().booleanValue());
        }
        return asmCommProfile;
    }

    protected String filterXmlStr(String in) {
        if (in == null || in.isEmpty()) {
            return null;
        }
        return in;
    }

    public void updateJPA(CsCommProfile existingProf, XmlCommProfileType newProfXml) {
        AsmCommProfile newProf = (AsmCommProfile)this.convertToJPA(newProfXml);
        if (!this.upmSrv.isCommProfilePolicyEnabled()) {
            ((AsmCommProfile)existingProf).setAsmUserCommunity(newProf.getAsmUserCommunity());
        } else if (this.upmSrv.isCommProfilePolicyEnabled()) {
            ((AsmCommProfile)existingProf).setAsmPolicyAssign(newProf.getAsmPolicyAssign());
            if (FIXED_REGION_POLICY_TYPE.equalsIgnoreCase(newProf.getAsmPolicyAssign().getPolicyType())) {
                ((AsmCommProfile)existingProf).setAsmRegionCommunity(newProf.getAsmRegionCommunity());
            } else if (!LOCATOIN_REGION_POLICY_TYPE.equalsIgnoreCase(newProf.getAsmPolicyAssign().getPolicyType())) {
                ((AsmCommProfile)existingProf).setAsmUserCommunity(newProf.getAsmUserCommunity());
            }
        }
        ((AsmCommProfile)existingProf).setAsmAppSetByOrigAppSetId(newProf.getAsmAppSetByOrigAppSetId());
        ((AsmCommProfile)existingProf).setAsmAppSetByTermAppSetId(newProf.getAsmAppSetByTermAppSetId());
        ((AsmCommProfile)existingProf).setAsmAppSetByEmerOrigAppSetId(newProf.getAsmAppSetByEmerOrigAppSetId());
        ((AsmCommProfile)existingProf).setAsmAppSetByEmerTermAppSetId(newProf.getAsmAppSetByEmerTermAppSetId());
        ((AsmCommProfile)existingProf).setBsm(newProf.getBsm());
        ((AsmCommProfile)existingProf).setHomeLocation(newProf.getHomeLocation());
        ((AsmCommProfile)existingProf).setConfFactorySet(newProf.getConfFactorySet());
        ((AsmCommProfile)existingProf).setMaxSimultaneousDevices(newProf.getMaxSimultaneousDevices());
        ((AsmCommProfile)existingProf).setNewRegBlockedWhenMaxActive(newProf.isNewRegBlockedWhenMaxActive());
        ((AsmCommProfile)existingProf).setEnabledisablecalllog(newProf.isEnabledisablecalllog());
    }
}

