/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.mgmt.upmcomprof.bulkimport;

import com.avaya.asm.mgmt.elementmgr.commprof.UpmPluginRemotingFacade;
import com.avaya.asm.mgmt.elementmgr.model.AsmCommProfile;
import com.avaya.asm.mgmt.upmcomprof.bulkimport.genxml.SessionManagerCommProfXML;
import com.avaya.coreservice.persistence.comm.CsCommProfile;
import com.avaya.coreservice.um.export.comm.CommProfileJPAConverter;
import com.avaya.coreservice.um.xml.XmlCommProfileType;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class BulkExportJpaToXmlConverter
implements CommProfileJPAConverter {
    protected boolean isEjbSetup = false;
    UpmPluginRemotingFacade upmSrv;

    protected void setupRemoteEjb() throws NamingException {
        InitialContext ctx = new InitialContext();
        this.upmSrv = (UpmPluginRemotingFacade)ctx.lookup("java:global/asmelementmgr/asmelementmgr.jar/UpmPluginRemotingFacadeBean!com.avaya.asm.mgmt.elementmgr.commprof.UpmPluginRemotingFacade");
    }

    public XmlCommProfileType convertToXML(CsCommProfile cprofile) {
        if (!this.isEjbSetup) {
            try {
                this.setupRemoteEjb();
            }
            catch (NamingException e) {
                throw new RuntimeException("EJB setup failed", e);
            }
            this.isEjbSetup = true;
        }
        if (!(cprofile instanceof AsmCommProfile)) {
            throw new RuntimeException("not an instance of AsmCommProfile");
        }
        Map summary = this.upmSrv.getCommProfileSummary(cprofile.getId());
        boolean commProfilePolicyEnabled = this.upmSrv.isCommProfilePolicyEnabled();
        SessionManagerCommProfXML asmProfXml = new SessionManagerCommProfXML();
        asmProfXml.setCommProfileType("SessionManager");
        asmProfXml.setPolicyType((String)summary.get("POLICY"));
        if (!commProfilePolicyEnabled) {
            asmProfXml.setPrimarySM((String)summary.get("SM1"));
            asmProfXml.setSecondarySM((String)summary.get("SM2"));
        } else if ("fixed".equalsIgnoreCase(asmProfXml.getPolicyType())) {
            asmProfXml.setPrimarySM((String)summary.get("SM1"));
            asmProfXml.setSecondarySM((String)summary.get("SM2"));
            if (commProfilePolicyEnabled) {
                asmProfXml.setThirdSM((String)summary.get("SM3"));
                asmProfXml.setFourthSM((String)summary.get("SM4"));
            }
        } else if ("fixed-region".equalsIgnoreCase(asmProfXml.getPolicyType())) {
            asmProfXml.setPrimaryFixedRegion((String)summary.get("FIXED_REGION1"));
            asmProfXml.setSecondaryFixedRegion((String)summary.get("FIXED_REGION2"));
            asmProfXml.setThirdFixedRegion((String)summary.get("FIXED_REGION3"));
            asmProfXml.setFourthFixedRegion((String)summary.get("FIXED_REGION4"));
        }
        asmProfXml.setHomeLocation((String)summary.get("LOC"));
        asmProfXml.setConfFactorySet((String)summary.get("CONF"));
        asmProfXml.setSurvivabilityServer((String)summary.get("SURV"));
        asmProfXml.setOriginationAppSequence((String)summary.get("AORIG"));
        asmProfXml.setTerminationAppSequence((String)summary.get("ATERM"));
        asmProfXml.setMaxSimultaneousDevices((Integer)summary.get("DEV"));
        asmProfXml.setBlockNewRegistrationWhenMaxActive((Boolean)summary.get("BLOCK"));
        asmProfXml.setEnabledisablecalllog((Boolean)summary.get("EDCALLLOG"));
        asmProfXml.setEmergencyOriginationAppSequence((String)summary.get("AEMERORIG"));
        asmProfXml.setEmergencyTerminationAppSequence((String)summary.get("AEMERTERM"));
        return asmProfXml;
    }
}

