/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.wadl.config.WadlGeneratorConfigLoader;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.server.impl.model.method.ResourceMethod;
import com.sun.jersey.server.impl.uri.PathPattern;
import com.sun.jersey.server.impl.wadl.WadlApplicationContextImpl;
import com.sun.jersey.server.impl.wadl.WadlMethodFactory;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.server.wadl.WadlGenerator;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;

public final class WadlFactory {
    private static final Logger LOGGER = Logger.getLogger(WadlFactory.class.getName());
    private final boolean isWadlEnabled;
    private final WadlGenerator wadlGenerator;

    public WadlFactory(ResourceConfig resourceConfig) {
        this.isWadlEnabled = WadlFactory.isWadlEnabled(resourceConfig);
        this.wadlGenerator = this.isWadlEnabled ? WadlGeneratorConfigLoader.loadWadlGeneratorsFromConfig(resourceConfig) : null;
    }

    public boolean isSupported() {
        return this.isWadlEnabled;
    }

    public WadlApplicationContext createWadlApplicationContext(Set<AbstractResource> rootResources) {
        if (!this.isSupported()) {
            return null;
        }
        return new WadlApplicationContextImpl(rootResources, this.wadlGenerator);
    }

    public void init(InjectableProviderFactory ipf, Set<AbstractResource> rootResources) {
        if (!this.isSupported()) {
            return;
        }
        WadlApplicationContextImpl w = new WadlApplicationContextImpl(rootResources, this.wadlGenerator);
        ipf.add(new SingletonTypeInjectableProvider<Context, WadlApplicationContext>(WadlApplicationContext.class, (WadlApplicationContext)w){});
    }

    public ResourceMethod createWadlOptionsMethod(Map<String, List<ResourceMethod>> methods, AbstractResource resource, PathPattern p) {
        if (!this.isSupported()) {
            return null;
        }
        if (p == null) {
            return new WadlMethodFactory.WadlOptionsMethod(methods, resource, null, this.wadlGenerator);
        }
        String path = p.getTemplate().getTemplate().substring(1);
        return new WadlMethodFactory.WadlOptionsMethod(methods, resource, path, this.wadlGenerator);
    }

    private static boolean isWadlEnabled(ResourceConfig resourceConfig) {
        if (resourceConfig.getFeature("com.sun.jersey.config.feature.DisableWADL")) {
            return false;
        }
        try {
            Class.forName("javax.xml.bind.JAXBElement");
            Class<?> jaxbContext = Class.forName("javax.xml.bind.DatatypeConverter");
            Method m = jaxbContext.getMethod("parseInt", String.class);
            m.invoke(null, "1");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.CONFIG, "WADL generation is disabled because JAXB jars are not included in the java class path. To enable WADL include JAXB 2.x jars in the java class path.");
            return false;
        }
        catch (LinkageError e) {
            LOGGER.log(Level.CONFIG, "WADL generation is disabled.", e);
            return false;
        }
        catch (Exception e) {
            LOGGER.log(Level.CONFIG, "WADL generation is disabled.", e);
            return false;
        }
    }
}

