/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.account.profile.ep.jaxb;

import com.avaya.account.profile.ep.jaxb.AccountCommProfileType;
import com.avaya.account.profile.ep.jaxb.AccountPropertiesType;
import com.avaya.account.profile.ep.jaxb.AccountPropertyType;
import com.avaya.account.profile.ep.jaxb.ProfileConversionException;
import com.avaya.account.profile.ep.jpa.AccountCommProfile;
import com.avaya.account.profile.ep.jpa.AccountProperty;
import com.avaya.account.profile.ep.logic.AccountEntityRetrievalFailureException;
import com.avaya.account.profile.ep.logic.TargetNotFoundException;
import com.avaya.account.profile.ep.logic.TargetSupplier;
import com.avaya.account.profile.ep.logic.UpmTargetNameSupplier;
import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.SupplierException;
import com.avaya.coreservice.persistence.comm.CsCommProfile;
import com.avaya.coreservice.um.export.comm.CommProfileJPAConverter;
import com.avaya.coreservice.um.xml.XmlCommProfileType;
import com.avaya.quantumapi.ManagedElementNameByIdSupplier;
import com.avaya.quantumapi.ManagedElementNameSupplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class AccountCommProfileJPAConverter
implements CommProfileJPAConverter {
    private static final Logger LOG = Logger.getLogger(AccountCommProfileJPAConverter.class);
    private final ManagedElementNameSupplier<String> upmElementNameSupplier;
    private final TargetSupplier upmTargetNameSupplier;

    public AccountCommProfileJPAConverter() {
        this((ManagedElementNameSupplier<String>)new ManagedElementNameByIdSupplier(), (TargetSupplier)new UpmTargetNameSupplier());
    }

    AccountCommProfileJPAConverter(ManagedElementNameSupplier<String> upmElementNameSupplier, TargetSupplier upmTargetNameSupplier) {
        ArgAssert.assertNotNull(upmElementNameSupplier, (String)"upmElementNameSupplier");
        ArgAssert.assertNotNull((Object)upmTargetNameSupplier, (String)"upmTargetNameSupplier");
        this.upmElementNameSupplier = upmElementNameSupplier;
        this.upmTargetNameSupplier = upmTargetNameSupplier;
    }

    public XmlCommProfileType convertToXML(CsCommProfile csCommProfile) {
        ArgAssert.assertNotNull((Object)csCommProfile, (String)"csCommProfile");
        AccountCommProfileType xmlCommProfile = new AccountCommProfileType();
        if (!(csCommProfile instanceof AccountCommProfile)) {
            throw new ProfileConversionException("Failed to convert CsCommProfile to XML, expected AccountCommProfile: " + csCommProfile);
        }
        AccountCommProfile commProfile = (AccountCommProfile)csCommProfile;
        String commProfileType = commProfile.getCommProfileType();
        xmlCommProfile.setCommProfileType(commProfileType);
        xmlCommProfile.setServiceType(commProfileType);
        xmlCommProfile.setTemplate(commProfile.getTemplate());
        String elementId = commProfile.getElement();
        String elementName = this.getElementName(elementId);
        xmlCommProfile.setElement(elementName);
        String targetId = commProfile.getTarget();
        String targetName = this.getTargetName(elementId, targetId);
        xmlCommProfile.setTarget(targetName);
        xmlCommProfile.setServiceDetails(commProfile.getServiceDetails());
        xmlCommProfile.setAccountDetails(commProfile.getAccountDetails());
        this.setAccountProperties(xmlCommProfile, commProfile);
        xmlCommProfile.setPublished(commProfile.isPublished());
        xmlCommProfile.setToBeDeleted(commProfile.isToBeDeleted());
        return xmlCommProfile;
    }

    private String getTargetName(String elementId, String targetId) {
        try {
            return this.upmTargetNameSupplier.get(elementId, targetId);
        }
        catch (AccountEntityRetrievalFailureException e) {
            String errorMessage = "Failed to access the system to get the target name";
            this.logMessage((Exception)((Object)e), "Failed to access the system to get the target name");
            return this.getErrorMessageForXmlElement("Failed to access the system to get the target name");
        }
        catch (TargetNotFoundException e) {
            String errorMessage = "The target no longer exists in the system";
            this.logMessage((Exception)((Object)e), "The target no longer exists in the system");
            return this.getErrorMessageForXmlElement("The target no longer exists in the system");
        }
    }

    private String getErrorMessageForXmlElement(String errorMessage) {
        return "Error: " + errorMessage;
    }

    private void logMessage(Exception e, String errorMessage) {
        LOG.warn((Object)errorMessage, (Throwable)e);
    }

    private String getElementName(String elementId) {
        try {
            return this.upmElementNameSupplier.get((Object)elementId);
        }
        catch (SupplierException e) {
            String errorMessage = "Failed to get the system name from the inventory of managed systems";
            this.logMessage((Exception)((Object)e), "Failed to get the system name from the inventory of managed systems");
            return this.getErrorMessageForXmlElement("Failed to get the system name from the inventory of managed systems");
        }
    }

    private void setAccountProperties(AccountCommProfileType xmlCommProfile, AccountCommProfile commProfile) {
        ArrayList accountProperties = Lists.newArrayList((Iterable)commProfile.getAccountProperties());
        AccountPropertiesType propertiesType = new AccountPropertiesType();
        xmlCommProfile.setProperties(propertiesType);
        List<AccountPropertyType> xmlaccountProperties = propertiesType.getProperty();
        for (AccountProperty accountProperty : accountProperties) {
            AccountPropertyType propertyType = new AccountPropertyType();
            propertyType.setName(accountProperty.getPropertyName());
            propertyType.setValue(accountProperty.getPropertyValue());
            xmlaccountProperties.add(propertyType);
        }
    }
}

