/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.mgmt.upm.sample.ep.conv;

import com.avaya.mgmt.upm.ps.ep.entities.GroupEntityListSupplier;
import com.avaya.presence.PsCommProfileGroup;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class GroupsParser {
    private static final String DELIMITER = ",";

    private GroupsParser() {
    }

    public static Set<PsCommProfileGroup> getGroups(String commaSeparatedGroups) {
        if (StringUtils.isBlank((CharSequence)commaSeparatedGroups)) {
            return new HashSet<PsCommProfileGroup>();
        }
        HashSet selectedGroups = Sets.newHashSet((Object[])StringUtils.split((String)commaSeparatedGroups, (String)DELIMITER));
        return selectedGroups.stream().map(new StringToGroupConverter()).collect(Collectors.toSet());
    }

    public static String getGroups(Set<PsCommProfileGroup> groups) {
        if (groups == null || groups.isEmpty()) {
            return "";
        }
        Set groupNames = groups.stream().map(it -> it.getName()).collect(Collectors.toSet());
        return StringUtils.join(groupNames, (String)DELIMITER);
    }

    private static class StringToGroupConverter
    implements Function<String, PsCommProfileGroup> {
        private final Map<String, PsCommProfileGroup> availableGroups = GroupEntityListSupplier.getService().getAll().stream().collect(Collectors.toMap(it -> it.getName().toLowerCase(), it -> it));

        @Override
        public PsCommProfileGroup apply(String groupName) {
            return this.getGroup(groupName.trim().toLowerCase());
        }

        private PsCommProfileGroup getGroup(String groupName) {
            if (StringUtils.isBlank((CharSequence)groupName)) {
                throw new RuntimeException("Group name is blank, please check that there extra commas in the group names.");
            }
            PsCommProfileGroup group = this.availableGroups.get(groupName);
            if (group != null) {
                return group;
            }
            throw new RuntimeException("Group name '" + groupName + "' does not exist, please recheck the import file for invalid group name.");
        }
    }
}

