package com.avaya.mgmt.smgr.webservice.jaxb.impl;

import java.util.List;
import java.util.Properties;

import com.avaya.mgmt.smgr.webservice.jaxb.util.UserMgmtClientUtil;

/**
 * 
 * @author
 * 
 */
public class FindProcess extends AbstractProcess
{

	@Override
	public void processOepration(final Properties properties) throws Exception
	{
		System.out.println("Processing user data (find)...");
		final String queryUrl = UserMgmtClientUtil.createQuery(properties
				.getProperty("user.criteria"));
		final String result = webServiceClient.lookup(
				properties.getProperty("entity.type"), queryUrl);
		System.out.println("Initializing user find process..." + result);
		final List<String> loginNameList = UserMgmtClientUtil
				.getLoginNames(result);
		for (String loginName : loginNameList)
		{
			System.out.println("Sending find request to the server, "
					+ loginName + "...");
			System.out.println(webServiceClient.find(
					properties.getProperty("entity.type"), loginName));
		}
	}
}
