package com.avaya.mgmt.smgr.webservice.jaxb.impl;

import java.io.IOException;
import java.util.Properties;

import javax.xml.bind.JAXBException;

import com.avaya.coreservice.um.xml.Users;
import com.avaya.coreservice.um.xml.XmlCommProfileSetType;
import com.avaya.coreservice.um.xml.XmlCommProfileSetType.CommProfileList;
import com.avaya.coreservice.um.xml.XmlUser;
import com.avaya.iptcm.eps.upm.bulkimportexport.jaxbgen.station.XmlButtonData;
import com.avaya.iptcm.eps.upm.bulkimportexport.jaxbgen.station.XmlStationProfile;
import com.avaya.mgmt.smgr.webservice.jaxb.util.UserMgmtClientUtil;

/**
 * 
 * @author
 * 
 */
public class CreateProcess extends AbstractProcess {

	@Override
	public void processOepration(final Properties properties) throws Exception {
		String requestType = properties.getProperty("request.type");
		if (null != requestType && requestType.trim().length() > 0
				&& requestType.equalsIgnoreCase(MULTIPLE_REQUEST)) {
			multipleRequest(properties);
		} else {
			singleRequest(properties);
		}
	}

	/**
	 * 
	 * @param offsetIndex
	 * @param stationExtensionIndex
	 * @throws JAXBException
	 * @throws IOException
	 */
	private void singleRequest(final Properties properties)
			throws JAXBException, IOException {
		int[] indexes = UserMgmtClientUtil.getRangeIndex(properties
				.getProperty("user.criteria"));
		int startIndex = indexes[0];
		int offsetIndex = indexes[1];
		offsetIndex = startIndex + offsetIndex;
		final Users users = objectFactoryUser.createUsers();
		for (int i = startIndex; i < offsetIndex; i++) {
			users.getUser().add(createUser("" + i, properties));
			// Some logic to keep unique station extension per user
			int stationExtension = Integer.valueOf(properties
					.getProperty("station.extension.start.index"));
			properties.setProperty("station.extension.start.index", ""
					+ (++stationExtension));
		}
		final String userXmlData = UserMgmtClientUtil.toStringUser(users);
		System.out.println("Sending create request to the server..."
				+ userXmlData);
		final String result = webServiceClient.postUser(
				(String) properties.getProperty("entity.type"), userXmlData);
		System.out.println(result);
	}

	/**
	 * 
	 * @param offsetIndex
	 * @param stationExtensionIndex
	 * @throws JAXBException
	 * @throws IOException
	 */
	private void multipleRequest(final Properties properties)
			throws JAXBException, IOException {
		int[] indexes = UserMgmtClientUtil.getRangeIndex(properties
				.getProperty("user.criteria"));
		int startIndex = indexes[0];
		int offsetIndex = indexes[1];
		;
		offsetIndex = startIndex + offsetIndex;
		for (int i = startIndex; i < offsetIndex; i++) {
			final Users users = objectFactoryUser.createUsers();
			users.getUser().add(createUser("" + i, properties));
			// Some logic to keep unique station extension per user
			int stationExtension = Integer.valueOf(properties
					.getProperty("station.extension.start.index"));
			properties.setProperty("station.extension.start.index", ""
					+ (++stationExtension));

			final String userXmlData = UserMgmtClientUtil.toStringUser(users);
			System.out.println("Sending create request to the server...");
			final String result = webServiceClient
					.postUser((String) properties.getProperty("entity.type"),
							userXmlData);
			System.out.println(result);
		}
	}

	/**
	 * 
	 * @param postfix
	 * @param condtionalMap
	 * @return
	 */
	private XmlUser createUser(final String postfix, final Properties properties) {
		final XmlUser xmlUser = new UserDetail().getXmlUser(postfix);

		if (properties.getProperty("user.create.type").equals(
				AbstractProcess.MANDATORY_ATTRIBUTE)) {
			return xmlUser;
		}

		final XmlCommProfileSetType xmlCommProfileSetType = objectFactoryUser
				.createXmlCommProfileSetType();
		xmlCommProfileSetType.setCommProfileSetName("commprofilesetname");
		xmlCommProfileSetType.setIsPrimary(true);
		final CommProfileList commProfileList = objectFactoryUser
				.createXmlCommProfileSetTypeCommProfileList();

		// Add communication profile to the list
		if (properties.getProperty("user.create.type").equals(
				AbstractProcess.STATION_ATTRIBUTE)
				|| properties.getProperty("user.create.type").equals(
						AbstractProcess.ALL_ATTRIBUTE)) {
			commProfileList.getCommProfile()
					.add(new EndPointCommprofile()
							.getStationCommprofile(properties));
		}

		xmlCommProfileSetType.setCommProfileList(commProfileList);
		xmlUser.getCommProfileSet().add(xmlCommProfileSetType);

		return xmlUser;
	}

	/**
	 * 
	 * @author
	 * 
	 */
	private class UserDetail {
		private XmlUser getXmlUser(final String postfix) {
			XmlUser xmlUser = objectFactoryUser.createXmlUser();
			xmlUser.setAuthenticationType("BASIC");
			xmlUser.setGivenName("John" + postfix);
			xmlUser.setSurname("Miller" + postfix);
			xmlUser.setLoginName("loginname" + postfix + "@avaya.com");
			xmlUser.setUserPassword("password");
			xmlUser.setCommPassword("commpassword");
			return xmlUser;
		}
	}

	/**
	 * 
	 * @author
	 * 
	 */
	private class EndPointCommprofile {

		/**
		 * 
		 * @param condtionalMap
		 * @return
		 */
		private XmlStationProfile getStationCommprofile(
				final Properties properties) {
			int stationExtension = Integer.valueOf(""
					+ properties.getProperty("station.extension.start.index"));

			XmlStationProfile xmlStationProfile = objectFactoryStation
					.createXmlStationProfile();
			xmlStationProfile.setCommProfileType("CM");
			xmlStationProfile.setCmName("CM-148.147.168.210");
			xmlStationProfile.setUseExistingExtension(false);
			xmlStationProfile.setExtension("" + stationExtension);

			xmlStationProfile.setSetType("9650SIP");

			xmlStationProfile.setSecurityCode("78974231");
			xmlStationProfile.setPort("IP");
			xmlStationProfile.setDeleteOnUnassign(true);
			// xmlStationProfile.setCoveragePath1("9999");

			xmlStationProfile.setTn(1);
			xmlStationProfile.setCor(10);
			xmlStationProfile.setCos(4);

			XmlButtonData xmlButtonData1 = objectFactoryStation
					.createXmlButtonData();
			xmlButtonData1.setNumber(1);
			xmlButtonData1.setType("call-appr");
			xmlStationProfile.getButtons().add(xmlButtonData1);

			XmlButtonData xmlButtonData2 = objectFactoryStation
					.createXmlButtonData();
			xmlButtonData2.setNumber(8);
			xmlButtonData2.setType("call-appr");
			xmlStationProfile.getButtons().add(xmlButtonData2);

			XmlButtonData xmlButtonData3 = objectFactoryStation
					.createXmlButtonData();
			xmlButtonData3.setNumber(1);
			xmlButtonData3.setType("call-appr");
			xmlStationProfile.getFeatureButtons().add(xmlButtonData3);

			xmlStationProfile.setSipTrunk("aar");
			return xmlStationProfile;
		}
	}
}
