package com.avaya.mgmt.smgr.webservice.jaxb.util;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;

/**
 * 
 * @author
 * 
 */
public class NamespacePrefixMapperImpl extends NamespacePrefixMapper
{

	/**
	 * 
	 */
	private static final String DEFAULT_NS = "tns";

	private static final String DELTA_NS = "delta";
	
	private static final String IPT_NS = "ipt";

	private static final String ASM_NS = "asm";

	private static final String IMPORT_NS = "http://xml.avaya.com/schema/import";

	private static final String IMPORT_DELTA = "http://xml.avaya.com/schema/deltaImport";

	private static final String IMPORT_IPT = "http://xml.avaya.com/schema/import_csm_cm";

	private static final String IMPORT_ASM = "http://xml.avaya.com/schema/import_sessionmanager";
	
	/**
	 * 
	 */
	public String getPreferredPrefix(String nameSpaceURI, String suggestion,
			boolean requirePrefix)
	{
		if ("http://www.w3.org/2001/XMLSchema-instance".equals(nameSpaceURI))
			return "xsi";
		if (IMPORT_DELTA.equals(nameSpaceURI))
			return DELTA_NS;
		if (IMPORT_IPT.equals(nameSpaceURI))
			return IPT_NS;
		if (IMPORT_ASM.equals(nameSpaceURI))
			return ASM_NS;

		if (IMPORT_NS.equals(nameSpaceURI))
			return DEFAULT_NS;

		return DEFAULT_NS;
	}

	/**
  * 
  */
	public String[] getPreDeclaredNamespaceUris()
	{
		return new String[]
		{ IMPORT_NS };
	}
}