package com.avaya.mgmt.smgr.webservice.jaxb.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

import com.avaya.mgmt.smgr.webservice.jaxb.ProcessType;
import com.avaya.mgmt.smgr.webservice.jaxb.impl.UserMgmtTypeFactory;
import com.avaya.mgmt.smgr.webservice.jaxb.util.PROCESS_TYPE;

/**
 *
 * @author
 *
 */
public class UserMgmtClient {

	final UserMgmtTypeFactory userMgmtTypeFactory = new UserMgmtTypeFactory();

	/**
	 *
	 * @param type
	 * @throws Exception
	 */
	void process(final PROCESS_TYPE type, final Properties properties) throws Exception {
		ProcessType processType = userMgmtTypeFactory.getProcessType(type);
		processType.process(properties);
	}

	/**
	 *
	 * @param propertyFile
	 * @return
	 * @throws IOException
	 */
	public Properties loadProperties(final String propertyFile) throws IOException {
		final Properties properties = new Properties();
		InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propertyFile);
		if (null != inputStream) {
			properties.load(inputStream);
		}

		return properties;
	}

	/**
	 *
	 * @param value
	 * @return
	 */
	public PROCESS_TYPE getProcessType(final String value) {

		return PROCESS_TYPE.valueOf(value);
	}

	/**
	 *
	 * @param args
	 */
	public static void main(String[] args) {
		final String CLIENT_CONFIG = "client.properties";
		try {
			final UserMgmtClient userMgmtClient = new UserMgmtClient();
			Properties properties = userMgmtClient.loadProperties(CLIENT_CONFIG);

			final PROCESS_TYPE type = userMgmtClient.getProcessType(properties.getProperty("operation.type"));
			Date startDate = Calendar.getInstance().getTime();
			System.out.println(startDate);
			userMgmtClient.process(type, properties);
			Date endDate = Calendar.getInstance().getTime();
			System.out.println(startDate + "::::::::::" + endDate + "" + (endDate.getTime() - startDate.getTime()));
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
}
