package com.avaya.mgmt.smgr.webservice.jaxb.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.avaya.coreservice.um.xml.ObjectFactory;
import com.avaya.mgmt.smgr.webservice.client.WebServiceClient;
import com.avaya.mgmt.smgr.webservice.client.ds.WebServiceClientConfig;
import com.avaya.mgmt.smgr.webservice.jaxb.ProcessType;

/**
 *
 * @author
 *
 */
public abstract class AbstractProcess implements ProcessType
{
	public final static String SINGLE_REQUEST = "single";

	public final static String MULTIPLE_REQUEST = "multiple";

	public final static String ALL_ATTRIBUTE = "all";

	public final static String MANDATORY_ATTRIBUTE = "mandatory";

	public final static String STATION_ATTRIBUTE = "station";

	protected ObjectFactory objectFactoryUser = new ObjectFactory();

	protected com.avaya.iptcm.eps.upm.bulkimportexport.jaxbgen.station.ObjectFactory objectFactoryStation = new com.avaya.iptcm.eps.upm.bulkimportexport.jaxbgen.station.ObjectFactory();

//	protected com.avaya.asm.mgmt.upmcomprof.bulkimport.genxml.ObjectFactory objectFactorySessionManager = new com.avaya.asm.mgmt.upmcomprof.bulkimport.genxml.ObjectFactory();

	protected WebServiceClient webServiceClient;

	private String baseURL = "";

	private String selfprovisionBaseURL = "";

	private String trustStorePath = "";

	private String trustStorePassword = "";

	private String username = "";

	private String password = "";

	private final String BUNDLE_CONFIG = "config.properties";

	/**
	 * @throws IOException
	 *
	 */
	protected AbstractProcess()
	{
		try
		{
			init();
		} catch (IOException e)
		{
			e.printStackTrace();
		}
		WebServiceClientConfig webServiceClientConfig = new WebServiceClientConfig(
				getTrustStorePath(), getTrustStorePassword(), getUsername(),
				getPassword(), getBaseURL(), getSelfprovisionBaseURL());
		webServiceClient = WebServiceClient.getInstance(webServiceClientConfig);
	}

	/**
	 *
	 * @throws IOException
	 */
	private void init() throws IOException
	{
		Properties properties = loadProperties(BUNDLE_CONFIG);
		setBaseURL(properties.getProperty("baseURL"));
		setSelfprovisionBaseURL(properties.getProperty("selfprovisionBaseURL"));
		setTrustStorePath(properties.getProperty("trustStorePath"));
		setTrustStorePassword(properties.getProperty("trustStorePassword"));
		setUsername(properties.getProperty("username"));
		setPassword(properties.getProperty("password"));
	}

	/**
	 *
	 * @param propertyFile
	 * @return
	 * @throws IOException
	 */
	private Properties loadProperties(String propertyFile) throws IOException
	{
		final Properties properties = new Properties();
		InputStream inputStream = this.getClass().getClassLoader()
				.getResourceAsStream(propertyFile);
		if (null != inputStream)
		{
			properties.load(inputStream);
		}

		return properties;
	}

	@Override
	public void process(final Properties properties)
			throws Exception
	{
		processOepration(properties);
		webServiceClient.destroy();
		System.out.println("Process completed...");
	}

	/**
	 *
	 * @throws Exception
	 */
	abstract void processOepration(Properties properties)
			throws Exception;

	/**
	 *
	 * @return
	 */
	public String getBaseURL()
	{
		return baseURL;
	}

	/**
	 *
	 * @param baseURL
	 */
	public void setBaseURL(String baseURL)
	{
		this.baseURL = baseURL;
	}

	/**
	 *
	 * @return
	 */
	public String getTrustStorePath()
	{
		return trustStorePath;
	}

	/**
	 *
	 * @param trustStorePath
	 */
	public void setTrustStorePath(String trustStorePath)
	{
		this.trustStorePath = trustStorePath;
	}

	/**
	 *
	 * @return
	 */
	public String getTrustStorePassword()
	{
		return trustStorePassword;
	}

	/**
	 *
	 * @param trustStorePassword
	 */
	public void setTrustStorePassword(String trustStorePassword)
	{
		this.trustStorePassword = trustStorePassword;
	}

	/**
	 *
	 * @return
	 */
	public String getUsername()
	{
		return username;
	}

	/**
	 *
	 * @param username
	 */
	public void setUsername(String username)
	{
		this.username = username;
	}

	/**
	 *
	 * @return
	 */
	public String getPassword()
	{
		return password;
	}

	/**
	 *
	 * @param password
	 */
	public void setPassword(String password)
	{
		this.password = password;
	}

	/**
	 * @return the selfprovisionBaseURL
	 */
	public String getSelfprovisionBaseURL() {
		return selfprovisionBaseURL;
	}

	/**
	 * @param selfprovisionBaseURL the selfprovisionBaseURL to set
	 */
	public void setSelfprovisionBaseURL(String selfprovisionBaseURL) {
		this.selfprovisionBaseURL = selfprovisionBaseURL;
	}

}
