package com.avaya.mgmt.smgr.webservice.jaxb.impl;

import java.util.List;
import java.util.Properties;

import com.avaya.coreservice.um.xml.Users;
import com.avaya.coreservice.um.xml.XmlUser;
import com.avaya.mgmt.smgr.webservice.jaxb.util.UserMgmtClientUtil;

/**
 * 
 * @author
 * 
 */
public class UpdateProcess extends AbstractProcess
{

	@Override
	public void processOepration(final Properties properties) throws Exception
	{
		System.out.println("Processing user update data...");
		final String queryUrl = UserMgmtClientUtil.createQuery(properties
				.getProperty("user.criteria"));
		final String result = webServiceClient.lookup(
				properties.getProperty("entity.type"), queryUrl);
		final List<String> loginNameList = UserMgmtClientUtil
				.getLoginNames(result);
		final String updateMode = properties.getProperty("user.update.mode");
		for (String loginName : loginNameList)
		{
			System.out.println("Applying logic to user update data...");
			final String userResult = webServiceClient.find(
					properties.getProperty("entity.type"), loginName);
			System.out.println("userResult " + userResult);
			Users users = UserMgmtClientUtil.getUsers(userResult);
			if (null == users)
			{
				continue;
			}
			List<XmlUser> XmlUserList = users.getUser();
			for (XmlUser xmlUser : XmlUserList)
			{
				xmlUser.setMiddleName("61110002-test");
				
				/*//Sample code to change CM Extension
				List<XmlCommProfileSetType> XmlCommProfileSetType = xmlUser.getCommProfileSet();
				
				for (Iterator iterator = XmlCommProfileSetType.iterator(); iterator.hasNext();) {
					
					XmlCommProfileSetType xmlCommProfileSetType = (XmlCommProfileSetType) iterator.next();
					
					CommProfileList profileList = xmlCommProfileSetType.getCommProfileList();
					
					if(profileList != null) {
						List<XmlCommProfileType> xmlCommProfileList = profileList.getCommProfile();
						XmlCommProfileType commProfileToDelete = null;
						
						for (XmlCommProfileType xmlCommProfile : xmlCommProfileList) {
							if(xmlCommProfile.getCommProfileType().equals("CM")) {
								commProfileToDelete = xmlCommProfile;
								break;
							}
						}
						
						xmlCommProfileList.remove(commProfileToDelete);
					}
				}*/
				
			}
			final String userXmlData = UserMgmtClientUtil.createDeltaXMLData(users);
			System.out.println("Sending update request to the server, "
					+ loginName + "...");
			System.out.println(webServiceClient.putUser(
					properties.getProperty("entity.type"), userXmlData,
					updateMode));
		}
	}
}
