package com.avaya.mgmt.smgr.webservice.jaxb.impl;

import java.util.List;
import java.util.Properties;

import com.avaya.mgmt.smgr.webservice.jaxb.util.UserMgmtClientUtil;

/**
 * 
 * @author
 * 
 */
public class DeleteProcess extends AbstractProcess
{

	@Override
	public void processOepration(final Properties properties) throws Exception
	{
		System.out.println("Processing user delete data...");
		final String queryUrl = UserMgmtClientUtil.createQuery(properties
				.getProperty("user.criteria"));
		final String result = webServiceClient.lookup(
				(String) properties.get("entity.type"), queryUrl);
		System.out.println("Initializing user delete process...");
		final List<String> loginNameList = UserMgmtClientUtil
				.getLoginNames(result);
		loginNameList.remove("admin");
		if (loginNameList.isEmpty())
		{
			System.out.println("No user for specified condition...");
			return;
		}
		properties.put("loginNameList", loginNameList);

		final String requestType = "single";
		if (null != requestType && requestType.trim().length() > 0
				&& requestType.equalsIgnoreCase(MULTIPLE_REQUEST))
		{
			multipleRequest(properties);
		} else
		{
			singleRequest(properties);
		}
	}

	/**
	 * 
	 * @param condtionalMap
	 */
	private void singleRequest(final Properties properties)
	{
		final List<String> loginNameList = (List<String>) properties
				.get("loginNameList");
		final String deleteType = properties.getProperty("user.delete.type");
		final String deleteUserList = UserMgmtClientUtil.createDeleteXmlData(
				loginNameList, deleteType);
		System.out.println("Sending delete request to the server, "
				+ loginNameList + "...");
		final String userResult = webServiceClient.delete(
				(String) properties.get("entity.type"), deleteUserList);
		System.out.println(userResult);
	}

	/**
	 * 
	 * @param condtionalMap
	 */
	private void multipleRequest(final Properties properties)
	{
		final List<String> loginNameList = (List<String>) properties
				.get("loginNameList");
		final String deleteType = (String) properties.get("user.delete.type");
		for (String loginName : loginNameList)
		{
			System.out.println("Sending delete request to the server, "
					+ loginName + "...");
			final String userResult = webServiceClient.delete(
					(String) properties.get("entity.type"), UserMgmtClientUtil
							.createDeleteXmlData(loginName, deleteType));
			System.out.println(userResult);
		}
	}
}
