/* Copyright 2014 Avaya LLC. All rights reserved. */
package sample;

import java.util.HashMap;
import java.util.Map;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.junit.Test;

import com.avaya.mgmt.dmodel.nrp.rs.Adaptations;
import com.avaya.mgmt.dmodel.nrp.rs.DialPatterns;
import com.avaya.mgmt.dmodel.nrp.rs.Domains;
import com.avaya.mgmt.dmodel.nrp.rs.EntityLinks;
import com.avaya.mgmt.dmodel.nrp.rs.Locations;
import com.avaya.mgmt.dmodel.nrp.rs.RegularExpressions;
import com.avaya.mgmt.dmodel.nrp.rs.RoutingPolicies;
import com.avaya.mgmt.dmodel.nrp.rs.RsResult;
import com.avaya.mgmt.dmodel.nrp.rs.SipEntities;
import com.avaya.mgmt.dmodel.nrp.rs.TimeRanges;

public class QueryAll {

	/*
	 * Run queries and marshall all result classes. Have an 
	 * administered item for each resource before running.
	 */
	@SuppressWarnings({ "rawtypes", "serial", "unchecked" })
	@Test
	public void testAll() throws Exception {
		Map<String, Class> resources = new HashMap<String, Class>() {
			{
				put("domains", Domains.class);
				put("locations", Locations.class);
				put("adaptations", Adaptations.class);
				put("sipentities", SipEntities.class);
				put("entitylinks", EntityLinks.class);
				put("timeranges", TimeRanges.class);
				put("routingpolicies", RoutingPolicies.class);
				put("dialpatterns", DialPatterns.class);
				put("regularexpressions", RegularExpressions.class);
				put("originationpatterns", DialPatternOriginations.class);
			}
		};

		for (String resource : resources.keySet()) {
			Class clazz = resources.get(resource);

			Client client = Common.getClient();
			WebTarget target = client.target(Common.URLBASE).path(resource);
			Response response = target.request(MediaType.APPLICATION_XML).get();
			Common.checkError(response);

			/*
			 * In this case we are manually telling what entity type is to be
			 * unmarshalled. Many clients allow registration of the JAXB mapping
			 * classes so this is not needed.
			 */
			RsResult<?> results = response.readEntity(clazz);
			System.out.println("Recieved " + results.getCount() + " of "
					+ results.getTotalcount() + " is a " + clazz + " "
					+ clazz.isInstance(results));
		}
	}

}
