/* Copyright 2017 Avaya LLC. All rights reserved. */
package sample;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.junit.Test;

import com.avaya.asm.mgmt.model.rs.AsmStatus;
import com.avaya.asm.mgmt.model.rs.AsmStatuses;

public class AsmStatusExample {
	/*
	 * Simple query of statuses a re-fetch of first status by entity id.
	 */
	@Test
	public void testStatusGet() throws Exception {
		Client client = Common.getClient();

		/*
		 * Query all statuses.
		 */

		WebTarget target = client.target(Common.URLBASE).path("asmstatuses");
		Response response = target.request(MediaType.APPLICATION_XML).get();
		Common.checkError(response);

		/*
		 * In this case we are manually telling what entity type is to be
		 * unmarshalled. Many clients allow registration of the JAXB mapping
		 * classes so this is not needed.
		 */
		AsmStatuses statuses = response.readEntity(AsmStatuses.class);
		System.out.println("Recieved " + statuses.getCount() + " of " + statuses.getTotalcount() + " statuses");
		for (AsmStatus astatus : statuses.getStatus()) {
			System.out.println("Recieved status for SM: " + astatus.getName());
		}

		/*
		 * Now take first status found and GET based on reference URI. This is
		 * not required, it is just a find of a particular SM status based on
		 * reference URI.
		 */
		AsmStatus status = statuses.getList().get(0);
		target = client.target(status.getLink().getHref());
		response = target.request(MediaType.APPLICATION_XML).get();
		Common.checkError(response);

		AsmStatus status2 = response.readEntity(AsmStatus.class);
		System.out.println("Recieved status for SM: " + status2.getName());
		System.out.println("SM has release: " + status2.getRelease());
		System.out.println("Deny New Service: " + status2.getDenyNewService());

	}
}
