/* Copyright 2017 Avaya LLC. All rights reserved. */
package sample;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.junit.Test;

import com.avaya.asm.mgmt.model.rs.AsmStatus;
import com.avaya.asm.mgmt.model.rs.AsmStatuses;

public class AsmOperationExample {
	/*
	 * Simple query of statuses, then use first link self reference URI to make
	 * operation requests.
	 */
	@Test
	public void testAsmOperation() throws Exception {
		Client client = Common.getClient();

		/*
		 * Query to get first SM URI
		 */
		
		WebTarget target = client.target(Common.URLBASE).path("asmstatuses");
		Response response = target.request(MediaType.APPLICATION_XML).get();
		Common.checkError(response);

		/*
		 * In this case we are manually telling what entity type is to be
		 * unmarshalled. Many clients allow registration of the JAXB mapping
		 * classes so this is not needed.
		 */
		AsmStatuses statuses = response.readEntity(AsmStatuses.class);
		System.out.println("Recieved " + statuses.getCount() + " of "
				+ statuses.getTotalcount() + " statuses");

		/*
		 * Now take first status found and GET based on reference URI.
		 * Let's turn maintenance mode off, and set Accept New Service.
		 * The later is a little odd in that control Accept New Service by
		 * turning "off" Deny New Service.
		 * 
		 * There is no request body nor reply body for these URIs
		 */
		AsmStatus status = statuses.getList().get(0);
		String smuri = status.getLink().getHref().toString();
		target = client.target(smuri + "/maintenanceMode/false");
		response = target.request(MediaType.APPLICATION_XML).post(null);
		Common.checkError(response);
		
		// Give some time to allow for state change and network latency
		Thread.currentThread().sleep(10000);

		/*
		 * The recommended approach for setting this state would be "set and test".
		 * E.g. wait a bit and see if Accept New Service has been entered. There is some delay
		 * since this is an operation request sent through SMGR and then sent to the particular SM. 
		 * Usually takes a few seconds for the SM to stablize the new state.
		 */
		target = client.target(smuri + "/denyNewService/false");
		response = target.request(MediaType.APPLICATION_XML).post(null);
		Common.checkError(response);
	}
}
