Ext.data.JsonP.CCSObject({"tagname":"class","name":"CCSObject","autodetected":{},"files":[{"filename":"ccs-base.js","href":null}],"abstract":true,"members":[{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"HasContactType","tagname":"method","owner":"CCSObject","id":"method-HasContactType","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-CCSObject","short_doc":"The base class for many Contact Control Service objects, defining common methods and properties that apply to many of...","component":false,"superclasses":[],"subclasses":["MobileCCS.BaseInteraction","MobileCCS.BaseMedia","MobileCCS.BaseUser","MobileCCS.Resource","MobileCCS.Session"],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Subclasses</h4><div class='dependency'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='docClass'>MobileCCS.BaseInteraction</a></div><div class='dependency'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='docClass'>MobileCCS.BaseMedia</a></div><div class='dependency'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='docClass'>MobileCCS.BaseUser</a></div><div class='dependency'><a href='#!/api/MobileCCS.Resource' rel='MobileCCS.Resource' class='docClass'>MobileCCS.Resource</a></div><div class='dependency'><a href='#!/api/MobileCCS.Session' rel='MobileCCS.Session' class='docClass'>MobileCCS.Session</a></div></pre><div class='doc-contents'><p>The base class for many Contact Control Service objects, defining common methods and properties that apply to many of the classes.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-ID' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='CCSObject'>CCSObject</span><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-HasContactType' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='CCSObject'>CCSObject</span><br/></div><a href='#!/api/CCSObject-method-HasContactType' class='name expandable'>HasContactType</a>( <span class='pre'>contacttype</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Determines if a particular contact type is supported by the object. ...</div><div class='long'><p>Determines if a particular contact type is supported by the object.  Note that this method only\napplies to objects that contain a <strong>ContactTypes</strong> property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contacttype</span> : String<div class='sub-desc'><p>The contact type to check for (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a>).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the specified contact type is supported.  When called on objects\n                   that do not have a <strong>ContactTypes</strong> property, this method will always return <strong>false</strong>.</p>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='CCSObject'>CCSObject</span><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-updateProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='CCSObject'>CCSObject</span><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='CCSObject'>CCSObject</span><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"abstract":true}});