Ext.data.JsonP.MobileCCS_Client({"tagname":"class","name":"MobileCCS.Client","autodetected":{},"files":[{"filename":"ccs-client.js","href":null}],"params":[{"tagname":"params","type":"String","name":"appname","doc":"<p>Provides the name of the application that is connecting to the server.</p>\n","html_type":"String"},{"tagname":"params","type":"String","name":"profile","doc":"<p>Provides the name of the client profile being requested\n                            (see <a href=\"#!/api/MobileCCS.ClientProfile\" rel=\"MobileCCS.ClientProfile\" class=\"docClass\">ClientProfile</a>).</p>\n","html_type":"String"}],"throws":[{"type":"TypeError","doc":"<p>If the <em>appname</em> or <em>profile</em> argument is anything but a non-empty string.</p>\n","html_type":"TypeError"}],"members":[{"name":"AutoReconnect","tagname":"property","owner":"MobileCCS.Client","id":"property-AutoReconnect","meta":{}},{"name":"ConnectedServer","tagname":"property","owner":"MobileCCS.Client","id":"property-ConnectedServer","meta":{"readonly":true}},{"name":"IsConnected","tagname":"property","owner":"MobileCCS.Client","id":"property-IsConnected","meta":{"readonly":true}},{"name":"IsHA","tagname":"property","owner":"MobileCCS.Client","id":"property-IsHA","meta":{"readonly":true}},{"name":"IsSecure","tagname":"property","owner":"MobileCCS.Client","id":"property-IsSecure","meta":{"readonly":true}},{"name":"Server","tagname":"property","owner":"MobileCCS.Client","id":"property-Server","meta":{}},{"name":"ServerVersion","tagname":"property","owner":"MobileCCS.Client","id":"property-ServerVersion","meta":{"readonly":true}},{"name":"Session","tagname":"property","owner":"MobileCCS.Client","id":"property-Session","meta":{"readonly":true}},{"name":"State","tagname":"property","owner":"MobileCCS.Client","id":"property-State","meta":{"readonly":true}},{"name":"StateError","tagname":"property","owner":"MobileCCS.Client","id":"property-StateError","meta":{"readonly":true}},{"name":"Version","tagname":"property","owner":"MobileCCS.Client","id":"property-Version","meta":{"readonly":true}},{"name":"Connect","tagname":"method","owner":"MobileCCS.Client","id":"method-Connect","meta":{}},{"name":"Disconnect","tagname":"method","owner":"MobileCCS.Client","id":"method-Disconnect","meta":{}},{"name":"SignIn","tagname":"method","owner":"MobileCCS.Client","id":"method-SignIn","meta":{}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.Client","short_doc":"The Client class represents the starting point for gaining access to Contact Control Service functionality. ...","component":false,"superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><div class='doc-contents'><p>The <em>Client</em> class represents the starting point for gaining access to <strong>Contact Control Service</strong> functionality.</p>\n\n<p>To access <strong>Contact Control Service</strong> functionality, the client application must first construct an instance\nof this class.  Once an instance of the <em>Client</em> class has been created, the application uses the methods defined\nin this class to control the connection to the server and an establishment of an authenticated session.</p>\n\n<p>Following creation of a <em>Client</em> object, there is no connection yet created to the server.  In order to connect to\nthe server the application must set the server address using the <a href=\"#!/api/MobileCCS.Client-property-Server\" rel=\"MobileCCS.Client-property-Server\" class=\"docClass\">Server</a> property and then call the <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a>\nmethod to connect to the server and create an authenticated session in one step.</p>\n\n<p>The  created instance of the <em>Client</em> will transition through different ClientState values to notify the application of\nstate changes on the communication link between the client and server;</p>\n\n<p>NOTCONNECTED to CONNECTING,\nCONNECTING to CONNECTED,\nCONNECTED to AUTHENTICATING,\nCONNECTED to AUTHENTICATED\n(see <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">ClientState</a>)</p>\n\n<p>These state transitions are sent to the application in  <em>UPDATE</em> notifications to the Client handler of the <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a> method.</p>\n\n<p><strong>Connection Resiliency</strong>\nIf <em>AutoReconnect</em> is <strong>true</strong>, the <em>Client</em> will attempt to automatically recover the connection to the Contact Control Service if the connection is lost.\nOn loss of the connection, the <em>Client</em> object will transition from <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">AUTHENTICATED</a> to <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">NOTCONNECTED</a>.\nThe <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object representing the previously authenticated session will be deleted and a <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">DELETE</a> notification\nwill be sent to the <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a> Session handler method.\nThe <em>Client</em> is the only object that survives after a loss of connection to the Contact Control Service. On successful reconnection to the Contact Control Service,\nthe API will automatically signin the <em>Client</em> to the Contact Control Service. The application will receive a new authenticated <em>Session</em> as described in the\n<a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a> method. The client will transition through the following states;\n<a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">CONNECTING</a> to <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">CONNECTED</a>,\n<a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">CONNECTED</a> to <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">AUTHENTICATED</a>.</p>\n\n<p>If <em>AutoReconnect</em> is false, the <em>Client</em> will not attempt to automatically recover the connection to the Contact Center server. On loss of the connection the <em>Client</em>\nobject will transition from <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">AUTHENTICATED</a> to <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">NOTCONNECTED</a>.\nThe application is notified of this state change through a NotificationType ERROR notification for the <em>Client</em> object.\nTo connect to the Contact Control Service again, the application must invoke the <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a> method.</p>\n\n<p><strong>High Availability</strong>\nThe following High Availability solutions are supported by the API;\nContact Center Mission Critical High Availability (for Avaya Aura Contact Center) and\nContact Center Business Continuity (for Avaya Contact Center Select).\nSolutions can have Campus High Availability and/or Geographic High Availability. For Geographic HA, a Remote Geographic Node (RGN) is provisioned.\nThe RGN is for disaster recovery scenarios where the Campus (main site) has a complete outage. A switchover to the RGN is manually triggered by administrators\nwhen a sufficient outage is detected.</p>\n\n<p>In a Campus switchover, if an outage occurs on the Active Contact Center server, the solution will automatically switchover to the Standby Contact Center server.\nOn detection of this outage, the <em>Client</em> will automatically switchover to the Standby Contact Center server. This automatic switchover of the <em>Client</em> is managed\ninternally by the API.</p>\n\n<p>In a Geographic switchover, if the entire Campus has an outage, the application will have to manually connect to the fully qualified hostname of the RGN Contact\n Center server. Access to the RGN fully qualified hostname will not be provided to the application by the API. The RGN fully qualified hostname must be made\navailable to the application by other means.</p>\n\n<p>Please see Contact Center solution documentation for information on Business Continuity and Mission Critical High Availability solutions as well as switchover\n behaviors for all solutions. Expected switchover times vary depending on the solution.</p>\n\n<p><strong>Contact Center Mission Critical High Availability (MCHA) Campus</strong>\nWhen connecting to a Contact Center Mission Critical High Availability campus pair, the application must provide the managed hostname of the\nContact Center MCHA pair as the server property on the {link <a href=\"#!/api/MobileCCS.Client\" rel=\"MobileCCS.Client\" class=\"docClass\">MobileCCS.Client</a> Client}. The isHa property defines whether the Contact Center is configured for MCHA.\nThe Contact Center that is currently Active can be retrieved by {link <a href=\"#!/api/MobileCCS.Client-property-ConnectedServer\" rel=\"MobileCCS.Client-property-ConnectedServer\" class=\"docClass\">MobileCCS.Client.ConnectedServer</a> ConnectedServer} property.\nIf security is on and the contact center certificates are generated as per the contact center documentation the hostname of the webserver hosting the custom agent application\nmust be used in the browser URL when browsing to the application.\nIf the webserver hostname FQDN is preferred the contact center certificates must include the contact center managed hostname FQDN in the Subject Alternative Name (SAN) of their\ncertificates and the contact center managed hostname FQDN must be used as the property of the Client object {link <a href=\"#!/api/MobileCCS.Client-property-Server\" rel=\"MobileCCS.Client-property-Server\" class=\"docClass\">MobileCCS.Client.Server</a> Client}.</p>\n\n<p>If the Active Contact Center server has an outage, a switchover will occur and the Standby Contact Center server will take over the Active role. On switchover,\na manual signin to the newly Active Contact Center server is not required by the application. The client will automatically signin to the newly Active Contact Center\nserver (previous Standby server). The ClientState may change from AUTHENTICATED depending on the type of outage that occurred on\nthe Active Contact Center server. If this state transition occurs the client will quickly transition back to ClientState AUTHENTICATED once the Standby Contact\nCenter server has taken over the Active role. A NotificationType UPDATE notification will be sent to the application for the <em>Session</em> object associated with the\nnewly Active Contact Center server (previously the Standby server).</p>\n\n<p><strong>Contact Center Business Continuity (BC) Campus</strong>\nWhen connecting to a Contact Center Business Continuity campus pair, the application must provide the fully qualified managed hostname of the Contact Center\nBC pair as the server argument. The isHa property will return false.</p>\n\n<p>If the Active Contact Center server has an outage, a switchover will occur and the Standby Contact Center server will take over the Active role. On switchover,\na manual signin to the newly Active Contact Center server is not required by the application. The client will automatically signin to the newly Active Contact\nCenter server (previous Standby server). The ClientState will change from ClientState AUTHENTICATED on an outage to the Active Contact Center\nserver. The client will transition to ClientState AUTHENTICATED once the Standby Contact Center server has taken over the Active role.</p>\n\n<p><strong>Contact Center Remote Geographic Node (RGN)</strong>\nFor both High Availability solutions, a Remote Geographic Node server can be provisioned. If a Campus outage occurs, a ClientState AUTHENTICATED to ClientState CONNECTING\nstate change will occur. If it is identified that the Campus has had a complete outage (entire Campus is down), a decision will be made to manually switchover to\nthe RGN. Once this decision has been made and the RGN has taken over, the application must now connect to the RGN. The application must invoke disconnect() to notify\nthe client to cease attempting to connect to the Campus. On successful disconnect, the client will transition to ClientState NOTCONNECTED.\nThe application should then set the server property providing the fully qualified hostname of the RGN. The application should then execute <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a> to connect and signin to the RGN.</p>\n\n<p><strong>Security</strong>\nSecure communication between the client and the Contact Center server is mandatory and is implemented by the use of Secure Web Sockets.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>appname</span> : String<div class='sub-desc'><p>Provides the name of the application that is connecting to the server.</p>\n</div></li><li><span class='pre'>profile</span> : String<div class='sub-desc'><p>Provides the name of the client profile being requested\n                            (see <a href=\"#!/api/MobileCCS.ClientProfile\" rel=\"MobileCCS.ClientProfile\" class=\"docClass\">ClientProfile</a>).</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <em>appname</em> or <em>profile</em> argument is anything but a non-empty string.</p>\n</div></li></ul></div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-AutoReconnect' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-AutoReconnect' class='name expandable'>AutoReconnect</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>By default, failed connection attempts and dropped connections will automatically be reattempted by the Client\nobject. ...</div><div class='long'><p>By default, failed connection attempts and dropped connections will automatically be reattempted by the <em>Client</em>\nobject.  Setting this property to <strong>false</strong> disables this default behavior.</p>\n\n<p>Note that in a High Availability configuration, setting this property <strong>false</strong> will disable the automatic switchover\nof the client to the standby server if the active server fails.</p>\n</div></div></div><div id='property-ConnectedServer' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-ConnectedServer' class='name expandable'>ConnectedServer</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The name of the server that the client is currenty connected to. ...</div><div class='long'><p>The name of the server that the client is currenty connected to.  This may be different from the server name\nset on the <a href=\"#!/api/MobileCCS.Client-property-Server\" rel=\"MobileCCS.Client-property-Server\" class=\"docClass\">Server</a> property when connected to a High Availability campus pair.</p>\n</div></div></div><div id='property-IsConnected' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-IsConnected' class='name expandable'>IsConnected</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Provides an indication of whether or not the client is currently connected to the server. ...</div><div class='long'><p>Provides an indication of whether or not the client is currently connected to the server.  This does not\nnecessarily mean that it is possible to perform actions on the server.  The <a href=\"#!/api/MobileCCS.Client-property-State\" rel=\"MobileCCS.Client-property-State\" class=\"docClass\">State</a> property must\nbe set to <strong>Authenticated</strong> for actions to be carried out on the server.</p>\n</div></div></div><div id='property-IsHA' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-IsHA' class='name expandable'>IsHA</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Provides an indication of whether or not the client object is currently communicating with a High Availability\ncampus...</div><div class='long'><p>Provides an indication of whether or not the client object is currently communicating with a High Availability\ncampus pair of servers.  This property should not be considered valid until the client has connected to the\nserver for the first time (the <a href=\"#!/api/MobileCCS.Client-property-IsConnected\" rel=\"MobileCCS.Client-property-IsConnected\" class=\"docClass\">IsConnected</a> property has been set to <strong>true</strong> for the first time).</p>\n</div></div></div><div id='property-IsSecure' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-IsSecure' class='name expandable'>IsSecure</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides an indication of whether or not the client is currently connected to the server over a secure connection.</p>\n</div><div class='long'><p>Provides an indication of whether or not the client is currently connected to the server over a secure connection.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>A value of <em>true</em> is returned if there is an established connection with the server\n                   and the connection is over a secure WebSocket.</p>\n</div></li></ul></div></div></div><div id='property-Server' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-Server' class='name expandable'>Server</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>The Server property provides the name or address of the server to connect to. ...</div><div class='long'><p>The <em>Server</em> property provides the name or address of the server to connect to.  This property\nmust be set prior to attempting a connection with the server using either the <a href=\"#!/api/MobileCCS.Client-method-Connect\" rel=\"MobileCCS.Client-method-Connect\" class=\"docClass\">Connect</a>\nor <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a>  methods.</p>\n</div></div></div><div id='property-ServerVersion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-ServerVersion' class='name expandable'>ServerVersion</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A string providing the version of the Contact Control Service running on the server. ...</div><div class='long'><p>A string providing the version of the <strong>Contact Control Service</strong> running on the server.</p>\n\n<p>This should only be considered valid when the <a href=\"#!/api/MobileCCS.Client-property-IsConnected\" rel=\"MobileCCS.Client-property-IsConnected\" class=\"docClass\">IsConnected</a> property is <strong>true</strong>.</p>\n</div></div></div><div id='property-Session' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-Session' class='name expandable'>Session</a> : <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">MobileCCS.Session</a><span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The Session property provides access to the Session object created\nas a result of calling the SignIn method on the cl...</div><div class='long'><p>The <em>Session</em> property provides access to the <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object created\nas a result of calling the <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a> method on the client.  This property will be <strong>null</strong>\nwhen there is no authenticated session with the server.</p>\n</div></div></div><div id='property-State' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-State' class='name expandable'>State</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The State property provides the current state of the Client object's connection to the server. ...</div><div class='long'><p>The <em>State</em> property provides the current state of the <em>Client</em> object's connection to the server.</p>\n\n<p>The possible states are provided by the <a href=\"#!/api/MobileCCS.ClientState\" rel=\"MobileCCS.ClientState\" class=\"docClass\">ClientState</a> enumeration.</p>\n</div></div></div><div id='property-StateError' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-StateError' class='name expandable'>StateError</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The StateError property provides the most recent error with respect to the connection to the server. ...</div><div class='long'><p>The <em>StateError</em> property provides the most recent error with respect to the connection to the server.\nIf <strong>null</strong>, either no error has occurred or the connection to the server is fully established following\nrecovery from an error.</p>\n</div></div></div><div id='property-Version' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-property-Version' class='name expandable'>Version</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The Mobile SDK version.</p>\n</div><div class='long'><p>The Mobile SDK version.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-Connect' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-method-Connect' class='name expandable'>Connect</a>( <span class='pre'>handler</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Initiates a connection to the server using the server name set on the Client object's Server property. ...</div><div class='long'><p>Initiates a connection to the server using the server name set on the <em>Client</em> object's <a href=\"#!/api/MobileCCS.Client-property-Server\" rel=\"MobileCCS.Client-property-Server\" class=\"docClass\">Server</a> property.\nThe <em>Connect</em> method takes a callback function argument which notifies the application of connection-level events.\nThe function signature of this callback should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which will be a subset of\nthe values defined in <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>.  Specifically, only the <em>UPDATE</em> and <em>ERROR</em> notification\ntypes will be received. The second argument will be the <em>Client</em> object itself for the <em>UPDATE</em> notification, which serves\nto notify the client that the connection has been established.  For the <em>ERROR</em> notification type, an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a>\nobject will be received, which indicates either a problem with connection establishment, or a disconnect reason.\nThe accompanying <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the cause of the error.</p>\n\n<p>Possible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n        <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServiceUnreachable\" rel=\"MobileCCS.ErrorCode-property-ServiceUnreachable\" class=\"docClass\">ServiceUnreachable</a></td>\n            <td>Failed to establish a connection to the server; the server may be shut down or possible certificate error.</td>\n        </tr>\n    </tbody>\n</table>\n\n\n<p>This method only establishes a connection to the server.  It does perform any authentication of the user's credentials and\ndoes not establish a session with the server.  This method, if used, allows the client application to establish a session with\nthe server in two discrete connection and signin steps.  After the connection is established, the client application can use the\nproperties on this object (notably the <a href=\"#!/api/MobileCCS.Client-property-IsSecure\" rel=\"MobileCCS.Client-property-IsSecure\" class=\"docClass\">IsSecure</a> property) to determine if signin should\nproceed or if other options may need to be set.</p>\n\n<p>Upon notification of a successful connection to the server, the client application can either proceed by calling the\n<a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a>  method or drop the connection by calling <a href=\"#!/api/MobileCCS.Client-method-Disconnect\" rel=\"MobileCCS.Client-method-Disconnect\" class=\"docClass\">Disconnect</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when connection-level events occur.  See above for\n                                       a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a>\n                                       object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>The <strong>handler</strong> argument is not a function.</p>\n</div></li><li><span class='pre'><a href=\"#!/api/MobileCCS.InvalidOperationError\" rel=\"MobileCCS.InvalidOperationError\" class=\"docClass\">MobileCCS.InvalidOperationError</a></span><div class='sub-desc'><p>No server name was set on the <a href=\"#!/api/MobileCCS.Client-property-Server\" rel=\"MobileCCS.Client-property-Server\" class=\"docClass\">Server</a> property or the connection to the server\n                                          has already been established or is in the process of being established.</p>\n</div></li></ul></div></div></div><div id='method-Disconnect' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-method-Disconnect' class='name expandable'>Disconnect</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Disconnects a currently active session and disconnects from the server. ...</div><div class='long'><p>Disconnects a currently active session and disconnects from the server.</p>\n\n<p>After calling <em>Disconnect</em> the client application should not attempt to perform any other operations until\na new connection and/or session is created by calling either the <a href=\"#!/api/MobileCCS.Client-method-Connect\" rel=\"MobileCCS.Client-method-Connect\" class=\"docClass\">Connect</a> or <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a> method.</p>\n</div></div></div><div id='method-SignIn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Client'>MobileCCS.Client</span><br/></div><a href='#!/api/MobileCCS.Client-method-SignIn' class='name expandable'>SignIn</a>( <span class='pre'>userid, password, sessionHandler, [clientHandler]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Signs in to the service using the supplied user credentials. ...</div><div class='long'><p>Signs in to the service using the supplied user credentials.</p>\n\n<p>At least one callback function argument must also be supplied. The mandatory <strong>sessionHandler</strong> callback function notifies the\napplication of session-level events and must have the following signature:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which will be one of\nthe values defined in <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>.  The second argument will be a <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a>\nobject for the <em>NEW</em>, <em>UPDATE</em> and <em>DELETE</em> notification types and an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>NEW</em> notification indicates a successful sign-in to the service and the supplied <em>Session</em>\nobject can then be used to begin communication with the server.  A <em>DELETE</em> notification indicates\nthat the established session has been disconnected, the client should close the session when the DELETE is received as none of the objects are valid anymore.  <em>ERROR</em> notifications indicate either a\nproblem with session establishment, or a reason for the session to become disconnected.\nThe accompanying <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the cause of the error.</p>\n\n<p>Possible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ApplicationNotEnabled\" rel=\"MobileCCS.ErrorCode-property-ApplicationNotEnabled\" class=\"docClass\">ApplicationNotEnabled</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AuthenticationFailure\" rel=\"MobileCCS.ErrorCode-property-AuthenticationFailure\" class=\"docClass\">AuthenticationFailure</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-CommServerOutOfResources\" rel=\"MobileCCS.ErrorCode-property-CommServerOutOfResources\" class=\"docClass\">CommServerOutOfResources</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidCredentials\" rel=\"MobileCCS.ErrorCode-property-InvalidCredentials\" class=\"docClass\">InvalidCredentials</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidParameter\" rel=\"MobileCCS.ErrorCode-property-InvalidParameter\" class=\"docClass\">InvalidParameter</a></td>\n            <td>The supplied user ID is invalid (not in &lt;domain&gt;\\&lt;user&gt; format).</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServiceUnreachable\" rel=\"MobileCCS.ErrorCode-property-ServiceUnreachable\" class=\"docClass\">ServiceUnreachable</a></td>\n            <td>The service on the server is either unreachable, shut down, or could not obtain a license.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-Unauthorized\" rel=\"MobileCCS.ErrorCode-property-Unauthorized\" class=\"docClass\">Unauthorized</a></td>\n        </tr>\n    </tbody>\n</table>\n\n\n<p>The optional <strong>clientHandler</strong> callback function has the same signature as the <strong>sessionHandler</strong> callback but receives only errors\nand updates regarding the <em>Client</em> object, most notably regarding changes in the state of the <em>Client</em> object (see the <a href=\"#!/api/MobileCCS.Client-property-State\" rel=\"MobileCCS.Client-property-State\" class=\"docClass\">State</a> property).\nThis callback receives the same set of notifications as the callback function specified in the <a href=\"#!/api/MobileCCS.Client-method-Connect\" rel=\"MobileCCS.Client-method-Connect\" class=\"docClass\">Connect</a> method.</p>\n\n<p>Note that if the <a href=\"#!/api/MobileCCS.Client-method-Connect\" rel=\"MobileCCS.Client-method-Connect\" class=\"docClass\">Connect</a> method was not called prior to sign-in, the connection to the server will automatically be\nattempted before issuing the sign-in request. In this case, any errors in establishing the connection will be sent to the\ncallback function supplied as the <strong>clientHandler</strong> in the <em>SignIn</em> method.  If no <strong>clientHandler</strong> is specified, these errors are sent\nto the <strong>sessionHandler</strong> callback function instead.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userid</span> : String<div class='sub-desc'><p>The user name to use to log in to the server in the form &lt;domain&gt;\\&lt;user&gt;.</p>\n</div></li><li><span class='pre'>password</span> : String<div class='sub-desc'><p>The user's password.</p>\n</div></li><li><span class='pre'>sessionHandler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when session-level events occur.  See above for\n                                              a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a>\n                                              object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li><li><span class='pre'>clientHandler</span> : Function (optional)<div class='sub-desc'><p>An optional callback function that will be called to notify the application of client-level\n                                              events, such as connection progress updates, and connection errors.  The signature is the\n                                              same as for the <em>sessionHandler</em> argument.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either the <a href=\"#!/api/MobileCCS.Client\" rel=\"MobileCCS.Client\" class=\"docClass\">Client</a>\n                                              object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>One or both of the <strong>userid</strong> and/or <strong>password</strong> arguments is null or empty,\n                                              or the <strong>sessionHandler</strong> argument is not a function.</p>\n</div></li><li><span class='pre'><a href=\"#!/api/MobileCCS.InvalidOperationError\" rel=\"MobileCCS.InvalidOperationError\" class=\"docClass\">MobileCCS.InvalidOperationError</a></span><div class='sub-desc'><p>No server name was set on the <a href=\"#!/api/MobileCCS.Client-property-Server\" rel=\"MobileCCS.Client-property-Server\" class=\"docClass\">Server</a> property or the session\n                                              has already been established or is in the process of being established.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});