Ext.data.JsonP.MobileCCS_EmailMedia({"tagname":"class","name":"MobileCCS.EmailMedia","autodetected":{},"files":[{"filename":"ccs-emailmedia.js","href":null}],"extends":"MobileCCS.BaseMedia","members":[{"name":"ArrivalTime","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ArrivalTime","meta":{"readonly":true}},{"name":"Attachments","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-Attachments","meta":{"readonly":true}},{"name":"BCC","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-BCC","meta":{"readonly":true}},{"name":"Body","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-Body","meta":{"readonly":true}},{"name":"CC","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-CC","meta":{"readonly":true}},{"name":"CanCreate","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-CanCreate","meta":{"readonly":true}},{"name":"CanGetSuggestedResponses","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-CanGetSuggestedResponses","meta":{"readonly":true}},{"name":"CanReply","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-CanReply","meta":{"readonly":true}},{"name":"ContactID","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ContactID","meta":{"readonly":true}},{"name":"ContactType","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ContactType","meta":{"readonly":true}},{"name":"Encoding","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-Encoding","meta":{"readonly":true}},{"name":"From","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-From","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"MailboxAddress","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-MailboxAddress","meta":{"readonly":true}},{"name":"Status","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-Status","meta":{"readonly":true}},{"name":"Subject","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-Subject","meta":{"readonly":true}},{"name":"To","tagname":"property","owner":"MobileCCS.EmailMedia","id":"property-To","meta":{"readonly":true}},{"name":"Create","tagname":"method","owner":"MobileCCS.EmailMedia","id":"method-Create","meta":{}},{"name":"GetAttachmentFile","tagname":"method","owner":"MobileCCS.EmailMedia","id":"method-GetAttachmentFile","meta":{}},{"name":"GetSuggestedResponses","tagname":"method","owner":"MobileCCS.EmailMedia","id":"method-GetSuggestedResponses","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"Reply","tagname":"method","owner":"MobileCCS.EmailMedia","id":"method-Reply","meta":{}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.EmailMedia","short_doc":"The EmailMedia object provides the media associated with Email interactions. ...","component":false,"superclasses":["CCSObject","MobileCCS.BaseMedia"],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='docClass'>MobileCCS.BaseMedia</a><div class='subclass '><strong>MobileCCS.EmailMedia</strong></div></div></div></pre><div class='doc-contents'><p>The <em>EmailMedia</em> object provides the media associated with Email interactions.</p>\n\n<p><em>Media</em> objects are retrieved from the server by calling the <a href=\"#!/api/MobileCCS.Interaction-method-OpenMedia\" rel=\"MobileCCS.Interaction-method-OpenMedia\" class=\"docClass\">OpenMedia</a>\nmethod on the <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object.</p>\n\n<p>The methods available on the <em>EmailMedia</em> object allow the client application to control this media (e.g. send an email reply).</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-ArrivalTime' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ArrivalTime' class='name expandable'>ArrivalTime</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The time at which the interaction associated with this media arrived at the Conatac Center.</p>\n</div><div class='long'><p>The time at which the interaction associated with this media arrived at the Conatac Center.</p>\n</div></div></div><div id='property-Attachments' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-Attachments' class='name expandable'>Attachments</a> : Object[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The Attachments object will be null if there is no Attachments with the contact. ...</div><div class='long'><p>The Attachments object will be null if there is no Attachments with the contact.</p>\n\n<p>The format of the Attachments is an array of Attachment objects.</p>\n\n<p>The format of the <em>Attachment</em> object is as follows:</p>\n\n<ul>\n<li><strong>ID</strong> - ID of the attachment.</li>\n<li><strong>Name</strong> - A String that indicates the name of the attachment.</li>\n<li><strong>Address</strong> - A String that contains the location of the attachment.</li>\n<li><strong>MimeType</strong> - The format of the attachment file.</li>\n<li><strong>Size</strong> - The size of the attachment file.</li>\n</ul>\n\n</div></div></div><div id='property-BCC' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-BCC' class='name expandable'>BCC</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the BCC address of this contact.</p>\n</div><div class='long'><p>Provides the BCC address of this contact.</p>\n</div></div></div><div id='property-Body' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-Body' class='name expandable'>Body</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the email Body of this contact.</p>\n</div><div class='long'><p>Provides the email Body of this contact.</p>\n</div></div></div><div id='property-CC' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-CC' class='name expandable'>CC</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the CC address of this contact.</p>\n</div><div class='long'><p>Provides the CC address of this contact.</p>\n</div></div></div><div id='property-CanCreate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-CanCreate' class='name expandable'>CanCreate</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if an outgoing email can be sent by calling the <a href=\"#!/api/MobileCCS.EmailMedia-method-Create\" rel=\"MobileCCS.EmailMedia-method-Create\" class=\"docClass\">Create</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if an outgoing email can be sent by calling the <a href=\"#!/api/MobileCCS.EmailMedia-method-Create\" rel=\"MobileCCS.EmailMedia-method-Create\" class=\"docClass\">Create</a> method.</p>\n</div></div></div><div id='property-CanGetSuggestedResponses' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-CanGetSuggestedResponses' class='name expandable'>CanGetSuggestedResponses</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if Suggested Responses can be retrieved by calling the <a href=\"#!/api/MobileCCS.EmailMedia-method-GetSuggestedResponses\" rel=\"MobileCCS.EmailMedia-method-GetSuggestedResponses\" class=\"docClass\">GetSuggestedResponses</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if Suggested Responses can be retrieved by calling the <a href=\"#!/api/MobileCCS.EmailMedia-method-GetSuggestedResponses\" rel=\"MobileCCS.EmailMedia-method-GetSuggestedResponses\" class=\"docClass\">GetSuggestedResponses</a> method.</p>\n</div></div></div><div id='property-CanReply' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-CanReply' class='name expandable'>CanReply</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the email can be replied to by calling the <a href=\"#!/api/MobileCCS.EmailMedia-method-Reply\" rel=\"MobileCCS.EmailMedia-method-Reply\" class=\"docClass\">Reply</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the email can be replied to by calling the <a href=\"#!/api/MobileCCS.EmailMedia-method-Reply\" rel=\"MobileCCS.EmailMedia-method-Reply\" class=\"docClass\">Reply</a> method.</p>\n</div></div></div><div id='property-ContactID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ContactID' class='name expandable'>ContactID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The ID of the contact associated with this Media object. ...</div><div class='long'><p>The ID of the contact associated with this Media object.  The value of the <em>ContactID</em> property is a string\nthat identifies the contact within the context of the underlying service provider.</p>\n\n<p>The contents of the contact ID string depend on the underlying service provider, therefore\nthe application should not rely on the <em>ContactID</em> string being of a particular format.</p>\n</div></div></div><div id='property-ContactType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ContactType' class='name expandable'>ContactType</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The contact type for this interaction. ...</div><div class='long'><p>The contact type for this interaction.</p>\n\n<p>This property allows the client to determine what contact type is being handled by this interaction.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">ContactTypes</a> class.</p>\n</div></div></div><div id='property-Encoding' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-Encoding' class='name expandable'>Encoding</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Provides the encoding type of the email. ...</div><div class='long'><p>Provides the encoding type of the email. Possible values are <strong>HTML</strong> or <strong>PLAIN</strong>.</p>\n</div></div></div><div id='property-From' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-From' class='name expandable'>From</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the address of the customer that initiated the contact.</p>\n</div><div class='long'><p>Provides the address of the customer that initiated the contact.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-MailboxAddress' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-MailboxAddress' class='name expandable'>MailboxAddress</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the mailbox address that was the destination of this contact.</p>\n</div><div class='long'><p>Provides the mailbox address that was the destination of this contact.</p>\n</div></div></div><div id='property-Status' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-Status' class='name expandable'>Status</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The status of the interaction. ...</div><div class='long'><p>The status of the interaction.</p>\n\n<p>This property allows the client to determine the current status this interaction.</p>\n\n<p>Possible values are <strong>New</strong>, <strong>Closed</strong>, <strong>Open</strong> and <strong>Waiting</strong>.</p>\n</div></div></div><div id='property-Subject' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseMedia' rel='MobileCCS.BaseMedia' class='defined-in docClass'>MobileCCS.BaseMedia</a><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-Subject' class='name expandable'>Subject</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The subject of the contact.</p>\n</div><div class='long'><p>The subject of the contact.</p>\n</div></div></div><div id='property-To' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-property-To' class='name expandable'>To</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the To address of this contact.</p>\n</div><div class='long'><p>Provides the To address of this contact.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-Create' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-method-Create' class='name expandable'>Create</a>( <span class='pre'>to, cc, bcc, subject, body, note, attachments, isHtml, skillsetId, completeHandler, progressHandler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Send an outgoing email contact\n\nMost errors can be prevented by using the CanCreate property to determine when it is ...</div><div class='long'><p>Send an outgoing email contact</p>\n\n<p>Most errors can be prevented by using the <a href=\"#!/api/MobileCCS.EmailMedia-property-CanCreate\" rel=\"MobileCCS.EmailMedia-property-CanCreate\" class=\"docClass\">CanCreate</a> property to determine when it is possible to call this method.\nPossible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>to</span> : String<div class='sub-desc'><p>email address the email should be sent to.</p>\n</div></li><li><span class='pre'>cc</span> : String<div class='sub-desc'><p>email addresses of CC recipients.</p>\n</div></li><li><span class='pre'>bcc</span> : String<div class='sub-desc'><p>email addresses of BCC recipients.</p>\n</div></li><li><span class='pre'>subject</span> : String<div class='sub-desc'><p>the email subject.</p>\n</div></li><li><span class='pre'>body</span> : String<div class='sub-desc'><p>the email body.</p>\n</div></li><li><span class='pre'>note</span> : String<div class='sub-desc'><p>optional agent note that an agent can add to the contact.</p>\n</div></li><li><span class='pre'>attachments</span> : Object<div class='sub-desc'><p>an array of attachment objects.</p>\n</div></li><li><span class='pre'>isHtml</span> : Object<div class='sub-desc'><p>Boolean indicating if the email encoding is HTML.</p>\n</div></li><li><span class='pre'>skillsetId</span> : String<div class='sub-desc'><p>Id of the skillset assigned to the outgoing email.</p>\n</div></li><li><span class='pre'>completeHandler</span> : Function<div class='sub-desc'><p>a callback function indicating that the email has been sent.</p>\n</div></li><li><span class='pre'>progressHandler</span> : Function<div class='sub-desc'><p>a callback function indicating the progress of attachment uploads.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attachmentIndex</span> : String<div class='sub-desc'><p>index of attachment being uploaded.</p>\n</div></li><li><span class='pre'>percentage</span> : String<div class='sub-desc'><p>attachment upload progress as a percentage.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-GetAttachmentFile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-method-GetAttachmentFile' class='name expandable'>GetAttachmentFile</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieve the content of an attachment from the Contact Center server. ...</div><div class='long'><p>Retrieve the content of an attachment from the Contact Center server. Purpose is to download an attachment associated with\na suggested response which can then be added to a reply.\nThe attachment file is passed to the callback function supplied by the <em>handler</em> argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The administrator configures suggested responses and associated attachments using the Contact Center Multimedia Administrator.\nThe first argument to the callback function identifies the type of notification being supplied, which is defined in\n<a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a> and will be one of either <em>RESPONSE</em> or <em>ERROR</em>.  The second argument will be an\nAttachment objects for the <em>RESPONSE</em> notification type or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>The format of the <em>Attachment</em> object is as follows:</p>\n\n<ul>\n<li><strong>ID</strong> - ID of the attachment.</li>\n<li><strong>Name</strong> - A String that indicates the name of the attachment.</li>\n<li><strong>Address</strong> - A String that contains the location the attachment can be downloaded from.</li>\n<li><strong>Size</strong> - The size of the attachment file.</li>\n<li><strong>MimeType</strong> - The format of the attachment file.</li>\n</ul>\n\n\n<p>An <em>ERROR</em> notification received on this callback function indicates the failure of the method call. The accompanying\n<a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the source and cause of the error.</p>\n\n<p>Possible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when the response (or error) arrives.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either an Attachment file\n                                     or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-GetSuggestedResponses' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-method-GetSuggestedResponses' class='name expandable'>GetSuggestedResponses</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the defined set of Suggested Responses from the server that are valid for this interaction. ...</div><div class='long'><p>Returns the defined set of Suggested Responses from the server that are valid for this interaction. The Suggested Responses\nare passed to the callback function supplied by the <em>handler</em> argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>Use a suggested response to add a prepared response to an email reply. The administrator configures suggested responses using the Contact Center Multimedia Administrator.\nThe first argument to the callback function identifies the type of notification being supplied, which is defined in\n<a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a> and will be one of either <em>RESPONSE</em> or <em>ERROR</em>.  The second argument will be an\narray of Suggested Response objects for the <em>RESPONSE</em> notification type or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>The format of the <em>SuggestedResponse</em> object is as follows:</p>\n\n<ul>\n<li><strong>ID</strong> - ID of the suggested response.</li>\n<li><strong>Name</strong> - A String that indicates the name of the suggested response.</li>\n<li><strong>Body</strong> - A String that contains the body of the suggested response.</li>\n<li><strong>Subject</strong> - A string that indicates the subject of the suggested response.</li>\n<li><strong>Attachments</strong> - An array of attachments associated with the suggested response.</li>\n</ul>\n\n\n<p>An <em>ERROR</em> notification received on this callback function indicates the failure of the method call. The accompanying\n<a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the source and cause of the error.</p>\n\n<p>Most errors can be prevented by using the <a href=\"#!/api/MobileCCS.EmailMedia-property-CanGetSuggestedResponses\" rel=\"MobileCCS.EmailMedia-property-CanGetSuggestedResponses\" class=\"docClass\">CanGetSuggestedResponses</a> property to determine when it is possible to call this method.\nPossible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when the response (or error) arrives.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either an array of Suggested Response\n                                     objects or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-Reply' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.EmailMedia'>MobileCCS.EmailMedia</span><br/></div><a href='#!/api/MobileCCS.EmailMedia-method-Reply' class='name expandable'>Reply</a>( <span class='pre'>to, cc, bcc, subject, body, note, attachments, isHtml, completeHandler, progressHandler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Reply to an email contact\n\nMost errors can be prevented by using the CanReply property to determine when it is possib...</div><div class='long'><p>Reply to an email contact</p>\n\n<p>Most errors can be prevented by using the <a href=\"#!/api/MobileCCS.EmailMedia-property-CanReply\" rel=\"MobileCCS.EmailMedia-property-CanReply\" class=\"docClass\">CanReply</a> property to determine when it is possible to call this method.\nPossible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>to</span> : String<div class='sub-desc'><p>email address the email should be sent to.</p>\n</div></li><li><span class='pre'>cc</span> : String<div class='sub-desc'><p>email addresses of CC recipients.</p>\n</div></li><li><span class='pre'>bcc</span> : String<div class='sub-desc'><p>email addresses of BCC recipients.</p>\n</div></li><li><span class='pre'>subject</span> : String<div class='sub-desc'><p>the email subject.</p>\n</div></li><li><span class='pre'>body</span> : String<div class='sub-desc'><p>the email body.</p>\n</div></li><li><span class='pre'>note</span> : String<div class='sub-desc'><p>optional agent note that an agent can add to the contact.</p>\n</div></li><li><span class='pre'>attachments</span> : Object<div class='sub-desc'><p>an array of attachment objects.</p>\n</div></li><li><span class='pre'>isHtml</span> : Object<div class='sub-desc'><p>Boolean indicating if the email encoding is HTML.</p>\n</div></li><li><span class='pre'>completeHandler</span> : Function<div class='sub-desc'><p>a callback function indicating that the email has been sent.</p>\n</div></li><li><span class='pre'>progressHandler</span> : Function<div class='sub-desc'><p>a callback function indicating the progress of attachment uploads.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attachmentIndex</span> : String<div class='sub-desc'><p>index of attachment being uploaded.</p>\n</div></li><li><span class='pre'>percentage</span> : String<div class='sub-desc'><p>attachment upload progress as a percentage.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});