Ext.data.JsonP.MobileCCS_Resource({"tagname":"class","name":"MobileCCS.Resource","autodetected":{},"files":[{"filename":"ccs-resource.js","href":null}],"extends":"CCSObject","members":[{"name":"Address","tagname":"property","owner":"MobileCCS.Resource","id":"property-Address","meta":{"readonly":true}},{"name":"AddressName","tagname":"property","owner":"MobileCCS.Resource","id":"property-AddressName","meta":{"readonly":true}},{"name":"CanCallSupervisor","tagname":"property","owner":"MobileCCS.Resource","id":"property-CanCallSupervisor","meta":{"readonly":true}},{"name":"CanOriginate","tagname":"property","owner":"MobileCCS.Resource","id":"property-CanOriginate","meta":{"readonly":true}},{"name":"ContactTypes","tagname":"property","owner":"MobileCCS.Resource","id":"property-ContactTypes","meta":{"readonly":true}},{"name":"DefaultContactType","tagname":"property","owner":"MobileCCS.Resource","id":"property-DefaultContactType","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"Session","tagname":"property","owner":"MobileCCS.Resource","id":"property-Session","meta":{"readonly":true}},{"name":"State","tagname":"property","owner":"MobileCCS.Resource","id":"property-State","meta":{"readonly":true}},{"name":"StateReason","tagname":"property","owner":"MobileCCS.Resource","id":"property-StateReason","meta":{"readonly":true}},{"name":"StateReasonMessage","tagname":"property","owner":"MobileCCS.Resource","id":"property-StateReasonMessage","meta":{"readonly":true}},{"name":"CallSupervisor","tagname":"method","owner":"MobileCCS.Resource","id":"method-CallSupervisor","meta":{}},{"name":"HasContactType","tagname":"method","owner":"CCSObject","id":"method-HasContactType","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"Originate","tagname":"method","owner":"MobileCCS.Resource","id":"method-Originate","meta":{}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.Resource","short_doc":"A Resource object represents a controllable endpoint that can be used to originate or receive contacts. ...","component":false,"superclasses":["CCSObject"],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><strong>MobileCCS.Resource</strong></div></div></pre><div class='doc-contents'><p>A <em>Resource</em> object represents a controllable endpoint that can be used to originate or receive contacts.\nThese are limited to endpoints that are not built-in to the Contact Center. Most multimedia (i.e. non-voice)\ncontacts are handled internally by the Contact Center using virtual endpoints which are not represented by\na <em>Resource</em> object.  Endpoints that are external to the Contact Center (such as telephone sets) are\nthe only endpoints modelled by <em>Resource</em> objects.</p>\n\n<p><em>Resource</em> objects are retrieved from the server by calling the <a href=\"#!/api/MobileCCS.Session-method-OpenResources\" rel=\"MobileCCS.Session-method-OpenResources\" class=\"docClass\">OpenResources</a>\nmethod on the <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-Address' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-Address' class='name expandable'>Address</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The address associated with this resource. ...</div><div class='long'><p>The address associated with this resource.  This is typically the full URI of the address (e.g. \"sip:123456@domain.com\").\nTo obtain just the name of the address (e.g. \"123456\"), use the <a href=\"#!/api/MobileCCS.Resource-property-AddressName\" rel=\"MobileCCS.Resource-property-AddressName\" class=\"docClass\">AddressName</a> property.</p>\n</div></div></div><div id='property-AddressName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-AddressName' class='name expandable'>AddressName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>This is the name (or URN) portion of the resource's address (see Address). ...</div><div class='long'><p>This is the name (or URN) portion of the resource's address (see <a href=\"#!/api/MobileCCS.Resource-property-Address\" rel=\"MobileCCS.Resource-property-Address\" class=\"docClass\">Address</a>).  For example if the <em>Address</em> is\n<strong>sip:8111674@domain.com</strong>, then the <em>AddressName</em> would be <strong>8111674</strong>.</p>\n</div></div></div><div id='property-CanCallSupervisor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-CanCallSupervisor' class='name expandable'>CanCallSupervisor</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the <a href=\"#!/api/MobileCCS.Resource-method-CallSupervisor\" rel=\"MobileCCS.Resource-method-CallSupervisor\" class=\"docClass\">CallSupervisor</a> method can be used to call the agent's supervisor.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the <a href=\"#!/api/MobileCCS.Resource-method-CallSupervisor\" rel=\"MobileCCS.Resource-method-CallSupervisor\" class=\"docClass\">CallSupervisor</a> method can be used to call the agent's supervisor.</p>\n</div></div></div><div id='property-CanOriginate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-CanOriginate' class='name expandable'>CanOriginate</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if contacts can be originated from this resource by calling the <a href=\"#!/api/MobileCCS.Resource-method-Originate\" rel=\"MobileCCS.Resource-method-Originate\" class=\"docClass\">Originate</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if contacts can be originated from this resource by calling the <a href=\"#!/api/MobileCCS.Resource-method-Originate\" rel=\"MobileCCS.Resource-method-Originate\" class=\"docClass\">Originate</a> method.</p>\n</div></div></div><div id='property-ContactTypes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-ContactTypes' class='name expandable'>ContactTypes</a> : String[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A list of contact types supported by this resource. ...</div><div class='long'><p>A list of contact types supported by this resource.</p>\n\n<p>This property allows the client to determine what contact types are supported on this resource.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> class.</p>\n</div></div></div><div id='property-DefaultContactType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-DefaultContactType' class='name expandable'>DefaultContactType</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The default contact type for this resource. ...</div><div class='long'><p>The default contact type for this resource.</p>\n\n<p>This property allows the client to determine what the default contact type is for this device.  This contact\ntype is used when no contact type is specified in the <a href=\"#!/api/MobileCCS.Resource-method-Originate\" rel=\"MobileCCS.Resource-method-Originate\" class=\"docClass\">Originate</a> method call.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> class.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-Session' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-Session' class='name expandable'>Session</a> : <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">MobileCCS.Session</a><span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object that the <em>Resource</em> object is associated with.</p>\n</div><div class='long'><p>The <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object that the <em>Resource</em> object is associated with.</p>\n</div></div></div><div id='property-State' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-State' class='name expandable'>State</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The state of the resource. ...</div><div class='long'><p>The state of the resource.  This will be one of the following:</p>\n\n<ul>\n<li>\"Invalid\" - The resource has either been removed from the Contact Center or unassigned from the session.\n            The client application should cease using this resource object when in this state.  Note that this\n            state will be set in any <em>DELETE</em> notifications for <em>Resource</em> objects.</li>\n<li>\"InService\" - Indicates that the device is currently in service and operational.</li>\n<li>\"OutOfService\" - Indicates that the device is currently out of service.</li>\n</ul>\n\n\n<p>A resource can be in an \"out of service\" state for a number of reasons.  For instance,\nit can be out of service if the device associated with it is currently not registered or\nif the underlying service provider has been taken out of service. The <a href=\"#!/api/MobileCCS.Resource-property-StateReason\" rel=\"MobileCCS.Resource-property-StateReason\" class=\"docClass\">StateReason</a>\nand/or <a href=\"#!/api/MobileCCS.Resource-property-StateReasonMessage\" rel=\"MobileCCS.Resource-property-StateReasonMessage\" class=\"docClass\">StateReasonMessage</a> properties can be examined to get more detail.</p>\n</div></div></div><div id='property-StateReason' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-StateReason' class='name expandable'>StateReason</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The reason the resource has transitioned to the current state. ...</div><div class='long'><p>The reason the resource has transitioned to the current state.  This could be one of the following values:</p>\n\n<ul>\n<li><strong>null</strong> - The default, or no reason.</li>\n<li>\"AcquisitionFailure\" - The acquisition of the resource failed.</li>\n<li>\"CTILinkDown\" - The computer telephony integration (CTI) link has failed. This indicates that control of\n                the telephone set is not currently possible. The physical telephone set may be used during\n                this time to handle voice calls.</li>\n<li>\"CTILinkUp\" - The computer telephony integration (CTI) link has been recovered. This indicates that the system\n              can now control the telephone set, although calls currently active on the set may not be available.\n              Those existing calls may still require the use of the physical set.</li>\n<li>\"DestinationBusy\" - There are existing calls active on the phone set.</li>\n<li>\"DeviceNotRegistered\" - The phone set is not registered or logged in to the switch.</li>\n<li>\"DeviceNotConfigured\" - The phone set is not configured on the switch.</li>\n<li>\"DeviceNotSupported\" - The phone set or address has a configuration that is not supported.</li>\n<li>\"LicenseNotGranted\" - A required license was not granted.</li>\n<li>\"ProviderOutOfService\" - Indicates that the service provider for the endpoint is currently out of service.</li>\n<li>\"ResourceDisabled\" - The resource is disabled.</li>\n</ul>\n\n</div></div></div><div id='property-StateReasonMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-property-StateReasonMessage' class='name expandable'>StateReasonMessage</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A text string containing a description of why the resource is in the current state. ...</div><div class='long'><p>A text string containing a description of why the resource is in the current state. The value is <strong>null</strong>\nif there is no reason message available.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-CallSupervisor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-method-CallSupervisor' class='name expandable'>CallSupervisor</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Places a call to the agent's supervisor. ...</div><div class='long'><p>Places a call to the agent's supervisor.</p>\n\n<p>If a failure occurs an <em>ERROR</em> notification will be received.  This failure notification will occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenResources\" rel=\"MobileCCS.Session-method-OpenResources\" class=\"docClass\">OpenResources</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.Resource-property-CanCallSupervisor\" rel=\"MobileCCS.Resource-property-CanCallSupervisor\" class=\"docClass\">CanCallSupervisor</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationBusy\" rel=\"MobileCCS.ErrorCode-property-DestinationBusy\" class=\"docClass\">DestinationBusy</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationOutOfService\" rel=\"MobileCCS.ErrorCode-property-DestinationOutOfService\" class=\"docClass\">DestinationOutOfService</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationStateInvalid\" rel=\"MobileCCS.ErrorCode-property-DestinationStateInvalid\" class=\"docClass\">DestinationStateInvalid</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OperationNotSupported\" rel=\"MobileCCS.ErrorCode-property-OperationNotSupported\" class=\"docClass\">OperationNotSupported</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OutOfService\" rel=\"MobileCCS.ErrorCode-property-OutOfService\" class=\"docClass\">OutOfService</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-HasContactType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-HasContactType' class='name expandable'>HasContactType</a>( <span class='pre'>contacttype</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Determines if a particular contact type is supported by the object. ...</div><div class='long'><p>Determines if a particular contact type is supported by the object.  Note that this method only\napplies to objects that contain a <strong>ContactTypes</strong> property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contacttype</span> : String<div class='sub-desc'><p>The contact type to check for (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a>).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the specified contact type is supported.  When called on objects\n                   that do not have a <strong>ContactTypes</strong> property, this method will always return <strong>false</strong>.</p>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-Originate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Resource'>MobileCCS.Resource</span><br/></div><a href='#!/api/MobileCCS.Resource-method-Originate' class='name expandable'>Originate</a>( <span class='pre'>destaddr, [contacttype]</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Originates an outgoing contact from this device (for example, makes a phone-call). ...</div><div class='long'><p>Originates an outgoing contact from this device (for example, makes a phone-call).</p>\n\n<p>If successful, a new <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object will be created through a <em>NEW</em> notification\nrepresenting the new outgoing call to the specified address.  This notification will be received on the callback\nmethod registered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenInteractions\" rel=\"MobileCCS.Session-method-OpenInteractions\" class=\"docClass\">OpenInteractions</a> method was called.</p>\n\n<p>If a failure occurs an <em>ERROR</em> notification will be received.  This failure notification will occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenResources\" rel=\"MobileCCS.Session-method-OpenResources\" class=\"docClass\">OpenResources</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.Resource-property-CanOriginate\" rel=\"MobileCCS.Resource-property-CanOriginate\" class=\"docClass\">CanOriginate</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-CommServerError\" rel=\"MobileCCS.ErrorCode-property-CommServerError\" class=\"docClass\">CommServerError</a></td>\n            <td>A malformed destination address was provided.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationBusy\" rel=\"MobileCCS.ErrorCode-property-DestinationBusy\" class=\"docClass\">DestinationBusy</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationInvalid\" rel=\"MobileCCS.ErrorCode-property-DestinationInvalid\" class=\"docClass\">DestinationInvalid</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationOutOfService\" rel=\"MobileCCS.ErrorCode-property-DestinationOutOfService\" class=\"docClass\">DestinationOutOfService</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationStateInvalid\" rel=\"MobileCCS.ErrorCode-property-DestinationStateInvalid\" class=\"docClass\">DestinationStateInvalid</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationUnreachable\" rel=\"MobileCCS.ErrorCode-property-DestinationUnreachable\" class=\"docClass\">DestinationUnreachable</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidContactType\" rel=\"MobileCCS.ErrorCode-property-InvalidContactType\" class=\"docClass\">InvalidContactType</a></td>\n            <td>The \"contacttype\" argument specified a contact type that is not supported by the resource.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OutOfService\" rel=\"MobileCCS.ErrorCode-property-OutOfService\" class=\"docClass\">OutOfService</a></td>\n        </tr>\n    </tbody>\n</table>\n\n\n<p>Note that even if the operation fails, a contact may actually have been created depending on the service provider and the contact type.\nAn example of this is a voice call to a busy number.  This may be represented by the service provider by creating an <em>Interaction</em> with a\nremote participant in the <strong>Failed</strong> state and raising an <em>ERROR</em> notification containing an error code of <strong>DestinationBusy</strong>.\nOn a voice switch, this failed contact may be necessary to allow the busy tone to be heard in the receiver.  It also allows the user to manually\ndrop this failed connection.</p>\n\n<p>Other error codes may share this behavior; for instance <strong>DestinationUnreachable</strong> or <strong>DestinationInvalid</strong>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>destaddr</span> : String<div class='sub-desc'><p>A string representing the destination address to contact (for example, Phone number to dial).</p>\n</div></li><li><span class='pre'>contacttype</span> : String (optional)<div class='sub-desc'><p>The type of contact to create.  If specified, this must match one of the\n                            available contact types for this device as determined by the <a href=\"#!/api/MobileCCS.Resource-property-ContactTypes\" rel=\"MobileCCS.Resource-property-ContactTypes\" class=\"docClass\">ContactTypes</a>\n                            property.  If anything but a non-empty string value is supplied for this argument,\n                            the device's <a href=\"#!/api/MobileCCS.Resource-property-DefaultContactType\" rel=\"MobileCCS.Resource-property-DefaultContactType\" class=\"docClass\">DefaultContactType</a> will be used.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <em>destaddr</em> argument is anything but a non-empty string.</p>\n</div></li></ul></div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});