/**
 * Each section of the site has its own module. 
 *
 * The dependencies block here is also where component dependencies should be
 * specified, as shown below.
 */
angular.module('refClientJS.home', [
  'ui.router',
   'refClientJS.main'
])

/**
 * Each section or module of the site can also have its own routes. AngularJS
 * will handle ensuring they are all available at run-time, but splitting it
 * this way makes each module more "self-contained".
 */
.config(["$stateProvider", function config($stateProvider) {
    $stateProvider.state('home', {
        url: '/home',
        views: {
            "main": {
                controller: 'HomeCtrl',
                templateUrl: 'home/home.tpl.html'
            }
        },
        data: {
            pageTitle: 'Home'
        }
    });
}])

/**
 * And of course we define a controller for our route.
 */
.controller('HomeCtrl', ["$scope", "sessionService", function HomeController($scope, sessionService) {




}])

;