/**
 * resourceService contains the callback functions required to interact with the AACC/ACCS server
 * resourceData persists an array of current resources and all known information provided by the server 
 *
 */
angular.module('refClientJS.resources', ['ui.router', 'refClientJS.alerts'])
    .factory('resourceData', ["alertsService", function (alertsService) {

        var resources = [];

        function removeAll() {
            resources = [];
        }

        function addResource(newresource) {
            for (var i = resources.length - 1; i >= 0; i--) {

                if (resources[i].ID === newresource.ID) {
                    alertsService.log('resourceData: addResource', 'Resource duplicate so not putting into array');
                    return;
                }
            }

            resources.push(newresource);
            alertsService.log('resourceData: addResource', 'Resource added to array');
            console.log(resources);
            return resources;
        }

        function removeResource(resource) {

            for (var i = resources.length - 1; i >= 0; i--) {

                if (resources[i].ID === resource.ID) {
                    resources.splice(i, 1);
                }
            }
            return resources;
        }

        function updateResource(resource) {
            removeResource(resource);
            addResource(resource);
            return resources;
        }
        return {
            'resources': resources,
            'addResource': addResource,
            'removeResource': removeResource,
            'updateResource': updateResource,
            'removeAll': removeAll

        };
    }])
    .factory('resourceService', ["resourceData", "alertsService", "$state", function (resourceData, alertsService, $state) {
        window.resourceServiceScope = resourceService;

        var resourceService = {};

        resourceService.handleResources = function (returnedNotifyType, returnedNotifyData) {
            alertsService.log('resourceService: handleResources', returnedNotifyType);

            console.log(returnedNotifyData);
            if (returnedNotifyType === MobileCCS.NotifyTypes.ERROR) {
                alertsService.addAlert(returnedNotifyData.Message, 'danger');
                console.log(returnedNotifyData.Message);
                return;
            }
            if (returnedNotifyType === MobileCCS.NotifyTypes.DELETE) {
                resourceData.resources = resourceData.removeResource(returnedNotifyData);

                alertsService.log('resourceService: handleResources', ' resources array in the resourceService factory after delete');
                console.log(resourceData.resources);
                $state.go('signedin');

            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.NEW) {

                resourceData.resources = resourceData.addResource(returnedNotifyData);


                if (returnedNotifyData.State == "OutOfService") {
                    alertsService.addAlert(returnedNotifyData.StateReasonMessage, 'danger');
                }

                $state.go('signedin');
            }

            if (returnedNotifyType === MobileCCS.NotifyTypes.UPDATE) {
                resourceData.resources = resourceData.updateResource(returnedNotifyData);

                $state.go('signedin');

            }


        };

        return resourceService;

    }]);