 /* jshint -W097 */
 "use strict";

 var supervisorModule = angular.module('refClientJS.supervisor', ['ui.router', 'refClientJS.user', 'refClientJS.interactions', 'refClientJS.resources', 'refClientJS.alerts']);
 supervisorModule.factory("supervisorService", ["sessionData", "interactionData", "resourceData", "userData", "clientData", "userService", "interactionService", "resourceService", "supervisorData", "$state", "alertsService", function (sessionData, interactionData, resourceData, userData, clientData, userService, interactionService, resourceService, supervisorData, $state, alertsService) {

     var supervisorService = this;

    
     supervisorService.monitorInteractions = function monitorInteractions(returnedNotifyType, returnedNotifyData) {
         alertsService.log('supervisorService: monitorInteractions: ' , returnedNotifyType);
         console.log(returnedNotifyData);
         if (returnedNotifyType === MobileCCS.NotifyTypes.ERROR) {
             alertsService.addAlert(returnedNotifyData.Message, 'danger');
             $state.go("signedin");
             return;
         }

         if (returnedNotifyType === MobileCCS.NotifyTypes.DELETE) {
             supervisorData.monitoredInteractions = supervisorData.removeInteraction(returnedNotifyData);
             $state.go("signedin");
             return;
         }
         if (returnedNotifyType === MobileCCS.NotifyTypes.NEW) {
             supervisorData.monitoredInteractions = supervisorData.addInteraction(returnedNotifyData);
             $state.go("signedin");
             return;


         }
         if (returnedNotifyType === MobileCCS.NotifyTypes.UPDATE) {
             supervisorData.monitoredInteractions = supervisorData.updateInteraction(returnedNotifyData);
             console.log(supervisorData.monitoredInteractions);
             $state.go("signedin");
             return;
         }
     };
     supervisorService.getNotReadyReasonCodes = function getNotReadyReasonCodes(Agent) {
         Agent.GetNotReadyReasonCodes(supervisorService.handleNRRCodes);
     };
     supervisorService.handleNRRCodes = function (returnedNotifyType, returnedNotifyData) {
         alertsService.log('supervisorService: handleNRRCodes: ' , returnedNotifyType);
         console.log(returnedNotifyData);

         if (returnedNotifyType == MobileCCS.NotifyTypes.ERROR) {

             if (returnedNotifyData.Name === MobileCCS.ErrorCode.ObjectNotFound) {

                 return;
             }
             alertsService.addAlert(returnedNotifyData.Message, 'danger');
             
             

         }

         if (returnedNotifyType === MobileCCS.NotifyTypes.RESPONSE) {
           
             var parsedCodes = [];
             var element = {};

             for (var key in returnedNotifyData.Codes) {
                 if (returnedNotifyData.Codes.hasOwnProperty(key)) {
                     element.Code = key;
                     element.Name = returnedNotifyData.Codes[key];
                 }
                 parsedCodes.push(element);
                 element = {};
             }
             supervisorData.ForcedNRRCodes = parsedCodes;
             $state.go('signedin');
         }

     };

     return supervisorService;
 }]);

 supervisorModule.factory("supervisorData", ["userData", function (userData) {

     var monitoredUsers = [];
     var monitoredInteractions = [];
     var ForcedNRRCodes = {};

     function removeAllmonitoredUsers() {
        
         monitoredUsers.length = 0;
     }

   
     function removeAllInteractions() {
         monitoredInteractions.length = 0;
     }

     function addInteraction(newInteraction) {

         for (var i = monitoredInteractions.length - 1; i >= 0; i--) {
             if (monitoredInteractions[i].ID === newInteraction.ID) {
                 return;
             }
         }

         monitoredInteractions.push(newInteraction);

         return monitoredInteractions;

     }

     function removeInteraction(Interaction) {

         for (var i = monitoredInteractions.length - 1; i >= 0; i--) {

             if (monitoredInteractions[i].ID === Interaction.ID) {
                 monitoredInteractions.splice(i, 1);
             }
         }
         return monitoredInteractions;
     }

     function updateInteraction(Interaction) {
         removeInteraction(Interaction);
         addInteraction(Interaction);
         return monitoredInteractions;
     }

     function removeAllMonitors() {
         for (var i = monitoredUsers.length - 1; i >= 0; i--) {
             monitoredInteractions[i].UnmonitorInteractions();
         }
         userData.user.UnmonitorUsers();
     }

     function removeMonitoredInteractionsForUser(user) {

         for (var i = monitoredInteractions.length - 1; i >= 0; i--) {

             if (monitoredInteractions[i].MonitoredUser.ID === user.ID) {
                 monitoredInteractions.splice(i, 1);
             }
         }
         user.UnmonitorInteractions();

     }
     return {
         'monitoredUsers': monitoredUsers,
         'removeAllmonitoredUsers': removeAllmonitoredUsers,
         'monitoredInteractions': monitoredInteractions,
         'removeAllInteractions': removeAllInteractions,
         'addInteraction': addInteraction,
         'removeInteraction': removeInteraction,
         'updateInteraction': updateInteraction,
         'removeAllMonitors': removeAllMonitors,
         'removeMonitoredInteractionsForUser': removeMonitoredInteractionsForUser,
         'ForcedNRRCodes': ForcedNRRCodes
         
     };

 }]);