Ext.data.JsonP.MobileCCS_BaseUser({"tagname":"class","name":"MobileCCS.BaseUser","autodetected":{},"files":[{"filename":"ccs-baseuser.js","href":null}],"extends":"CCSObject","abstract":true,"members":[{"name":"Code","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-Code","meta":{"readonly":true}},{"name":"ContactTypes","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-ContactTypes","meta":{"readonly":true}},{"name":"FirstName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-FirstName","meta":{"readonly":true}},{"name":"FullName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-FullName","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"LastName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-LastName","meta":{"readonly":true}},{"name":"LoginID","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-LoginID","meta":{"readonly":true}},{"name":"State","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-State","meta":{"readonly":true}},{"name":"HasContactType","tagname":"method","owner":"CCSObject","id":"method-HasContactType","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"updateDerivedProperties","tagname":"method","owner":"MobileCCS.BaseUser","id":"method-updateDerivedProperties","meta":{"protected":true}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.BaseUser","short_doc":"The BaseUser object is a base class for the User and\nMonitoredUser objects providing the properties that are common\na...","component":false,"superclasses":["CCSObject"],"subclasses":["MobileCCS.MonitoredUser","MobileCCS.User"],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><strong>MobileCCS.BaseUser</strong></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/MobileCCS.MonitoredUser' rel='MobileCCS.MonitoredUser' class='docClass'>MobileCCS.MonitoredUser</a></div><div class='dependency'><a href='#!/api/MobileCCS.User' rel='MobileCCS.User' class='docClass'>MobileCCS.User</a></div></pre><div class='doc-contents'><p>The <em>BaseUser</em> object is a base class for the <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a> and\n<a href=\"#!/api/MobileCCS.MonitoredUser\" rel=\"MobileCCS.MonitoredUser\" class=\"docClass\">MonitoredUser</a> objects providing the properties that are common\nacross these two classes.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-Code' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-property-Code' class='name expandable'>Code</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>When not null, this property provides the Contact Center code currently associated with the agent. ...</div><div class='long'><p>When not <strong>null</strong>, this property provides the Contact Center code currently associated with the agent.</p>\n\n<p>This will be either a Not Ready Reason or After Call Work code depending upon the current state of the agent.\nThese Contact Center codes are used to provide a finer-grained accounting of how the agent's time was spent\nthroughout the day.</p>\n\n<p>The <em>Code</em> object returned by this property contains the following members:</p>\n\n<ul>\n<li><strong>Number</strong> - A string that is the actual code entered by the agent.</li>\n<li><strong>Name</strong> - A string that is the display name defined for this code.</li>\n</ul>\n\n</div></div></div><div id='property-ContactTypes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-property-ContactTypes' class='name expandable'>ContactTypes</a> : String[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A list of contact types that can be handled by this user. ...</div><div class='long'><p>A list of contact types that can be handled by this user.</p>\n\n<p>This property allows the client to determine what contact types the agent is capable of handling.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> class.</p>\n</div></div></div><div id='property-FirstName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-property-FirstName' class='name expandable'>FirstName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The first (given) name of the user.</p>\n</div><div class='long'><p>The first (given) name of the user.</p>\n</div></div></div><div id='property-FullName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-property-FullName' class='name expandable'>FullName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The full name of the user, combining both first and last name. ...</div><div class='long'><p>The full name of the user, combining both first and last name.  The full name of the user is formed\nfrom the first and last names as \"FirstName LastName\". That is, the full name is a string which includes\nthe first and last names separated by a single space.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-LastName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-property-LastName' class='name expandable'>LastName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The last name of the user.</p>\n</div><div class='long'><p>The last name of the user.</p>\n</div></div></div><div id='property-LoginID' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-property-LoginID' class='name expandable'>LoginID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The login ID of the user. ...</div><div class='long'><p>The login ID of the user.  This is the ID used to log in to the Contact Center.</p>\n</div></div></div><div id='property-State' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-property-State' class='name expandable'>State</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The state of the agent. ...</div><div class='long'><p>The state of the agent.  This will be one of the following:</p>\n\n<ul>\n<li>\"Invalid\" - The user has either been removed from the Contact Center or unassigned from the session.\n            The client application should cease using this agent object when in this state.  Note that this\n            state will be set in any <em>DELETE</em> notifications for <em>MonitoredUser</em> objects.</li>\n<li>\"LoggedOut\" - Indicates that the agent is not currently logged in to the Contact Center.</li>\n<li>\"Ready\" - Indicates that the agent is logged in to the Contact Center and ready to receive incoming contacts.</li>\n<li>\"ReadyAfterCall\" - Indicates that the agent has recently completed handling a Contact Center contact and is\n                   ready to accept another incoming Contact Center contact.</li>\n<li>\"ACWPending\" - Indicates that the agent is currently handling a Contact Center contact and will transition to\n               the After Call Work (ACW) state when the current contact is completed.</li>\n<li>\"ACW\" - Indicates that the agent is in an After Call Work state performing wrapup work associated with the\n        previous Contact Center contact.  When finished with After Call Work the agent should enter the Ready\n        state to become eligible to receive another Contact Center contact.</li>\n<li>\"NotReadyPending\" - Indicates that the agent is currently handling a Contact Center contact and will transition to\n                    the Not Ready state when the current contact is completed.</li>\n<li>\"NotReady\" - Indicates that the agent is logged in to the Contact Center but is not ready to handle incoming\n             Contact Center contacts.</li>\n</ul>\n\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-HasContactType' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-HasContactType' class='name expandable'>HasContactType</a>( <span class='pre'>contacttype</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Determines if a particular contact type is supported by the object. ...</div><div class='long'><p>Determines if a particular contact type is supported by the object.  Note that this method only\napplies to objects that contain a <strong>ContactTypes</strong> property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contacttype</span> : String<div class='sub-desc'><p>The contact type to check for (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a>).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the specified contact type is supported.  When called on objects\n                   that do not have a <strong>ContactTypes</strong> property, this method will always return <strong>false</strong>.</p>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-updateDerivedProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseUser'>MobileCCS.BaseUser</span><br/></div><a href='#!/api/MobileCCS.BaseUser-method-updateDerivedProperties' class='name expandable'>updateDerivedProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates derived property values after applying an update received from the server. ...</div><div class='long'><p>Updates derived property values after applying an update received from the server.</p>\n</div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"abstract":true}});