Ext.data.JsonP.MobileCCS_MonitoredUser({"tagname":"class","name":"MobileCCS.MonitoredUser","autodetected":{},"files":[{"filename":"ccs-monitoredUser.js","href":null}],"extends":"MobileCCS.BaseUser","members":[{"name":"CanForceLogout","tagname":"property","owner":"MobileCCS.MonitoredUser","id":"property-CanForceLogout","meta":{"readonly":true}},{"name":"CanForceNotReady","tagname":"property","owner":"MobileCCS.MonitoredUser","id":"property-CanForceNotReady","meta":{"readonly":true}},{"name":"CanForceReady","tagname":"property","owner":"MobileCCS.MonitoredUser","id":"property-CanForceReady","meta":{"readonly":true}},{"name":"Code","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-Code","meta":{"readonly":true}},{"name":"ContactTypes","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-ContactTypes","meta":{"readonly":true}},{"name":"FirstName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-FirstName","meta":{"readonly":true}},{"name":"FullName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-FullName","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"LastName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-LastName","meta":{"readonly":true}},{"name":"LoginID","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-LoginID","meta":{"readonly":true}},{"name":"State","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-State","meta":{"readonly":true}},{"name":"SupervisorID","tagname":"property","owner":"MobileCCS.MonitoredUser","id":"property-SupervisorID","meta":{"readonly":true}},{"name":"User","tagname":"property","owner":"MobileCCS.MonitoredUser","id":"property-User","meta":{"readonly":true}},{"name":"ForceLogout","tagname":"method","owner":"MobileCCS.MonitoredUser","id":"method-ForceLogout","meta":{}},{"name":"ForceNotReady","tagname":"method","owner":"MobileCCS.MonitoredUser","id":"method-ForceNotReady","meta":{}},{"name":"ForceReady","tagname":"method","owner":"MobileCCS.MonitoredUser","id":"method-ForceReady","meta":{}},{"name":"GetNotReadyReasonCodes","tagname":"method","owner":"MobileCCS.MonitoredUser","id":"method-GetNotReadyReasonCodes","meta":{}},{"name":"HasContactType","tagname":"method","owner":"CCSObject","id":"method-HasContactType","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"MonitorInteractions","tagname":"method","owner":"MobileCCS.MonitoredUser","id":"method-MonitorInteractions","meta":{}},{"name":"UnmonitorInteractions","tagname":"method","owner":"MobileCCS.MonitoredUser","id":"method-UnmonitorInteractions","meta":{}},{"name":"updateDerivedProperties","tagname":"method","owner":"MobileCCS.BaseUser","id":"method-updateDerivedProperties","meta":{"protected":true}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.MonitoredUser","short_doc":"The MonitoredUser object represents a supervised User in the Contact Center. ...","component":false,"superclasses":["CCSObject","MobileCCS.BaseUser"],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='docClass'>MobileCCS.BaseUser</a><div class='subclass '><strong>MobileCCS.MonitoredUser</strong></div></div></div></pre><div class='doc-contents'><p>The <em>MonitoredUser</em> object represents a supervised User in the Contact Center.  <em>MonitoredUser</em> objects share\na subset of properties with the <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a> object but provide only those properties\nand methods that are appropriate for monitoring the supervisor's users.  <em>MonitoredUser</em> objects are\nobtained by the client application by calling the <a href=\"#!/api/MobileCCS.User-method-MonitorUsers\" rel=\"MobileCCS.User-method-MonitorUsers\" class=\"docClass\">User.MonitorUsers</a> method.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-CanForceLogout' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-property-CanForceLogout' class='name expandable'>CanForceLogout</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user can be logged out of the Contact Center by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-ForceLogout\" rel=\"MobileCCS.MonitoredUser-method-ForceLogout\" class=\"docClass\">ForceLogout</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user can be logged out of the Contact Center by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-ForceLogout\" rel=\"MobileCCS.MonitoredUser-method-ForceLogout\" class=\"docClass\">ForceLogout</a> method.</p>\n</div></div></div><div id='property-CanForceNotReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-property-CanForceNotReady' class='name expandable'>CanForceNotReady</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user can be into a Not Ready state by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-ForceNotReady\" rel=\"MobileCCS.MonitoredUser-method-ForceNotReady\" class=\"docClass\">ForceNotReady</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user can be into a Not Ready state by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-ForceNotReady\" rel=\"MobileCCS.MonitoredUser-method-ForceNotReady\" class=\"docClass\">ForceNotReady</a> method.</p>\n</div></div></div><div id='property-CanForceReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-property-CanForceReady' class='name expandable'>CanForceReady</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user can be forced into a Ready state by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-ForceReady\" rel=\"MobileCCS.MonitoredUser-method-ForceReady\" class=\"docClass\">ForceReady</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user can be forced into a Ready state by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-ForceReady\" rel=\"MobileCCS.MonitoredUser-method-ForceReady\" class=\"docClass\">ForceReady</a> method.</p>\n</div></div></div><div id='property-Code' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-Code' class='name expandable'>Code</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>When not null, this property provides the Contact Center code currently associated with the agent. ...</div><div class='long'><p>When not <strong>null</strong>, this property provides the Contact Center code currently associated with the agent.</p>\n\n<p>This will be either a Not Ready Reason or After Call Work code depending upon the current state of the agent.\nThese Contact Center codes are used to provide a finer-grained accounting of how the agent's time was spent\nthroughout the day.</p>\n\n<p>The <em>Code</em> object returned by this property contains the following members:</p>\n\n<ul>\n<li><strong>Number</strong> - A string that is the actual code entered by the agent.</li>\n<li><strong>Name</strong> - A string that is the display name defined for this code.</li>\n</ul>\n\n</div></div></div><div id='property-ContactTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-ContactTypes' class='name expandable'>ContactTypes</a> : String[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A list of contact types that can be handled by this user. ...</div><div class='long'><p>A list of contact types that can be handled by this user.</p>\n\n<p>This property allows the client to determine what contact types the agent is capable of handling.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> class.</p>\n</div></div></div><div id='property-FirstName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-FirstName' class='name expandable'>FirstName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The first (given) name of the user.</p>\n</div><div class='long'><p>The first (given) name of the user.</p>\n</div></div></div><div id='property-FullName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-FullName' class='name expandable'>FullName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The full name of the user, combining both first and last name. ...</div><div class='long'><p>The full name of the user, combining both first and last name.  The full name of the user is formed\nfrom the first and last names as \"FirstName LastName\". That is, the full name is a string which includes\nthe first and last names separated by a single space.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-LastName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-LastName' class='name expandable'>LastName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The last name of the user.</p>\n</div><div class='long'><p>The last name of the user.</p>\n</div></div></div><div id='property-LoginID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-LoginID' class='name expandable'>LoginID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The login ID of the user. ...</div><div class='long'><p>The login ID of the user.  This is the ID used to log in to the Contact Center.</p>\n</div></div></div><div id='property-State' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-State' class='name expandable'>State</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The state of the agent. ...</div><div class='long'><p>The state of the agent.  This will be one of the following:</p>\n\n<ul>\n<li>\"Invalid\" - The user has either been removed from the Contact Center or unassigned from the session.\n            The client application should cease using this agent object when in this state.  Note that this\n            state will be set in any <em>DELETE</em> notifications for <em>MonitoredUser</em> objects.</li>\n<li>\"LoggedOut\" - Indicates that the agent is not currently logged in to the Contact Center.</li>\n<li>\"Ready\" - Indicates that the agent is logged in to the Contact Center and ready to receive incoming contacts.</li>\n<li>\"ReadyAfterCall\" - Indicates that the agent has recently completed handling a Contact Center contact and is\n                   ready to accept another incoming Contact Center contact.</li>\n<li>\"ACWPending\" - Indicates that the agent is currently handling a Contact Center contact and will transition to\n               the After Call Work (ACW) state when the current contact is completed.</li>\n<li>\"ACW\" - Indicates that the agent is in an After Call Work state performing wrapup work associated with the\n        previous Contact Center contact.  When finished with After Call Work the agent should enter the Ready\n        state to become eligible to receive another Contact Center contact.</li>\n<li>\"NotReadyPending\" - Indicates that the agent is currently handling a Contact Center contact and will transition to\n                    the Not Ready state when the current contact is completed.</li>\n<li>\"NotReady\" - Indicates that the agent is logged in to the Contact Center but is not ready to handle incoming\n             Contact Center contacts.</li>\n</ul>\n\n</div></div></div><div id='property-SupervisorID' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-property-SupervisorID' class='name expandable'>SupervisorID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the user ID of the user's supervisor.</p>\n</div><div class='long'><p>Provides the user ID of the user's supervisor.</p>\n</div></div></div><div id='property-User' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-property-User' class='name expandable'>User</a> : <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">MobileCCS.User</a><span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The <em>User</em> property provides access to the <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a> object\nthat the <em>MonitoredUser</em> object is associated with.</p>\n</div><div class='long'><p>The <em>User</em> property provides access to the <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a> object\nthat the <em>MonitoredUser</em> object is associated with.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-ForceLogout' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-method-ForceLogout' class='name expandable'>ForceLogout</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Allows the supervisor to force logout the user from the Contact Center. ...</div><div class='long'><p>Allows the supervisor to force logout the user from the Contact Center.  This method is useful for\nallowing supervisors to logout an user that has left for the day and has forgotten to log out.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.MonitoredUser-property-CanForceLogout\" rel=\"MobileCCS.MonitoredUser-property-CanForceLogout\" class=\"docClass\">CanForceLogout</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is not logged in.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-ForceNotReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-method-ForceNotReady' class='name expandable'>ForceNotReady</a>( <span class='pre'>[code]</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Allows the supervisor to force the user into a Not Ready state (if not already in Not Ready state) with an optional N...</div><div class='long'><p>Allows the supervisor to force the user into a Not Ready state (if not already in Not Ready state) with an optional Not Ready Reason code.</p>\n\n<p>The list of valid Not Ready Reason codes can be obtained by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-GetNotReadyReasonCodes\" rel=\"MobileCCS.MonitoredUser-method-GetNotReadyReasonCodes\" class=\"docClass\">GetNotReadyReasonCodes</a> method.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.MonitoredUser-property-CanForceNotReady\" rel=\"MobileCCS.MonitoredUser-property-CanForceNotReady\" class=\"docClass\">CanForceNotReady</a> property to determine when it is possible to call this method, and\nby obtaining the list of valid Not Ready Reason codes by calling the <a href=\"#!/api/MobileCCS.MonitoredUser-method-GetNotReadyReasonCodes\" rel=\"MobileCCS.MonitoredUser-method-GetNotReadyReasonCodes\" class=\"docClass\">GetNotReadyReasonCodes</a> method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is not logged in.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidParameter\" rel=\"MobileCCS.ErrorCode-property-InvalidParameter\" class=\"docClass\">InvalidParameter</a></td>\n            <td>The \"code\" parameter specifies an invalid not ready reason code (e.g. contains non-numeric characters).</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ParameterOutOfRange\" rel=\"MobileCCS.ErrorCode-property-ParameterOutOfRange\" class=\"docClass\">ParameterOutOfRange</a></td>\n            <td>The \"code\" parameter specifies a not ready reason code that is too long.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>code</span> : String (optional)<div class='sub-desc'><p>Specifies the Not Ready Reason code to assign to the user.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-ForceReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-method-ForceReady' class='name expandable'>ForceReady</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Allows the supervisor to force the user into a ready state. ...</div><div class='long'><p>Allows the supervisor to force the user into a ready state.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.MonitoredUser-property-CanForceReady\" rel=\"MobileCCS.MonitoredUser-property-CanForceReady\" class=\"docClass\">CanForceReady</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is not logged in.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-GetNotReadyReasonCodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-method-GetNotReadyReasonCodes' class='name expandable'>GetNotReadyReasonCodes</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the defined set of Not Ready Reason codes from the server for this user. ...</div><div class='long'><p>Retrieves the defined set of Not Ready Reason codes from the server for this user.  The code list\nis passed to the callback function supplied by the <em>handler</em> argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which is defined in\n<a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a> and will be one of either <em>RESPONSE</em> or <em>ERROR</em>.  The second argument will be a\n<em>CodeList</em> object for the <em>RESPONSE</em> notification type or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>RESPONSE</em> notification indicates that a <em>CodeList</em> object is being returned containing the defined set of Not Ready Reason codes.\nThe format of the <em>CodeList</em> object is as follows:</p>\n\n<ul>\n<li><strong>CodeType</strong> - A string that indicates the type of codes in the list (in this case it will be \"NRRC\").</li>\n<li><strong>Codes</strong> - An array of <em>Code</em> objects.</li>\n</ul>\n\n\n<p>Each <em>Code</em> object contains the following properties:</p>\n\n<ul>\n<li><strong>Number</strong> - A string containing the actual Not Ready Reason code.</li>\n<li><strong>Name</strong> - A string to use as the display name for the code.</li>\n</ul>\n\n\n<p>An <em>ERROR</em> notification received on this callback function indicates the failure of the method call. The accompanying\n<a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the source and cause of the error.</p>\n\n<p>Possible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when the response (or error) arrives.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <em>CodeList</em>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-HasContactType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-HasContactType' class='name expandable'>HasContactType</a>( <span class='pre'>contacttype</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Determines if a particular contact type is supported by the object. ...</div><div class='long'><p>Determines if a particular contact type is supported by the object.  Note that this method only\napplies to objects that contain a <strong>ContactTypes</strong> property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contacttype</span> : String<div class='sub-desc'><p>The contact type to check for (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a>).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the specified contact type is supported.  When called on objects\n                   that do not have a <strong>ContactTypes</strong> property, this method will always return <strong>false</strong>.</p>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-MonitorInteractions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-method-MonitorInteractions' class='name expandable'>MonitorInteractions</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>This method retrieves the interactions that the user is currently active on and begins the flow of events that update...</div><div class='long'><p>This method retrieves the interactions that the user is currently active on and begins the flow of events that update these\ninteractions.  These \"user interactions\" have a limited set of functionality that is restricted to operations that the user's\nsupervisor can perform on them and are respresented by <a href=\"#!/api/MobileCCS.MonitoredInteraction\" rel=\"MobileCCS.MonitoredInteraction\" class=\"docClass\">MonitoredInteraction</a> objects.\nThe initial set of <em>MonitoredInteraction</em> objects and subsequent updates to them are received by the application through a callback\nfunction argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which will be one of the values\ndefined in <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>.  The second argument will be a <a href=\"#!/api/MobileCCS.MonitoredInteraction\" rel=\"MobileCCS.MonitoredInteraction\" class=\"docClass\">MonitoredInteraction</a>\nobject for the <em>NEW</em>, <em>UPDATE</em> and <em>DELETE</em> notification types and an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>NEW</em> notification indicates that a new <em>MonitoredInteraction</em> object is being delivered to the application.  Immediately following the\ninvocation of this method, a <em>NEW</em> notification will be received for any interactions currently active for the user.\nAn <em>UPDATE</em> notification indicates that some property or properties of the user interaction identifed by\nthe supplied <em>notifyObject</em> has changed and the newly supplied <em>MonitoredInteraction</em> object represents a complete update of the\n<em>MonitoredInteraction</em> object.  A <em>DELETE</em> notification indicates that the identified user interaction has completed and has been removed\nfrom the system.  Upon receiving a <em>DELETE</em> notification the client application should discontinue the use of the identified object.</p>\n\n<p><em>ERROR</em> notifications received on this callback function indicate the failure of some method call made by the client application\non one of the previously received <em>MonitoredInteraction</em> objects. The accompanying <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details\nas to the source and cause of the error.</p>\n\n<p>To stop monitoring the events associated with the user's interactions, the <a href=\"#!/api/MobileCCS.MonitoredUser-method-UnmonitorInteractions\" rel=\"MobileCCS.MonitoredUser-method-UnmonitorInteractions\" class=\"docClass\">UnmonitorInteractions</a> method should be called.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when user events occur.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either an <a href=\"#!/api/MobileCCS.MonitoredInteraction\" rel=\"MobileCCS.MonitoredInteraction\" class=\"docClass\">MonitoredInteraction</a>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>handler</strong> argument is not a function.</p>\n</div></li></ul></div></div></div><div id='method-UnmonitorInteractions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredUser'>MobileCCS.MonitoredUser</span><br/></div><a href='#!/api/MobileCCS.MonitoredUser-method-UnmonitorInteractions' class='name expandable'>UnmonitorInteractions</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>This method causes the set of MonitoredInteraction objects associated with this MonitoredUser to be discarded and wil...</div><div class='long'><p>This method causes the set of <em>MonitoredInteraction</em> objects associated with this <em>MonitoredUser</em> to be discarded and will cease the flow of events\nthat update these objects.  Upon calling this method the client application should no longer use any <em>MonitoredInteraction</em> objects it received\nfrom the callback function supplied when it called the <a href=\"#!/api/MobileCCS.MonitoredUser-method-MonitorInteractions\" rel=\"MobileCCS.MonitoredUser-method-MonitorInteractions\" class=\"docClass\">MonitorInteractions</a> method.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-updateDerivedProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-method-updateDerivedProperties' class='name expandable'>updateDerivedProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates derived property values after applying an update received from the server. ...</div><div class='long'><p>Updates derived property values after applying an update received from the server.</p>\n</div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});