/* jshint -W097 */
"use strict";

angular.module('refClientJS.attachments', ['refClientJS.alerts'])
.factory("attachmentService", ["alertsService", function(alertsService) {
    
    /**
     * The Attachment Service is responsible for storing JavaScript File objects and associating them with the appropriate Media object. These File objects are attachments 
     * that have been added to an outgoing email.
     * The JavaScript File objects cannot be stored on the angular scope (i.e. the model) directly since the File object is currently not compatible with the angular.copy()
     * method which is required in the $digest cycle when the model is being updated.
     */    
    var attachmentService = {};
    
    /*
     * A key / value map to store attachments associated with a media object. 
     * the key (object property name) is the media id, the value (object property value) is a Collection object containing JavaScript File objects 
     * (each one representing an attachment)    
     */
    attachmentService.attachmentsStore = Object.create(null);
    
    attachmentService.storeAttachmentFilesForMedia = function storeAttachmentFilesForMedia(mediaId, files) {
        var mediaAttachmentFiles = attachmentService.attachmentsStore[mediaId];

        // if no attachments are found for this media id, then create a new array and associate it with the media id
        if (mediaAttachmentFiles === undefined) {
            attachmentService.attachmentsStore[mediaId] = mediaAttachmentFiles = Object.create(null);
            alertsService.log('attachmentService: storeAttachmentFilesForMedia()', ' Create new attachment store for Media:' + mediaId);
            console.log(mediaAttachmentFiles);
            alertsService.log('attachmentService: storeAttachmentFilesForMedia()', ' #MediaAttachmentStores:' + Object.getOwnPropertyNames(attachmentService.attachmentsStore).length);
        }

        alertsService.log('attachmentService: storeAttachmentFilesForMedia()', ' ' + mediaId + ', Files');
        console.log(files);

        // add all files to the media attachment Collection with a key of file name and a value of file
        angular.forEach(files, function (file) {
            mediaAttachmentFiles[file.name] = file;
            alertsService.log('attachmentService: storeAttachmentFilesForMedia()', ' ' + mediaId + ', File:' + file.name);
            console.log(mediaAttachmentFiles[file.name]);
        });
        alertsService.log('attachmentService: storeAttachmentFilesForMedia()', ' ' + mediaId + ', #Files:' + Object.getOwnPropertyNames(mediaAttachmentFiles).length);
    };
    
    /*
     * Return an array of File objects
     */
    attachmentService.getAttachmentFilesForMedia = function getAttachmentFilesForMedia(mediaId) {
        var attachmentFilesCollection = attachmentService.attachmentsStore[mediaId];
        if (attachmentFilesCollection !== undefined) {
            // return an array of the Collection property values which are the JavaScript File objects
            return Object.values(attachmentFilesCollection);
        }
    };
    
    attachmentService.removeAttachmentFileForMedia = function removeAttachmentFileForMedia(mediaId, fileNameToRemove) {
        var mediaAttachmentFiles = attachmentService.attachmentsStore[mediaId];

        if (mediaAttachmentFiles !== undefined) {

            delete mediaAttachmentFiles[fileNameToRemove];

            alertsService.log('attachmentService: removeAttachmentFileForMedia()', 'Media:' + mediaId + ', FileRemoved?' + (mediaAttachmentFiles[fileNameToRemove] === undefined ? true : false) + ', #FilesInStore:' + Object.getOwnPropertyNames(mediaAttachmentFiles).length);

            // remove the Collection object if the last attachment File has been removed
            if (Object.getOwnPropertyNames(mediaAttachmentFiles).length <= 0) {
                attachmentService.clearAttachmentFilesForMedia(mediaId);
            }
        }
    };
    
    attachmentService.clearAttachmentFilesForMedia = function clearAttachmentFilesForMedia(mediaId) {
        alertsService.log('attachmentService: clearAttachmentFilesForMedia()', 'Media:' + mediaId);
        delete attachmentService.attachmentsStore[mediaId];
    };
    
    return attachmentService;    
}]);