/**
 * Angular module signedin manages the main state of the application os when the agent is signed into the contact center
 * This module and within this file the controller SignedinCtrl contains all the features available to the agent while signed into the AACC/ACCS
 * Each modal form which pops out of othe application has it's own controller contained here also. 
 * All angular services and factories defined in the project which interact with the server and provide up to date information are registered by this module 
 * and injected into these controllers    
 *
 * The controller scope is assigned to the ctrl variable for use in automated unit tests not part of the build folder
 * 
 */
angular.module('refClientJS.signedin', ['refClientJS.user', 'refClientJS.alerts', 'LocalStorageModule',
    'refClientJS.session', 'refClientJS.interactions',
    'refClientJS.supervisor', 'ui.grid', 'ui.grid.autoResize', 'ui.grid.selection', 'ui.grid.pagination', 'ngSanitize' ])

.controller('SignedinCtrl', ["$scope", "$sce", "$rootScope", "$timeout", "$state", "userData", "userService", "sessionData", "clientData", "interactionData", "interactionService", "resourceData", "supervisorService", "supervisorData", "$modal", "alertsData", "alertsService", "uiGridConstants", function SignedinCtrl($scope, $sce, $rootScope, $timeout, $state, userData, userService, sessionData, clientData, interactionData, interactionService, resourceData, supervisorService, supervisorData, $modal, alertsData, alertsService, uiGridConstants) {

    var ctrl = this;

    $scope.wrapupTimeout = ctrl.wrapupTimeout = false;
    $scope.freeFormNumber = ctrl.freeFormNumber = "";
    $scope.bg = {};
    $scope.bg.originate = 'assets\\originate.png';
    $scope.activeTabIndex = 0;
    $scope.counter = ctrl.counter = 0;

    $scope.$on('wrapup-countdown', function (event, args) {

        $scope.counter = args;
        $timeout($scope.onTimeout, 1000);
    });
    $scope.$on('preview-countdown', function (event, args) {

        $scope.previewCounter = args;
        $timeout($scope.onPreviewTimeout, 1000);
    });
    
    $scope.trustUrl = function (url) {
        return $sce.trustAsResourceUrl(url);
    };

    $scope.onPreviewTimeout = ctrl.onPreviewTimeout = function onPreviewTimeout() {
        $scope.previewCounter--;
        if ($scope.previewCounter > 0) {
            $scope.previewTimeout = $timeout($scope.onPreviewTimeout, 1000);

        } else {
            $timeout.cancel($scope.onPreviewTimeout);

            interactionService.previewDial();
        }
    };
    $scope.startWrapUp = ctrl.startWrapup = function startWrapup(event, args) {

        $scope.counter = args;
        $timeout($scope.onTimeout, 1000);
    };

    $scope.onTimeout = ctrl.onTimeout = function onTimeout() {
        $scope.counter--;
        if ($scope.counter > 0) {
            $scope.wrapupTimeout = $timeout($scope.onTimeout, 1000);

        } else {
            $timeout.cancel($scope.wrapupTimeout);
            console.log('JSDemoClient: SignedinCtrl: Wrap up time over');
            interactionService.wrapUpInteraction();
        }
    };


    $scope.extendWrapup = ctrl.extendWrapup = function extendWrapup(selectedInteraction) {
        //Subtracting a Zero converts the input to an integer 
        var extension = (selectedInteraction.WrapupTimer - 0);

        //Check if the counter is currently over 0            
        if ($scope.counter > 0) {
            //concatenation has higher precedence over addition operation
            $scope.counter = $scope.counter + extension;
        } else {
            $scope.counter = extension;
            $scope.wrapupTimeout = $timeout($scope.onTimeout, 1000);
        }
        //Call to POM server to alert that extension was requested as configurable number allowed
        selectedInteraction.ExtendWrapup();

    };

    $scope.startWrapupTimer = ctrl.startWrapupTimer = function start() {
        $timeout($scope.onTimeout, 1000);
    };
    $scope.startPreviewTimer = ctrl.startPreviewTimer = function start() {
        $timeout($scope.onTimeout, 1000);
    };

    ctrl.sessionDataChangeCB = function sessionDataChangeCB(newValue, oldValue) {

        ctrl.session = $scope.session = newValue;
    };

    $scope.$watchCollection(function () {
            return sessionData.session;
        },
        ctrl.sessionDataChangeCB,
        true);

    /*Supervisor form has tick box to enable the monitoring of an agents calls*/
    ctrl.monitorUserTick = $scope.monitorUserTick = function monitorUserTick(user, enable) {
        if (enable) {
            user.MonitorInteractions(supervisorService.monitorInteractions);
        } else {
            supervisorData.removeMonitoredInteractionsForUser(user);
        }
    };

    ctrl.demo = $scope.demo = false;

    $scope.destinationNumber = null;
    ctrl.NRRC = $scope.NRRC = null;
    ctrl.freeFormNumber = $scope.freeFormNumber = '';
    
    // the SignedinScope variable allows the developer identify what variables are currently available on the scope via the console command line;
    // 'test = this'
    // 'this.SignedinScope'
    // the signed in scope gives the console access to the scope and any variables on the scope can be accessed and printed to console.
    window.SignedinScope = $scope;
    
    ctrl.previewDialValue = $scope.previewDialValue = '';
    ctrl.newPreviewDialValue = $scope.newPreviewDialValue = '';
    ctrl.alerts = $scope.alerts = alertsData.alerts;
    ctrl.optClass = $scope.optClass = 'opt-disabled';


    ctrl.logger = $scope.logger = (function () {

        var pub = {};

        pub.oldConsoleLog = null;

        pub.enableLogger = function enableLogger() {
            if (pub.oldConsoleLog == null) {
                return;
            } else {
                window['console']['log'] = pub.oldConsoleLog;
            }
        };

        pub.disableLogger = function disableLogger() {
            pub.oldConsoleLog = console.log;
            window['console']['log'] = function () {};
        };

        return pub;
    }());

    ctrl.closeAlert = $scope.closeAlert = function closeAlert(index) {
        alertsService.closeAlert(index);
    };

    ctrl.clearAlerts = $scope.clearAlerts = function clearAlerts() {
        alertsService.clearAlerts();
    };


    ctrl.addAgentNote = function addAgentNote(interaction) {
        interaction.AddAgentNote($scope.inputs.note);
        $scope.inputs.note = '';
    };
    ctrl.monitorUsersForm = function monitorUsersForm() {
        console.log('JSDemoClient: SignedinCtrl: monitorUsersForm');
        $scope.monitorUsersShowForm = true;
        userService.monitorUsers();

    };
    ctrl.closeSprWidget = function closeSprWidget() {
        console.log('JSDemoClient: SignedinCtrl: closeSprWidget');
        $scope.monitorUsersShowForm = false;
        $scope.selectedUser = null;
        //unmonitor all and clear objects
        supervisorData.removeAllInteractions();
        supervisorData.removeAllMonitors();

    };

    ctrl.activityCode = function activityCode(i) {

        interactionService.getActivityCodes(i);
        //launch the modal form instance
        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'signedin/ActivityCodesModal.tpl.html',
            controller: 'ModalActivityInstanceCtrl',
            resolve: {
                interaction: function () {
                    return i;
                }
            }
        });
    };
    ctrl.getCodes = function getCodes(i) {
        console.log('JSDemoClient: SignedinCtrl: getCodes');
        console.log(i);
        interactionService.getDispositionCodes(i);
        //launch the modal form instance
        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'signedin/DispCodesModal.tpl.html',
            controller: 'ModalDispoInstanceCtrl',
            resolve: {
                interaction: function () {
                    return i;
                }
            }
        });
    };
    
    ctrl.consultList = function consultList(i) {

        console.log('JSDemoClient: SignedinCtrl: consultList');
        //Call method on the ineteraction Service which will query the list of valid destination types for 
        //an initial consult type from the POM server.
        if (i.ConsultDestTypes.length > 0) {
            interactionService.getConsultDestinations(i.ConsultDestTypes[0], i);
            var modalInstance = $modal.open({
                animation: false,
                templateUrl: 'signedin/ConsultModal.tpl.html',
                controller: 'ModalConsultInstanceCtrl',
                resolve: {
                    interaction: function () {
                        return i;
                    }
                }
            });
        } else {
            alertsService.addAlert('No consult destination types configured for this interaction', 'danger');

        }
    };
    ctrl.callbackForm = $scope.callbackForm = function callbackForm(i) {
        console.log('JSDemoClient: SignedinCtrl: callbackForm');

        if (i.CanGetCallbackDestinations) {
            //Callbacks require the list of allowed destination types where callbacks are processed from which might be type Agent or campaign but 
            //this is a configurable list in POM so therefor requires the method to retrieve them.

            interactionService.getCallbackDestinations(i);

            //interaction service handleCallbackDestinationTypes function will loop through returned types and request destinations for each type

            var modalInstance = $modal.open({
                animation: false,
                templateUrl: 'signedin/CallBackModal.tpl.html',
                controller: 'ModalCallBack',
                resolve: {
                    interaction: function () {
                        return i;
                    }
                }
            });
        } else {
            alertsService.addAlert('Unable to retrieve callback destinations from the POM server', 'danger');
        }
    };
    ctrl.launchDataForm = function launchDataForm(i) {

        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'signedin/DataModal.tpl.html',
            controller: 'ModalDataCtrl',
            resolve: {
                interaction: function () {
                    return i;
                }
            }
        });
    };
    ctrl.launchIntrinsicsForm = function launchIntrinsicsForm(i) {

        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'signedin/IntrinsicsModal.tpl.html',
            controller: 'ModalIntrinsicsCtrl',
            resolve: {
                interaction: function () {
                    return i;
                }
            }
        });
    };

    ctrl.launchUUIForm = function launchUUIForm(i) {

        console.log('launchUUIForm clicked');

        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'signedin/UUIModal.tpl.html',
            controller: 'ModalUUICtrl',
            resolve: {
                interaction: function () {
                    return i;
                }
            }
        });
    };

    $scope.newCall = ctrl.newCall = {};
    $scope.newCall.calledNumber = '';
    $scope.monitorUsersForm = ctrl.monitorUsersForm;
    $scope.launchDataForm = ctrl.launchDataForm;
    $scope.launchIntrinsicsForm = ctrl.launchIntrinsicsForm;
    $scope.launchUUIForm = ctrl.launchUUIForm;
    $scope.closeSprWidget = ctrl.closeSprWidget;
    $scope.user = ctrl.user = userData.user;
    $scope.userImg = ctrl.userImg = "assets\\presence_busy.png";
    $scope.callImg = ctrl.callImg = "assets\\contacttype_voice.png";
    $scope.emailImg = ctrl.emailImg = "assets\\contacttype_email.png";
    $scope.callSprImg = ctrl.callSprImg = "assets\\user_red.png";
    $scope.monitoredUsers = ctrl.monitoredUsers = userData.monitoredUsers;
    $scope.monitorUsersShowForm = ctrl.monitorUsersShowForm = false;
    $scope.monitoredInteractions = ctrl.monitoredInteractions = supervisorData.monitoredInteractions;

    $scope.resources = ctrl.resources = resourceData.resources;
    $scope.interactions = ctrl.interactions = interactionData.interactions;
    $scope.interactionsLength = 0; //interactionData.interactions.length;
    $scope.myinteractionData = interactionData;
    $scope.inputs = {
        note: null
    };
    $scope.agentNotes = interactionData.agentNotes;
    $scope.selectedinteractions = false;
    $scope.interactionSelected = ctrl.interactionSelected = false;
    $scope.defaultPreviewContactNumber = ctrl.defaultPreviewContactNumber = 'Select customer number to dial';
    $scope.destinationNumber = null;
    $scope.getCodes = ctrl.getCodes;
    $scope.consultList = ctrl.consultList;
    
    // This function can be called from the view to execute a specified target action when a key is pressed down. 
    // An example would be pressing the enter key to originate after entering a number to dial.
    // The event argument is the keydown event, the action is a string identifying the action to execute (i.e. originate)
    $scope.keypress = function keypress(event, action) {                
        // keycode 13 is the enter key
        if (event.keyCode == 13) {
            if (action === 'originate') {
                alertsService.log('SignedinCtrl: keypress', 'action=' + action);
                $scope.originate();
            }
        }
    };

    $scope.$watch("interactionSelected", function () {
        alertsService.log('SignedinCtrl: interactionSelected', 'interactionSelected has changed');
        if (typeof ($scope.interactionSelected) !== "undefined") {
            if ($scope.interactionSelected) {
                alertsService.log('SignedinCtrl: interactionSelected', 'ContactType:' + $scope.interactionSelected.ContactType);
                if ($scope.interactionSelected.ContactType == "POM_Outbound") {
                    $scope.defaultPreviewContactNumber = $scope.interactionSelected.ContactNumbers[0];                    
                }                
                $scope.activeTabIndex = 0;
            } else {
                alertsService.log('SignedinCtrl: interactionSelected', 'interaction null');
            }
        } else {
            alertsService.log('SignedinCtrl: interactionSelected', 'interaction undefined');
        }
    });

    $scope.getTabContent = ctrl.getTabContent = function getTabContent(interactionID, idx) {
        //loop through interaction array and assign the selected interaction for display on the application intrinsic tab
        alertsService.log('SignedinCtrl: getTabContent', ' Update the interactionSelected object');
        console.log('tab ' || idx || ' ' || interactionID);

        for (var i = $scope.interactions.length - 1; i >= 0; i--) {

            if ($scope.interactions[i].ID === interactionID) {
                $scope.interactionSelected = $scope.interactions[i];                
            }
        }
    };

    ctrl.notReady = function notReady() {
        userData.user.NotReady();
    };

    ctrl.notReadyWithCode = function notReadyWithCode() {
        if (ctrl.NRRC) {
            userData.user.NotReady(ctrl.NRRC);
        } else {
            userData.user.NotReady();
        }
    };
    $scope.ForceNotReadyWithReason = ctrl.ForceNotReadyWithReason = function ForceNotReadyWithReason(Agent) {
        alertsService.log('SignedinCtrl: ForceNotReadyWithReason', 'calling modal and retrieving not ready reason codes');
        supervisorService.getNotReadyReasonCodes(Agent);
        //launch modal for instance
        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'supervisor/NRRForcedCodesModal.tpl.html',
            controller: 'ModalNRRForcedCodesCtrl',
            resolve: {
                Agent: function () {
                    return Agent;
                }
            }

        });
    };
    ctrl.notReadyWithCodes = function notReadyWithCodes() {
        alertsService.log('SignedinCtrl: notReadyWithCodes', 'Calling modal and retrieving codes');
        //userService.getNotReadyReasonCodes();
        //launch the modal form instance
        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'signedin/NRRCodesModal.tpl.html',
            controller: 'ModalNRRCodesCtrl'

        });
    };
    ctrl.ACWCode = function ACWCode() {

        //launch the modal form instance
        var modalInstance = $modal.open({
            animation: false,
            templateUrl: 'signedin/ACWCodesModal.tpl.html',
            controller: 'ModalACWInstanceCtrl'

        });
    };
    ctrl.toggleDemo = function toggleDemo() {
        if ($scope.demo) {
            $scope.demo = false;
            $scope.optClass = 'opt-demo-disabled';
        } else {
            $scope.demo = true;
            $scope.optClass = 'opt-demo-enabled';
        }
        //hide the verboseinformation for example object capabilities and properties. Disabled buttons.

    };
    ctrl.disconnect = function disconnect() {

        clientData.client.Disconnect();

    };
    ctrl.getAgentNotes = function getAgentNotes(interaction) {
        interactionService.getNotes(interaction);
    };



    ctrl.logout = function logout() {
        userData.user.Logout();
    };
    ctrl.canLogOut = function canLogout() {
        return userData.user.CanLogout;
    };
    ctrl.login = function login() {
        if (userData.user.IsMultimedia) {
            //pop a login form to gather the multimedia password and the POM timezone.

            alertsService.log('SignedinCtrl: login', 'Calling login modal');

            //launch the modal form instance
            var modalInstance = $modal.open({
                animation: false,
                templateUrl: 'signedin/LoginModal.tpl.html',
                controller: 'ModalLoginCtrl',
                windowClass: 'login-modal-content'

            });

        } else {
            if (!userData.user.canLogout) {
                console.log(userData.user.canLogout);
                alertsService.log('SignedinCtrl: login', 'logging in');
                userData.user.Login();
            } else {
                alertsService.log('SignedinCtrl: login', 'User already logged in');
            }
        }
    };
    ctrl.originate = function originate() {

        if ($scope.newCall.calledNumber === '' || $scope.newCall.calledNumber === undefined) {

            alertsService.addAlert('A destination address must be provided to make a call.', 'danger');
        }

        resourceData.resources[0].Originate($scope.newCall.calledNumber);

    };
    
    ctrl.originateEmail = function originateEmail() {

        userData.user.OriginateEmail();

    };

    ctrl.pullContact = function pullContact() {

        if ($scope.newCall.calledNumber === '' || $scope.newCall.calledNumber === undefined) {
            alertsService.addAlert('A conatct ID must be provided to pull contact.', 'danger');
        }

        if (ctrl.readyState()) {
            alertsService.addAlert('Agent must be in NotReady state to pull contact.', 'danger');
        } else {
            userData.user.Retrieve($scope.newCall.calledNumber);
        }
    };

    ctrl.notReadyState = function notReadyState() {
        var states = ["NotReady", "NotReadyPending", "ACW", "ACWPending", "ReadyAfterCall"];
        var index;

        for (index = 0; index < states.length; index++) {
            if (userData.user.State === states[index]) {
                return true;
            }
        }
        return false;
    };

    ctrl.previewDial = function previewDial(dialNumber, currentInteraction) {

        console.log(dialNumber);
        var parsedInteractionNumber = JSON.parse(dialNumber);
        currentInteraction.PreviewDial(parsedInteractionNumber);

    };

    ctrl.redial = function redial(dialNumber, currentInteraction) {

        var parsedInteractionNumber = JSON.parse(dialNumber);
        currentInteraction.Redial(parsedInteractionNumber);

    };

    ctrl.ready = function ready() {
        userData.user.Ready();

    };

    ctrl.readyState = function readyState() {
        return userData.user.State === 'Ready';
    };
    
    ctrl.reject = function reject(interaction) {
        userData.user.NotReady();
    };

    /*Scope variables displayed in the view are assigned to the ctrl object to allow easily test in jasmine testcases from karma*/
    $scope.redial = ctrl.redial;
    $scope.addAgentNote = ctrl.addAgentNote;
    $scope.canLogOut = ctrl.canLogOut;
    $scope.toggleDemo = ctrl.toggleDemo;
    $scope.demo = ctrl.demo = false;
    $scope.disconnect = ctrl.disconnect;
    $scope.getAgentNotes = ctrl.getAgentNotes;
    $scope.getCodes = ctrl.getCodes;
    $scope.logOut = ctrl.logout;
    $scope.logIn = ctrl.login;
    $scope.notReady = ctrl.notReady;
    $scope.notReadyWithCode = ctrl.notReadyWithCode;
    $scope.notReadyState = ctrl.notReadyState;
    $scope.originate = ctrl.originate;
    $scope.originateEmail = ctrl.originateEmail;
    $scope.pullContact = ctrl.pullContact;
    $scope.previewDial = ctrl.previewDial;
    $scope.readyState = ctrl.readyState;
    $scope.ready = ctrl.ready;
    $scope.notReadyWithCodes = ctrl.notReadyWithCodes;
    $scope.activityCode = ctrl.activityCode;
    $scope.ACWCode = ctrl.ACWCode;
    $scope.wrapupCountDown = ctrl.wrapupCountDown = 0;
    $scope.reject = ctrl.reject;
    
    /*Customer Search not supported in 7.1.0.2 release*/
//    $scope.showCustomerSearch = false;    
//    $scope.toggleDisplayCustomerSearch = ctrl.toggleDisplayCustomerSearch = function() {        
//        if ($scope.showCustomerSearch === true) {
//            $scope.optCustSearchClass = 'opt-demo-disabled';
//            $scope.showCustomerSearch = false;
//        } else if ($scope.showCustomerSearch === false) {
//            $scope.optCustSearchClass = 'opt-demo-enabled';
//            $scope.showCustomerSearch = true;
//        }        
//    };       

    /*The following watches monitor the data factories and refresh the view on change*/

    ctrl.agentNotesChangeCB = function (newValue, oldValue) {

        ctrl.agentNotes = $scope.agentNotes = newValue;
    };


    ctrl.interactionDataChangeCB = function (newValue, oldValue) {
        alertsService.log('SignedinCtrl: interactionDataChangeCB', 'interaction collection changed');
        ctrl.interactions = $scope.interactions = newValue;

    };

    ctrl.monitoredUsersChangeCB = function (newValue, oldValue) {

        ctrl.monitoredUsers = $scope.monitoredUsers = newValue;        
    };
    
    ctrl.monitoredInteractionsChangeCB = function (newValue, oldValue) {
        
        ctrl.monitoredInteractions = $scope.monitoredInteractions = newValue;   
    };
    ctrl.userChangeCB = function (newValue, oldValue) {

        $scope.NRRC = null;
        ctrl.user = $scope.user = newValue;
        //refresh the user state image:
        if (ctrl.user.State == 'NotReady') {
            $scope.userImg = "assets\\presence_busy.png";
        } else if (ctrl.user.State == 'NotReadyPending') {
            $scope.userImg = "assets\\presence_away.png";
        } else if (ctrl.user.State == 'LoggedOut') {
            $scope.userImg = "assets\\presence_DND.png";
        } else {
            $scope.userImg = 'assets\\presence_available.png';
        }

    };
    ctrl.alertsChangeCB = function (newValue, oldValue) {

        ctrl.alerts = $scope.alerts = newValue;

    };
    ctrl.resourceChangeCB = function resourceChangeCB(newValue, oldValue) {

        if (angular.equals(newValue, oldValue)) {
            return; // simply skip that
        }
        ctrl.resources = $scope.resources = newValue;
    };
    
    $scope.$on('interaction-deleted', function (event, args) {
        alertsService.log("SignedinCtrl: interaction-deleted", " deleted interaction:" + args);
        if ($scope.interactionSelected !== undefined && args === $scope.interactionSelected.ID) { 
            alertsService.log("SignedinCtrl: interaction-deleted", " is the selected interaction, clear reference");
            // clear the selected interaction reference so it can be garbage collected
            $scope.interactionSelected = undefined;
        } 
    });

    $scope.$watchCollection(function () {
            return interactionData.agentNotes;
        },
        ctrl.agentNotesChangeCB,
        true);

    $scope.$watchCollection(function () {
            return userData.monitoredUsers;
        },
        ctrl.monitoredUsersChangeCB,
        true);
    $scope.$watchCollection(function () {
            return supervisorData.monitoredInteractions;
        },
        ctrl.monitoredInteractionsChangeCB,
        true);
    $scope.$watchCollection(function () {
            return interactionData.interactions;
        },
        ctrl.interactionDataChangeCB,
        true);
    
    $scope.$watch(function () {
            return resourceData.resources;
        },
        ctrl.resourceChangeCB,
        true);

    $scope.$watchCollection(function () {
            return userData.user;
        },
        ctrl.userChangeCB,
        true);
    $scope.$watchCollection(function () {
            return alertsData.alerts;
        },
        ctrl.alertsChangeCB,
        true);

    if (!clientData.client.IsConnected) {
        $state.go('signin');
    }

}])

.directive('phoneNumber', function () {
    var regexP = /[0-9]|\./i;

    return {
        require: '?ngModel',
        link: function (scope, elm, attrs, ctrl) {
            // only apply the validator if ngModel is present and Angular has added the text validator
            console.log('phoneNumber directive');
            console.log(ctrl.$validators);
            if (ctrl && ctrl.$validators.text) {

                // this will overwrite the default Angular text validator
                ctrl.$validators.text = function (modelValue) {
                    return ctrl.$isEmpty(modelValue) || regexP.test(modelValue);
                };
            }
        }
    };
})
.directive("contenteditable", ['$sce', function($sce) {
    /* 
     * Custom directive to provide an angular implementation for content editiable (currently it is not supported natively in angular)
     */
    return {
        restrict: "A",
        require: "ngModel",
        link: function(scope, element, attrs, ngModel) {
            if (!ngModel) {
                // do nothing if no ng-model
                return; 
            }

            function read() {
                var html = element.html();
                // When we clear the content editable the browser leaves a <br> behind, remove this
                if (html === '<br>') {
                    html = '';
                }                
                ngModel.$setViewValue(element.html());
            }

            ngModel.$render = function() {
                element.html($sce.getTrustedHtml(ngModel.$viewValue || ''));
            };

            element.bind("blur keyup change", function() {
                scope.$apply(read);
            });
        }
    };
}])
.directive('onFileChange', ["$parse", function($parse) {
    /*
     * Custom file change directive which invokes a specified function when an input element of type file changes. 
     * The files that were selected in the input element are passed to the specfied function.
     * This is to support adding attachments.
     */
    return {
        restrict: 'A',
        link: function(scope, element, attrs) {
            
            var fileChangeFunctionToInvoke = $parse(attrs.onFileChange);
            console.log("onFileChange directive, function: " + attrs.onFileChange);
            /**
             * Bind the element change event to invoke the function defined as the attribute value
             */
            element.bind('change', function(event) {
                console.log("onFileChange element bind");  

                scope.$apply(function() {
                    fileChangeFunctionToInvoke(scope, {files:element[0].files});
                });
            });
        }
    };
}])
.controller('ModalLoginCtrl', ['$scope', '$modalInstance', 'userData', 'userService', 'sessionService', 'localStorageService', function ($scope, $modalInstance, userData, userService, sessionData, localStorageService) {
        var ctrl = this;

        window.modalstuff = $scope;

        ctrl.loginID = $scope.loginID = userData.user.ID;
        ctrl.loginPassword = $scope.loginPassword = localStorageService.get('password');                                                    
        ctrl.PZ = $scope.PZ = '';
        ctrl.dataLoading = $scope.dataLoading = false;
        ctrl.pzones = $scope.pzones = userData.user.PomZones;
        ctrl.pzones.repeatSelect = $scope.pzones.repeatSelect = userData.user.PomZones[0];


        $scope.hasPOMContactType = function hasPOMContactType() {

            for (index = 0; index < userData.user.ContactTypes.length; index++) {
                if (userData.user.ContactTypes[index] === "POM_Outbound") {
                    return true;
                }
            }
            return false;

        };

        ctrl.logInToContactCenter = $scope.logInToContactCenter = function logInToContactCenter() {

            ctrl.dataLoading = true;
            userData.user.Login($scope.loginPassword, $scope.pzones.repeatSelect);
            $scope.cancel();
        };

        $scope.cancel = ctrl.cancel = function cancel() {
            $modalInstance.dismiss('cancel');
        };

    }])
    .controller('ModalConsultInstanceCtrl', ['$scope', '$modalInstance', 'interactionData', 'interactionService', 'interaction', function ($scope, $modalInstance, interactionData, interactionService, interaction) {
        var ctrl = this;
        window.modalstuff = $scope;

        ctrl.consultDests = interactionData.consultDests;

        ctrl.destSelected = $scope.destSelected = false;
        ctrl.interaction = $scope.interaction = interaction;
        ctrl.selectedDestList = $scope.selectedDestList = false;
        ctrl.tabs = $scope.tabs = [];

        ctrl.interactionDataChangeCB = function interactionDataChangeCB(newValue, oldValue) {

            ctrl.consultDests = $scope.consultDests = newValue;

        };        

        ctrl.onTabSelect = $scope.onTabSelect = function (DestListType) {
            $scope.selectedDestList = DestListType;
            $scope.consultDests = ctrl.consultDests = [];
            interactionService.getConsultDestinations(DestListType, interaction);
        };

        $scope.$watchCollection(function () {
                return interactionData.consultDests;
            },
            ctrl.interactionDataChangeCB,
            true);


        ctrl.refresh = function refresh() {
            interactionService.getConsultDestinations($scope.selectedDestList, interaction);
        };


        ctrl.initTrans = function initTrans(selected) {
            $scope.interaction.InitiateTransferToDestination(selected);

            this.cancel();

        };

        ctrl.initConf = function initConf(selected) {
            $scope.interaction.InitiateConferenceToDestination(selected);
            this.cancel();

        };

        ctrl.cancel = function cancel() {
            interactionData.consultDests = false;
            $scope.consultDests = false;
            $modalInstance.dismiss('cancel');
        };

        $scope.refresh = ctrl.refresh;
        $scope.initConf = ctrl.initConf;
        $scope.initTrans = ctrl.initTrans;
        $scope.cancel = ctrl.cancel;
        $scope.consultDests = ctrl.consultDests;

    }])
    .controller('ModalDispoInstanceCtrl', ['$scope', '$modalInstance', 'interactionData', 'interaction', function ($scope, $modalInstance, interactionData, interaction) {
        var ctrl = this;
        window.modalstuff = $scope;

        ctrl.dispositionCodes = interactionData.dispositionCodes;
        ctrl.dispoSelected = $scope.dispoSelected = false;
        ctrl.interaction = $scope.interaction = interaction;

        ctrl.interactionDataChangeCB = function interactionDataChangeCB(newValue, oldValue) {

            ctrl.dispositionCodes = $scope.dispositionCodes = newValue;
        };

        $scope.$watchCollection(function () {
                return interactionData.dispositionCodes;
            },
            ctrl.interactionDataChangeCB,
            true);

        ctrl.submit = function submit(dispoSelected) {
            if ($scope.interaction.ContactType == "EMail" || $scope.interaction.ContactType == "Web_Communications") {
                $scope.interaction.SetClosedReasonCode(dispoSelected.Code);
            } else {
                $scope.interaction.WrapupWithCode(dispoSelected.Code, dispoSelected.Name);
            }
            this.cancel();
        };

        ctrl.cancel = function cancel() {
            interactionData.dispositionCodes = false;
            $scope.dispositionCodes = false;
            $modalInstance.dismiss('cancel');
        };

        $scope.submit = ctrl.submit;
        $scope.cancel = ctrl.cancel;
        $scope.dispositionCodes = ctrl.dispositionCodes;

    }])
    .controller('ModalCallBack', ['$scope', '$modalInstance', 'interactionService', 'interactionData', 'sessionData', 'interaction', function ($scope, $modalInstance, interactionService, interactionData, sessionData, interaction) {
        //Controller for the Create Call back modal form
        //Using bootstrap validation the form collects the required values for the createCallback method.

        var ctrl = this;
        window.modalstuff = $scope;
        var localCustomerNumberSelected = '';
        $scope.date = new Date();

        $scope.callbackDate = {
            callbackDateTime: new Date(Date.now()),
            expiryMinutes: 0

        };



        var currentDate = new Date();

        //Value of interaction passed to this controller to display on the modal form
        ctrl.interaction = $scope.interaction = interaction;

        //Callback Destinations are received from the pom server through the use of the Handler function handleConsultDests in the Interaction Service  

        ctrl.destinations = $scope.destinations = false;
        $scope.submitted = false;

        $scope.$watch("interaction.ContactNumbers.repeatSelect", function () {
            if ($scope.interaction.ContactNumbers.repeatSelect) {
                $scope.customerNumberSelected = JSON.parse(interaction.ContactNumbers.repeatSelect);
            }

        });

        $scope.$on('callbackdestinations', function (event, args) {
            ctrl.destinations = $scope.destinations = interactionData.callbackDestinations;
        });




        ctrl.createCallback = function createCallback() {

            $scope.submitted = true;
            ctrl.destinations = $scope.destinations = false;
            var formattedCallbackDate = $scope.parseDateForPOM($scope.callbackDate.callbackDateTime);

            if ($scope.callbackModalForm.$valid) {
                $scope.submitting = true;
                interaction.CreateCallback($scope.callback.callbackDest,
                    $scope.customerNumberSelected,
                    formattedCallbackDate,
                    $scope.callbackDate.expiryMinutes,
                    $scope.callback.agentNotes);
            } else {
                $window.alert('Please fix any validation errors and try again.');
            }
            $scope.cancel();
        };


        ctrl.createCallbackExternal = function createCallbackExternal() {
            //Creating a callback passing a new customer number which is built into a contactNumber
            $scope.submitted = true;

            var formattedCallbackDate = $scope.parseDateForPOM($scope.callbackDate.callbackDateTime);

            if ($scope.callbackModalForm.$valid) {
                $scope.submitting = true;
                interaction.CreateCallback(
                    $scope.callback.callbackDest, {
                        IsDefault: false,
                        Name: 'External',
                        Number: $scope.customerNumberSelected,
                        Timezone: formattedCallbackDate
                    },
                    formattedCallbackDate,
                    $scope.callbackDate.expiryMinutes,
                    $scope.callback.agentNotes);
                interactionData.callbackDestinations = [];
                ctrl.destinations = $scope.destinations = false;
            } else {
                $window.alert('Please fix any validation errors and try again.');
            }
            $scope.cancel();
        };


        ctrl.cancel = function cancel() {

            interactionData.callbackDestinations = [];
            ctrl.destinations = $scope.destinations = false;
            $modalInstance.dismiss('cancel');
        };

        ctrl.parseDateForPOM = function parseDateForPOM(cbDate) {

            var lMonth = cbDate.getMonth() + 1;
            var lYear = cbDate.getFullYear();
            var lDay = cbDate.getDate();
            var lHours = cbDate.getDate();
            var lMinutes = cbDate.getDate();

            return (lYear + '/' + lMonth + '/' + lDay + ' ' + lHours + ':' + lMinutes);


        };

        $scope.cancel = ctrl.cancel;
        $scope.createCallbackExternal = ctrl.createCallbackExternal;
        $scope.createCallback = ctrl.createCallback;
        $scope.parseDateForPOM = ctrl.parseDateForPOM;

    }])
    .controller('ModalDataCtrl', ['$scope', '$modalInstance', 'interaction', function ($scope, $modalInstance, interaction) {
        //Controller of the Modal form displayed with the interaction data
        //passed the interaction object used to retrieve the current data object and access the update and remove data methods

        var ctrl = this;
        window.modalstuff = $scope;

        ctrl.interaction = $scope.interaction = interaction;


        ctrl.dataKVP = $scope.dataKVP = {};
        ctrl.dataSTR = $scope.dataSTR = {};
        ctrl.dataBIN = $scope.dataBIN = {};

        if (interaction.Data) {
            if (interaction.Data.STR) {
                ctrl.dataSTR = $scope.dataSTR = interaction.Data;
            } else if (interaction.Data.KVP) {
                $scope.dataKVP = interaction.Data;
            } else {
                $scope.dataBIN = interaction.Data;
            }
        }


        ctrl.cancel = function cancel() {
            //Close the modal form and reset the data value
            ctrl.dataKVP = $scope.dataKVP = {};
            ctrl.dataSTR = $scope.dataSTR = {};
            ctrl.dataBIN = $scope.dataBIN = {};
            $modalInstance.dismiss('cancel');
        };

        $scope.cancel = ctrl.cancel;

        //Interaction deleted so modal form should cose
        $scope.$on('interaction-deleted', function (event, args) {


            if (args === $scope.interaction.ID) {
                $scope.cancel();
            }
        });
        ctrl.addKVPData = $scope.addKVPData = function addKVPData(key, value) {
            //Create a key value pair object to pass to the server when the update is eventually clicked

            if ($scope.dataKVP.KVP) {
                $scope.dataKVP.KVP[key] = value;
                ctrl.dataKVP = $scope.dataKVP;

            } else {
                $scope.dataKVP = {
                    KVP: {}
                };
                $scope.dataKVP.KVP[key] = value;

            }
            $scope.dataNewKVPkey = '';
            $scope.dataNewKVPvalue = '';
        };

        //Listening for broadcasts from the interaction Service factory in case of changes to the interaction
        //data list
        $scope.$on("updateInteractions", function (event, args) {
            //Changed to the stored interactions arry in the ineteractionData factory
            //loop through the updated array of interactions and refresh the data object
            //for the interaction currently having data displayed on the form

            for (var i = args.length - 1; i >= 0; i--) {
                if (args[i].ID === $scope.interaction.ID) {
                    $scope.interaction = args[i];
                    if (interaction.Data) {
                        if (interaction.Data.STR) {
                            ctrl.dataSTR = $scope.dataSTR = interaction.Data;
                            ctrl.dataKVP = $scope.dataKVP = {};
                            ctrl.dataBIN = $scope.dataBIN = {};
                        } else if (interaction.Data.KVP) {
                            ctrl.dataKVP = $scope.dataKVP = interaction.Data;
                            ctrl.dataKVP = $scope.dataSTR = {};
                            ctrl.dataBIN = $scope.dataBIN = {};
                        } else {
                            ctrl.dataBIN = $scope.dataBIN = interaction.Data;
                            ctrl.dataKVP = $scope.dataKVP = {};
                            ctrl.dataBIN = $scope.dataSTR = {};
                        }
                    } else {
                        ctrl.dataBIN = $scope.dataBIN = {};
                        ctrl.dataKVP = $scope.dataKVP = {};
                        ctrl.dataBIN = $scope.dataSTR = {};
                    }
                }
            }
        });



    }])
    .controller('ModalIntrinsicsCtrl', ['$scope', '$modalInstance', 'interaction', function ($scope, $modalInstance, interaction) {
        //Controller used by the Modal which is presented when the intrinsics button is clicked on an interaction 
        //Displays in a table the list of intrinsics and for each an update/remove button
        //Also possible to add a new intrinsic to the list 

        var ctrl = this;
        window.modalstuff = $scope;
        //Used by the modal to execute adding, updating and removing intrinsics 
        ctrl.interaction = $scope.interaction = interaction;
        ctrl.intrinsics = $scope.intrinsics = interaction.Intrinsics;
        ctrl.errorIntrinsic = $scope.errorIntrinsic = '';
        ctrl.newIntrinsic = $scope.newIntrinsic = {};

        //When the x is clicked on the modal this function fires to close and reset the local intrinsics variable
        ctrl.cancel = function cancel() {
            $scope.intrinsics = false;
            $modalInstance.dismiss('cancel');
        };

        $scope.cancel = ctrl.cancel;


        //Listening for broadcasts from the interaction Service factory in case of changes to the interaction
        //intrinsics list
        $scope.$on("updateInteractions", function (event, args) {
            //Changed to the stored interactions arry in the ineteractionData factory
            //loop through the updated array of interactions and refresh the intrinsics list
            //for the interaction currently having intrinsics displayed on the form
            for (var i = args.length - 1; i >= 0; i--) {
                if (args[i].ID === $scope.interaction.ID) {
                    $scope.interaction = args[i];
                    $scope.intrinsics = interaction.Intrinsics;
                }
            }

        });
        //Interaction deleted so modal form should cose
        $scope.$on('interaction-deleted', function (event, args) {
            if (args === $scope.interaction.ID) {
                $scope.cancel();
            }
        });


    }])
    .controller('ModalUUICtrl', ['$scope', '$modalInstance', 'interaction', function ($scope, $modalInstance, interaction) {
        //Controller of the Modal form displayed with the interaction uui
        //passed the interaction object used to retrieve the current uui and access the update uui method

        var ctrl = this;
        window.modalstuff = $scope;

        ctrl.interaction = $scope.interaction = interaction;
        ctrl.uui = $scope.uui = interaction.UUI;



        ctrl.cancel = function cancel() {

            $scope.uui = false;
            $modalInstance.dismiss('cancel');
        };

        //Listening for broadcasts from the interaction Service factory in case of changes to the interaction
        //uui
        $scope.$on("updateInteractions", function (event, args) {
            //Changed to the stored interactions arry in the interactionData factory
            //loop through the updated array of interactions and refresh the uui
            //for the interaction currently having uui displayed on the form
            for (var i = args.length - 1; i >= 0; i--) {
                if (args[i].ID === $scope.interaction.ID) {
                    $scope.interaction = args[i];
                    $scope.uui = interaction.UUI;
                }
            }

        });
        $scope.cancel = ctrl.cancel;
        $scope.uui = ctrl.uui;
        //Interaction deleted so modal form should close
        $scope.$on('interaction-deleted', function (event, args) {

            if (args === $scope.interaction.ID) {
                $scope.cancel();
            }
        });
    }])
    .controller('ModalActivityInstanceCtrl', ['$scope', '$modalInstance', 'interactionData', 'interaction', function ($scope, $modalInstance, interactionData, interaction) {
        var ctrl = this;
        window.modalstuff = $scope;

        ctrl.codes = interactionData.ActivityCodes;
        ctrl.selected = $scope.selected = false;
        ctrl.interaction = $scope.interaction = interaction;

        ctrl.interactionDataChangeCB = function interactionDataChangeCB(newValue, oldValue) {

            ctrl.codes = $scope.codes = newValue;
        };

        $scope.$watchCollection(function () {
                return interactionData.activityCodes;
            },
            ctrl.interactionDataChangeCB,
            true);

        ctrl.submit = function submit(selected) {
            $scope.interaction.SetActivityCode(selected.Code, selected.Name);
            this.cancel();

        };

        ctrl.cancel = function cancel() {
            interactionData.activityCodes = false;
            $scope.codes = false;
            $modalInstance.dismiss('cancel');
        };

        $scope.submit = ctrl.submit;
        $scope.cancel = ctrl.cancel;
        $scope.codes = ctrl.codes;

        //Interaction deleted so modal form should close
        $scope.$on('interaction-deleted', function (event, args) {

            if (args === $scope.interaction.ID) {
                $scope.cancel();
            }
        });

    }])
    .controller('ModalACWInstanceCtrl', ['$scope', '$modalInstance', 'sessionData', 'userData', function ($scope, $modalInstance, sessionData, userData) {
        var ctrl = this;


        //Parse the codes from the session object for display purposes on the modal
        var parsedCodes = [];
        var element = {};

        for (var key in sessionData.session.ACWCodes.Codes) {
            if (sessionData.session.ACWCodes.Codes.hasOwnProperty(key)) {
                element.Code = key;
                element.Name = sessionData.session.ACWCodes.Codes[key];
            }
            parsedCodes.push(element);
            element = {};
        }
        ctrl.codes = parsedCodes;

        window.modalstuff = $scope;

        ctrl.selected = $scope.selected = false;


        ctrl.submit = function submit(selected) {
            userData.user.AfterCallWork(selected.Code, selected.Name);
            this.cancel();

        };

        ctrl.cancel = function cancel() {
            $modalInstance.dismiss('cancel');
        };

        $scope.submit = ctrl.submit;
        $scope.cancel = ctrl.cancel;
        $scope.codes = ctrl.codes;


    }])
    .controller('ModalNRRCodesCtrl', ['$scope', '$modalInstance', 'sessionData', 'userData', function ($scope, $modalInstance, sessionData, userData) {
        var ctrl = this;
        //Parse the codes from the session object for display purposes on the modal
        var parsedCodes = [];
        var element = {};

        for (var key in sessionData.session.NRRCCodes.Codes) {
            if (sessionData.session.NRRCCodes.Codes.hasOwnProperty(key)) {
                element.Code = key;
                element.Name = sessionData.session.NRRCCodes.Codes[key];
            }
            parsedCodes.push(element);
            element = {};
        }
        ctrl.NRRCodes = parsedCodes;

        window.modalstuff = $scope;

        ctrl.codeSelected = $scope.codeSelected = false;


        ctrl.submit = function submit(codeSelected) {
            if (codeSelected) {
                userData.user.NotReady(codeSelected.Code);
            }
            this.cancel();

        };

        ctrl.cancel = function cancel() {

            $modalInstance.dismiss('cancel');
        };

        $scope.submit = ctrl.submit;
        $scope.cancel = ctrl.cancel;
        $scope.NRRCodes = ctrl.NRRCodes;

    }])
    .controller('ModalNRRForcedCodesCtrl', ['$scope', '$modalInstance', 'supervisorData', 'Agent', function ($scope, $modalInstance, supervisorData, Agent) {
        var ctrl = this;
        window.modalstuff = $scope;
        ctrl.NRRCodes = supervisorData.ForcedNRRCodes;
        ctrl.codeSelected = $scope.codeSelected = false;
        ctrl.Agent = $scope.Agent = Agent;


        ctrl.supervisorDataChangeCB = function supervisorDataChangeCB(newValue, oldValue) {
            ctrl.NRRCodes = $scope.NRRCodes = newValue;
        };

        $scope.$watchCollection(function () {
                return supervisorData.ForcedNRRCodes;
            },
            ctrl.supervisorDataChangeCB,
            true);

        ctrl.submit = function submit(codeSelected) {
            if (codeSelected) {
                Agent.ForceNotReady(codeSelected.Code);
            }
            supervisorData.ForcedNRRCodes = {};
            this.cancel();

        };

        ctrl.cancel = function cancel() {
            supervisorData.ForcedNRRCodes = {};
            $modalInstance.dismiss('cancel');
        };

        $scope.submit = ctrl.submit;
        $scope.cancel = ctrl.cancel;
        $scope.NRRCodes = ctrl.NRRCodes;


    }]);