Ext.data.JsonP.MobileCCS_BaseMedia({"tagname":"class","name":"MobileCCS.BaseMedia","autodetected":{},"files":[{"filename":"ccs-basemedia.js","href":null}],"extends":"CCSObject","abstract":true,"members":[{"name":"ArrivalTime","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ArrivalTime","meta":{"readonly":true}},{"name":"ContactID","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ContactID","meta":{"readonly":true}},{"name":"ContactType","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-ContactType","meta":{"readonly":true}},{"name":"From","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-From","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"Status","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-Status","meta":{"readonly":true}},{"name":"Subject","tagname":"property","owner":"MobileCCS.BaseMedia","id":"property-Subject","meta":{"readonly":true}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.BaseMedia","short_doc":"The BaseMedia object is a base class for modelling the media associated with interactions for contact types other tha...","component":false,"superclasses":["CCSObject"],"subclasses":["MobileCCS.EmailMedia","MobileCCS.WebchatMedia"],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><strong>MobileCCS.BaseMedia</strong></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/MobileCCS.EmailMedia' rel='MobileCCS.EmailMedia' class='docClass'>MobileCCS.EmailMedia</a></div><div class='dependency'><a href='#!/api/MobileCCS.WebchatMedia' rel='MobileCCS.WebchatMedia' class='docClass'>MobileCCS.WebchatMedia</a></div></pre><div class='doc-contents'><p>The <em>BaseMedia</em> object is a base class for modelling the media associated with interactions for contact types other that Voice.\nFor Voice contacts, the media is the speech path between the parties on the call and is not modelled in the Contact Control\nService.  For contact types such as Email or Web Communications, the <em>BaseMedia</em> object provides the contents of the email or\nweb chat session.</p>\n\n<p><em>Media</em> objects are retrieved from the server by calling the <a href=\"#!/api/MobileCCS.Interaction-method-OpenMedia\" rel=\"MobileCCS.Interaction-method-OpenMedia\" class=\"docClass\">OpenMedia</a>\nmethod on the <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-ArrivalTime' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseMedia'>MobileCCS.BaseMedia</span><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ArrivalTime' class='name expandable'>ArrivalTime</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The time at which the interaction associated with this media arrived at the Conatac Center.</p>\n</div><div class='long'><p>The time at which the interaction associated with this media arrived at the Conatac Center.</p>\n</div></div></div><div id='property-ContactID' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseMedia'>MobileCCS.BaseMedia</span><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ContactID' class='name expandable'>ContactID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The ID of the contact associated with this Media object. ...</div><div class='long'><p>The ID of the contact associated with this Media object.  The value of the <em>ContactID</em> property is a string\nthat identifies the contact within the context of the underlying service provider.</p>\n\n<p>The contents of the contact ID string depend on the underlying service provider, therefore\nthe application should not rely on the <em>ContactID</em> string being of a particular format.</p>\n</div></div></div><div id='property-ContactType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseMedia'>MobileCCS.BaseMedia</span><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-ContactType' class='name expandable'>ContactType</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The contact type for this interaction. ...</div><div class='long'><p>The contact type for this interaction.</p>\n\n<p>This property allows the client to determine what contact type is being handled by this interaction.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">ContactTypes</a> class.</p>\n</div></div></div><div id='property-From' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseMedia'>MobileCCS.BaseMedia</span><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-From' class='name expandable'>From</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the address of the customer that initiated the contact.</p>\n</div><div class='long'><p>Provides the address of the customer that initiated the contact.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-Status' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseMedia'>MobileCCS.BaseMedia</span><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-Status' class='name expandable'>Status</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The status of the interaction. ...</div><div class='long'><p>The status of the interaction.</p>\n\n<p>This property allows the client to determine the current status this interaction.</p>\n\n<p>Possible values are <strong>New</strong>, <strong>Closed</strong>, <strong>Open</strong> and <strong>Waiting</strong>.</p>\n</div></div></div><div id='property-Subject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.BaseMedia'>MobileCCS.BaseMedia</span><br/></div><a href='#!/api/MobileCCS.BaseMedia-property-Subject' class='name expandable'>Subject</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The subject of the contact.</p>\n</div><div class='long'><p>The subject of the contact.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-IsFunctionAvailable' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"abstract":true}});