Ext.data.JsonP.MobileCCS_ClientState({"tagname":"class","name":"MobileCCS.ClientState","autodetected":{"members":true},"files":[{"filename":"ccs-enums.js","href":null}],"enum":{"type":"String","default":null,"doc_only":null},"members":[{"name":"Authenticated","tagname":"property","owner":"MobileCCS.ClientState","id":"property-Authenticated","meta":{"readonly":true}},{"name":"Authenticating","tagname":"property","owner":"MobileCCS.ClientState","id":"property-Authenticating","meta":{"readonly":true}},{"name":"AwaitingSwitchover","tagname":"property","owner":"MobileCCS.ClientState","id":"property-AwaitingSwitchover","meta":{"readonly":true}},{"name":"Connected","tagname":"property","owner":"MobileCCS.ClientState","id":"property-Connected","meta":{"readonly":true}},{"name":"Connecting","tagname":"property","owner":"MobileCCS.ClientState","id":"property-Connecting","meta":{"readonly":true}},{"name":"NotConnected","tagname":"property","owner":"MobileCCS.ClientState","id":"property-NotConnected","meta":{"readonly":true}},{"name":"Reconnecting","tagname":"property","owner":"MobileCCS.ClientState","id":"property-Reconnecting","meta":{"readonly":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.ClientState","short_doc":"The ClientState class contains definitions for the states that a Client object can be in, which is essentially\nthe st...","component":false,"superclasses":[],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><div class='doc-contents'><p>The <em>ClientState</em> class contains definitions for the states that a <em>Client</em> object can be in, which is essentially\nthe state of the connection to the server.  These states are used on the <a href=\"#!/api/MobileCCS.Client-property-State\" rel=\"MobileCCS.Client-property-State\" class=\"docClass\">Client.State</a>\nproperty to provide the client application with information regarding the state of the server connection.</p>\n<div class='rounded-box enum-box'><p><strong>ENUM:</strong> This enumeration defines a set of String values.</p></div></div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-Authenticated' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.ClientState'>MobileCCS.ClientState</span><br/></div><a href='#!/api/MobileCCS.ClientState-property-Authenticated' class='name expandable'>Authenticated</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A connection with the server is established and authenticated. ...</div><div class='long'><p>A connection with the server is established and authenticated.</p>\n<p>Defaults to: <code>&quot;Authenticated&quot;</code></p></div></div></div><div id='property-Authenticating' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.ClientState'>MobileCCS.ClientState</span><br/></div><a href='#!/api/MobileCCS.ClientState-property-Authenticating' class='name expandable'>Authenticating</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A connection has been established and the Client object is now attempting to authenticate with the server using the\na...</div><div class='long'><p>A connection has been established and the <em>Client</em> object is now attempting to authenticate with the server using the\napplication-supplied credentials.</p>\n<p>Defaults to: <code>&quot;Authenticating&quot;</code></p></div></div></div><div id='property-AwaitingSwitchover' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.ClientState'>MobileCCS.ClientState</span><br/></div><a href='#!/api/MobileCCS.ClientState-property-AwaitingSwitchover' class='name expandable'>AwaitingSwitchover</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The connection to the Active server has failed and the connection to the Standby server hasn't yet become active. ...</div><div class='long'><p>The connection to the Active server has failed and the connection to the Standby server hasn't yet become active.</p>\n<p>Defaults to: <code>&quot;AwaitingSwitchover&quot;</code></p></div></div></div><div id='property-Connected' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.ClientState'>MobileCCS.ClientState</span><br/></div><a href='#!/api/MobileCCS.ClientState-property-Connected' class='name expandable'>Connected</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The connection to the server has been established, but not signed in. ...</div><div class='long'><p>The connection to the server has been established, but not signed in.</p>\n\n<p>This state will only be seen if the application uses the <a href=\"#!/api/MobileCCS.Client-method-Connect\" rel=\"MobileCCS.Client-method-Connect\" class=\"docClass\">Client.Connect</a> method to\nconnect to the server without an automatic sign-in attempt.</p>\n<p>Defaults to: <code>&quot;Connected&quot;</code></p></div></div></div><div id='property-Connecting' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.ClientState'>MobileCCS.ClientState</span><br/></div><a href='#!/api/MobileCCS.ClientState-property-Connecting' class='name expandable'>Connecting</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The Client object is attempting connection to the server. ...</div><div class='long'><p>The <em>Client</em> object is attempting connection to the server.</p>\n<p>Defaults to: <code>&quot;Connecting&quot;</code></p></div></div></div><div id='property-NotConnected' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.ClientState'>MobileCCS.ClientState</span><br/></div><a href='#!/api/MobileCCS.ClientState-property-NotConnected' class='name expandable'>NotConnected</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>There is no connection to the server. ...</div><div class='long'><p>There is no connection to the server.  This is the initial state.</p>\n<p>Defaults to: <code>&quot;NotConnected&quot;</code></p></div></div></div><div id='property-Reconnecting' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.ClientState'>MobileCCS.ClientState</span><br/></div><a href='#!/api/MobileCCS.ClientState-property-Reconnecting' class='name expandable'>Reconnecting</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The connection to the server has been lost but automatic reconnection is being attempted. ...</div><div class='long'><p>The connection to the server has been lost but automatic reconnection is being attempted.</p>\n<p>Defaults to: <code>&quot;Reconnecting&quot;</code></p></div></div></div></div></div></div></div>","meta":{}});