Ext.data.JsonP.MobileCCS_MonitoredInteraction({"tagname":"class","name":"MobileCCS.MonitoredInteraction","autodetected":{},"files":[{"filename":"ccs-monitoredinteraction.js","href":null}],"extends":"MobileCCS.BaseInteraction","members":[{"name":"ActivityCode","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-ActivityCode","meta":{"readonly":true}},{"name":"Address","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-Address","meta":{"readonly":true}},{"name":"CalledAddress","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-CalledAddress","meta":{"readonly":true}},{"name":"CalledAddressName","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-CalledAddressName","meta":{"readonly":true}},{"name":"CallingAddress","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-CallingAddress","meta":{"readonly":true}},{"name":"CallingAddressName","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-CallingAddressName","meta":{"readonly":true}},{"name":"CanBargeIn","tagname":"property","owner":"MobileCCS.MonitoredInteraction","id":"property-CanBargeIn","meta":{"readonly":true}},{"name":"CanObserve","tagname":"property","owner":"MobileCCS.MonitoredInteraction","id":"property-CanObserve","meta":{"readonly":true}},{"name":"CanWhisper","tagname":"property","owner":"MobileCCS.MonitoredInteraction","id":"property-CanWhisper","meta":{"readonly":true}},{"name":"ContactID","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-ContactID","meta":{"readonly":true}},{"name":"ContactNumbers","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-ContactNumbers","meta":{"readonly":true}},{"name":"ContactType","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-ContactType","meta":{"readonly":true}},{"name":"Data","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-Data","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"Intrinsics","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-Intrinsics","meta":{"readonly":true}},{"name":"IsMonitored","tagname":"property","owner":"MobileCCS.MonitoredInteraction","id":"property-IsMonitored","meta":{"readonly":true}},{"name":"IsMultimedia","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-IsMultimedia","meta":{"readonly":true}},{"name":"MainContactID","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-MainContactID","meta":{"readonly":true}},{"name":"MonitoredUser","tagname":"property","owner":"MobileCCS.MonitoredInteraction","id":"property-MonitoredUser","meta":{"readonly":true}},{"name":"OriginalDestination","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-OriginalDestination","meta":{"readonly":true}},{"name":"Skillset","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-Skillset","meta":{"readonly":true}},{"name":"State","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-State","meta":{"readonly":true}},{"name":"StateReason","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-StateReason","meta":{"readonly":true}},{"name":"SupervisorID","tagname":"property","owner":"MobileCCS.MonitoredInteraction","id":"property-SupervisorID","meta":{"readonly":true}},{"name":"UUI","tagname":"property","owner":"MobileCCS.BaseInteraction","id":"property-UUI","meta":{"readonly":true}},{"name":"BargeIn","tagname":"method","owner":"MobileCCS.MonitoredInteraction","id":"method-BargeIn","meta":{}},{"name":"GetIntrinsic","tagname":"method","owner":"MobileCCS.BaseInteraction","id":"method-GetIntrinsic","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"Observe","tagname":"method","owner":"MobileCCS.MonitoredInteraction","id":"method-Observe","meta":{}},{"name":"Whisper","tagname":"method","owner":"MobileCCS.MonitoredInteraction","id":"method-Whisper","meta":{}},{"name":"setDefaultPropertyValues","tagname":"method","owner":"MobileCCS.BaseInteraction","id":"method-setDefaultPropertyValues","meta":{"protected":true}},{"name":"updateDerivedProperties","tagname":"method","owner":"MobileCCS.BaseInteraction","id":"method-updateDerivedProperties","meta":{"protected":true}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.MonitoredInteraction","short_doc":"The MonitoredInteraction object represents an interaction for a supervised user in the Contact Center. ...","component":false,"superclasses":["CCSObject","MobileCCS.BaseInteraction"],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='docClass'>MobileCCS.BaseInteraction</a><div class='subclass '><strong>MobileCCS.MonitoredInteraction</strong></div></div></div></pre><div class='doc-contents'><p>The <em>MonitoredInteraction</em> object represents an interaction for a supervised user in the Contact Center.\n<em>MonitoredInteraction</em> objects share a subset of properties with the <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object\nbut provide only those properties and methods that are appropriate for monitoring the supervisor's monitored user interactions.\n<em>MonitoredInteraction</em> objects are obtained by the client application by calling\nthe <a href=\"#!/api/MobileCCS.MonitoredUser-method-MonitorInteractions\" rel=\"MobileCCS.MonitoredUser-method-MonitorInteractions\" class=\"docClass\">monitoredUser.MonitorInteractions</a> method.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-ActivityCode' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-ActivityCode' class='name expandable'>ActivityCode</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The activity code, if any, currently set on this interaction. ...</div><div class='long'><p>The activity code, if any, currently set on this interaction.</p>\n\n<p>The value of this property is a <em>Code</em> object containing the activity code currently set by the agent handling the contact.\nA <strong>null</strong> value indicates that no activity code is currently set.\nWhen not <strong>null</strong>, this property provides the activity code currently set by the agent handling the contact.\nActivity codes are set through the <a href=\"#!/api/MobileCCS.Interaction-method-SetActivityCode\" rel=\"MobileCCS.Interaction-method-SetActivityCode\" class=\"docClass\">Interaction.SetActivityCode</a> method and are\nused to categorize the type of work being performed by the agent handling the contact.</p>\n\n<p>The <em>Code</em> object returned by this property contains the following members:</p>\n\n<ul>\n<li><strong>Number</strong> - A string that is the actual code entered by the agent.</li>\n<li><strong>Name</strong> - A string that is the display name defined for this code.</li>\n</ul>\n\n</div></div></div><div id='property-Address' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-Address' class='name expandable'>Address</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The address associated with this interaction.</p>\n</div><div class='long'><p>The address associated with this interaction.</p>\n</div></div></div><div id='property-CalledAddress' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-CalledAddress' class='name expandable'>CalledAddress</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The first destination address associated with this contact (the first address that received an inbound connection).</p>\n</div><div class='long'><p>The first destination address associated with this contact (the first address that received an inbound connection).</p>\n</div></div></div><div id='property-CalledAddressName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-CalledAddressName' class='name expandable'>CalledAddressName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>This is the name (or URN) portion of the called address (see CalledAddress). ...</div><div class='long'><p>This is the name (or URN) portion of the called address (see <a href=\"#!/api/MobileCCS.BaseInteraction-property-CalledAddress\" rel=\"MobileCCS.BaseInteraction-property-CalledAddress\" class=\"docClass\">CalledAddress</a>).  For example if the <em>CalledAddress</em> is\n<strong>sip:8111674@domain.com</strong>, then the <em>CalledAddressName</em> would be <strong>8111674</strong>.</p>\n</div></div></div><div id='property-CallingAddress' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-CallingAddress' class='name expandable'>CallingAddress</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The address that was the original source of this contact.</p>\n</div><div class='long'><p>The address that was the original source of this contact.</p>\n</div></div></div><div id='property-CallingAddressName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-CallingAddressName' class='name expandable'>CallingAddressName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>This is the name (or URN) portion of the calling address (see CallingAddress). ...</div><div class='long'><p>This is the name (or URN) portion of the calling address (see <a href=\"#!/api/MobileCCS.BaseInteraction-property-CallingAddress\" rel=\"MobileCCS.BaseInteraction-property-CallingAddress\" class=\"docClass\">CallingAddress</a>).  For example if the <em>CallingAddress</em> is\n<strong>sip:8111674@domain.com</strong>, then the <em>CallingAddressName</em> would be <strong>8111674</strong>.</p>\n</div></div></div><div id='property-CanBargeIn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-property-CanBargeIn' class='name expandable'>CanBargeIn</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if a barge-in operation can be performed on the interaction calling the <a href=\"#!/api/MobileCCS.MonitoredInteraction-method-BargeIn\" rel=\"MobileCCS.MonitoredInteraction-method-BargeIn\" class=\"docClass\">BargeIn</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if a barge-in operation can be performed on the interaction calling the <a href=\"#!/api/MobileCCS.MonitoredInteraction-method-BargeIn\" rel=\"MobileCCS.MonitoredInteraction-method-BargeIn\" class=\"docClass\">BargeIn</a> method.</p>\n</div></div></div><div id='property-CanObserve' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-property-CanObserve' class='name expandable'>CanObserve</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the interaction can be observed by calling the <a href=\"#!/api/MobileCCS.MonitoredInteraction-method-Observe\" rel=\"MobileCCS.MonitoredInteraction-method-Observe\" class=\"docClass\">Observe</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the interaction can be observed by calling the <a href=\"#!/api/MobileCCS.MonitoredInteraction-method-Observe\" rel=\"MobileCCS.MonitoredInteraction-method-Observe\" class=\"docClass\">Observe</a> method.</p>\n</div></div></div><div id='property-CanWhisper' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-property-CanWhisper' class='name expandable'>CanWhisper</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if a whisper operation can be performed on the interaction calling the <a href=\"#!/api/MobileCCS.MonitoredInteraction-method-Whisper\" rel=\"MobileCCS.MonitoredInteraction-method-Whisper\" class=\"docClass\">Whisper</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if a whisper operation can be performed on the interaction calling the <a href=\"#!/api/MobileCCS.MonitoredInteraction-method-Whisper\" rel=\"MobileCCS.MonitoredInteraction-method-Whisper\" class=\"docClass\">Whisper</a> method.</p>\n</div></div></div><div id='property-ContactID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-ContactID' class='name expandable'>ContactID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The ID of the contact associated with this Interaction. ...</div><div class='long'><p>The ID of the contact associated with this Interaction.  The value of the <em>ContactID</em> property is a string\nthat identifies the contact within the context of the underlying service provider.</p>\n\n<p>The contents of the contact ID string depend on the underlying service provider, therefore\nthe application should not rely on the <em>ContactID</em> string being of a particular format.</p>\n</div></div></div><div id='property-ContactNumbers' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-ContactNumbers' class='name expandable'>ContactNumbers</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The contact numbers assigned to the POM contact used to dial out on a preview POM interaction. ...</div><div class='long'><p>The contact numbers assigned to the POM contact used to dial out on a preview POM interaction.</p>\n\n<p>Populated by the POM server per POM contact and displayed to the agent for selection to dial.\nA <strong>null</strong> value indicates that this is not a preview POM contact.\nThe object returned by this property containing one or more entries with the following members:</p>\n\n<ul>\n<li><strong>Name</strong> - A string that identifies the number.</li>\n<li><strong>Number</strong> - Number to dial for campaign.</li>\n<li><strong>Timezone</strong> - A date and time in timezone of contact.</li>\n<li><strong>IsDefault</strong> - A boolean that is the display name defined for this code.</li>\n</ul>\n\n</div></div></div><div id='property-ContactType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-ContactType' class='name expandable'>ContactType</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The contact type for this interaction. ...</div><div class='long'><p>The contact type for this interaction.</p>\n\n<p>This property allows the client to determine what contact type is being handled by this interaction.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">ContactTypes</a> class.</p>\n</div></div></div><div id='property-Data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-Data' class='name expandable'>Data</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Retrieves attached data associated with the contact. ...</div><div class='long'><p>Retrieves attached data associated with the contact.</p>\n\n<p>The value of the property is an object that represents the data attached to the contact.\nA value of <strong>null</strong> indicates that no attached data exists for the contact.</p>\n\n<p>The object returned will have one of three properties depending on the format of the attached data:</p>\n\n<ul>\n<li><strong>STR</strong> - The attached data is the string provided by this property.</li>\n<li><strong>KVP</strong> - The attached data is in key/value pair form and the object returned by the <em>KVP</em> property is essentially\n          a dictionary where the object's properties provide the key/value pairs.</li>\n<li><strong>BIN</strong> - The attached data is in binary form and the value of the <em>BIN</em> property is an array of byte values.</li>\n</ul>\n\n\n<p>For the key/value pair form of attached data, the value for a specific key can be retrieved using the following sample\nJavascript code:</p>\n\n<pre><code>var key = \"SomeKey\",\n    value = null;\nif (interaction.Data.KVP.hasOwnProperty(key)) {\n    value = interaction.Data.KVP[key];\n}\n</code></pre>\n\n<p>The data attached to the contact can be changed by calling the <a href=\"#!/api/MobileCCS.Interaction-method-SetData\" rel=\"MobileCCS.Interaction-method-SetData\" class=\"docClass\">Interaction.SetData</a> method.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-Intrinsics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-Intrinsics' class='name expandable'>Intrinsics</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The value of this property is a Javascript Object whose properties provide additional detail about the contact associ...</div><div class='long'><p>The value of this property is a Javascript Object whose properties provide additional detail about the contact associated with\nthe interaction object.</p>\n\n<p>Individual intrinsic values can be read from the <em>Intrinsics</em> property using standard Javascript as shown in the example below:</p>\n\n<pre><code>var name = \"Skillset\",\n    value = null;\nif (interaction.Intrinsics.hasOwnProperty(name)) {\n    value = interaction.Intrinsics[name];\n}\n</code></pre>\n\n<p>Alternatively, the client application can use the <a href=\"#!/api/MobileCCS.BaseInteraction-method-GetIntrinsic\" rel=\"MobileCCS.BaseInteraction-method-GetIntrinsic\" class=\"docClass\">GetIntrinsic</a> method to retrieve an intrinsic value.</p>\n\n<p>There are many factors that determine what set of intrinsics are available on a particular contact and these may change throughout the lifetime of the contact\nso the client application is encouranged to check if the intrinsic value read from the object is <strong>undefined</strong> before using it.</p>\n\n<p>Intrinsic values can be modified or removed by calling the <a href=\"#!/api/MobileCCS.Interaction-method-SetIntrinsic\" rel=\"MobileCCS.Interaction-method-SetIntrinsic\" class=\"docClass\">Interaction.SetIntrinsic</a>\nor <a href=\"#!/api/MobileCCS.Interaction-method-RemoveIntrinsic\" rel=\"MobileCCS.Interaction-method-RemoveIntrinsic\" class=\"docClass\">Interaction.RemoveIntrinsic</a> methods respectively.</p>\n</div></div></div><div id='property-IsMonitored' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-property-IsMonitored' class='name expandable'>IsMonitored</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the interaction is being monitored.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the interaction is being monitored.</p>\n</div></div></div><div id='property-IsMultimedia' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-IsMultimedia' class='name expandable'>IsMultimedia</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the interaction is associated with a multimedia contact.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the interaction is associated with a multimedia contact.</p>\n</div></div></div><div id='property-MainContactID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-MainContactID' class='name expandable'>MainContactID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>If the current contact is a consult contact, this property provides the ID of the main contact. ...</div><div class='long'><p>If the current contact is a consult contact, this property provides the ID of the main contact.</p>\n\n<p>The value of the property is <strong>null</strong> if the contact is not a consult contact.\nOtherwise, it provides the contact ID of the main contact that this consult contact is associated with.</p>\n\n<p>The contents of the contact ID string depends on the underlying service provider, therefore the application\nshould not rely on the <em>MainContactID</em> string being of a particular format.</p>\n</div></div></div><div id='property-MonitoredUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-property-MonitoredUser' class='name expandable'>MonitoredUser</a> : <a href=\"#!/api/MobileCCS.MonitoredUser\" rel=\"MobileCCS.MonitoredUser\" class=\"docClass\">MobileCCS.MonitoredUser</a><span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The MonitoredUser property provides access to the MonitoredUser object\nthat the MonitoredInteraction object is associ...</div><div class='long'><p>The <em>MonitoredUser</em> property provides access to the <a href=\"#!/api/MobileCCS.MonitoredUser\" rel=\"MobileCCS.MonitoredUser\" class=\"docClass\">MonitoredUser</a> object\nthat the <em>MonitoredInteraction</em> object is associated with.</p>\n</div></div></div><div id='property-OriginalDestination' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-OriginalDestination' class='name expandable'>OriginalDestination</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The original destination address used by the caller to reach the system, sometimes referred to\nas the DNIS (Dialed Nu...</div><div class='long'><p>The original destination address used by the caller to reach the system, sometimes referred to\nas the DNIS (Dialed Number Identification Service).</p>\n\n<p>The value of this property is a string containing the phone number dialed to reach the system.\nIf the dialed number cannot be determined by the service provider, then this property will be <strong>null</strong>.</p>\n\n<p>In most cases the original destination should be available as soon as the contact is created.\nHowever, in the rare situation where the value of the <em>OriginalDestination</em> property of\nthe contact is changed following creation, changes to this property will be provided in an <em>UPDATE</em>\nnotifications</p>\n</div></div></div><div id='property-Skillset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-Skillset' class='name expandable'>Skillset</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Returns the skillset that the contact has been routed to. ...</div><div class='long'><p>Returns the skillset that the contact has been routed to.  This property will be <strong>null</strong> if the contact is not a skillset contact (e.g. a personal call).</p>\n</div></div></div><div id='property-State' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-State' class='name expandable'>State</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The current state of the interaction. ...</div><div class='long'><p>The current state of the interaction.  This will be one of the following:</p>\n\n<ul>\n<li>\"Ringing\" - Indicates that the interaction is currently ringing at the address specified by the <a href=\"#!/api/MobileCCS.BaseInteraction-property-Address\" rel=\"MobileCCS.BaseInteraction-property-Address\" class=\"docClass\">Address</a> property.</li>\n<li>\"Active\" - Indicates that the interaction is an active part of the conversation with the other parties on the contact.\n           For a voice contact, this usually implies that there is speech path with the remote party or parties associated\n           with the interaction.</li>\n<li>\"Held\" -   Indicates that the interaction is currently on hold.</li>\n<li>\"Dropped\" - The interaction has been completed (dropped).\n            The client application should cease using this interaction object when in this state.  Note that this\n            state will be set in any <em>DELETE</em> notifications for <em>Interaction</em> objects.</li>\n<li>\"Dialing\" - Indicates that an InteractionI object with the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">POM_Outbound</a> contact type is in the dialing state</li>\n<li>\"Pending\" - Indicates that an <em>Interaction</em> object with <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">POM_Outbound</a> contact type is pending at the user.</li>\n<li>\"Preview\" - Indicates that an <em>Interaction</em> object with <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">POM_Outbound</a> contact type has been received from a preview campaign\n            and is currently being previewed by the user.</li>\n<li>\"Unknown\"</li>\n<li>\"Wrapup\"  - Indicates that an <em>Interaction</em> object with <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">POM_Outbound</a> contact type</li>\n</ul>\n\n\n<p>The <a href=\"#!/api/MobileCCS.BaseInteraction-property-StateReason\" rel=\"MobileCCS.BaseInteraction-property-StateReason\" class=\"docClass\">StateReason</a> property can be examined to get information as to the reason the interaction is in the current state.</p>\n</div></div></div><div id='property-StateReason' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-StateReason' class='name expandable'>StateReason</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The reason the interaction has transitioned to the current state. ...</div><div class='long'><p>The reason the interaction has transitioned to the current state.  This could be one of the following values:</p>\n\n<ul>\n<li><strong>null</strong> - The state change was the result of the default (or most normal) action on the object.</li>\n<li>\"BargeIn\" - The state change was the result of a \"barge-in\" operation.</li>\n<li>\"CallSupervisor\" - The state change was the result of the \"call supervisor\" feature being invoked.</li>\n<li>\"ConferenceComplete\" - The state change resulted from the completion of a conference operation\n                       (see <a href=\"#!/api/MobileCCS.Interaction-method-CompleteConference\" rel=\"MobileCCS.Interaction-method-CompleteConference\" class=\"docClass\">Interaction.CompleteConference</a>).</li>\n<li>\"ConferenceInitiated\" - The state change resulted from a conference operation being initiated\n                        (see <a href=\"#!/api/MobileCCS.Interaction-method-InitiateConference\" rel=\"MobileCCS.Interaction-method-InitiateConference\" class=\"docClass\">Interaction.InitiateConference</a>).</li>\n<li>\"ConsultComplete\" - The state change resulted from the completion of a transfer or conference operation involving\n                    a consultative contact created via a \"consult\" operation.</li>\n<li>\"ConsultInitiated\" - The state change resulted from a consult contact being created when there is not enough information\n                     available to determine whether the consult contact was created as part of a transfer or conference operation.</li>\n<li>\"Emergency\" - The state change was the result of the \"emergency\" feature being invoked.</li>\n<li>\"Observe\" - The state change was the result of an \"observe\" operation.</li>\n<li>\"Park\" - The state change was the result of the associated contact being \"parked\" at an address .</li>\n<li>\"Redirect\" - The state change was the result of the associated incoming contact being redirected to a new address.</li>\n<li>\"Reject\" - The state change was the result of the associated incoming contact being rejected.</li>\n<li>\"Route\" - The state change was the result of the associated incoming contact being routed.</li>\n<li>\"Shutdown\" - The state change was the result of the service provider being shut down.</li>\n<li>\"TransferComplete\" - The state change resulted from the completion of a transfer operation\n                     (see <a href=\"#!/api/MobileCCS.Interaction-method-CompleteTransfer\" rel=\"MobileCCS.Interaction-method-CompleteTransfer\" class=\"docClass\">Interaction.CompleteTransfer</a>).</li>\n<li>\"TransferInitiated\" - The state change resulted from a transfer operation being initiated\n                      (see <a href=\"#!/api/MobileCCS.Interaction-method-InitiateTransfer\" rel=\"MobileCCS.Interaction-method-InitiateTransfer\" class=\"docClass\">Interaction.InitiateTransfer</a>).</li>\n<li>\"Whisper\" - The state change was the result of a \"whisper\" operation.</li>\n<li>\"DefaultTreatment\" - The state change was the result of the default treatment being applied to the incoming Contact Center call.</li>\n<li>\"ForceDisconnect\" - Indicates that the state change was a result of the contact being disconnected via the Contact Center script.\n                    This reason code currently only applies to non-voice contacts.</li>\n<li>\"Pull\" - The state change was the result of an agent \"pulling\" a contact.</li>\n<li>\"DestinationBusy\" - The destination device or address is busy.</li>\n<li>\"ServerError\" - An error occurred within the switching platform.</li>\n<li>\"ServiceUnavailable\" - A service required to process a request is not available (e.g. the computer telephony integration (CTI) link is down).</li>\n<li>\"CallForwardImmediate\" - Call forwarding was in effect at the destination address.</li>\n<li>\"CallForwardNoAnswer\" - Call forwarding was triggered because the call wasn't answered.</li>\n<li>\"InvalidRequest\" - An invalid request was received (e.g. an invalid destination address was supplied).</li>\n<li>\"Join\" - The state change was the result of the joining of two contacts\n         (see <a href=\"#!/api/MobileCCS.Interaction-method-JoinConference\" rel=\"MobileCCS.Interaction-method-JoinConference\" class=\"docClass\">Interaction.JoinConference</a>).</li>\n</ul>\n\n</div></div></div><div id='property-SupervisorID' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-property-SupervisorID' class='name expandable'>SupervisorID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Provides the user ID of the user's supervisor.</p>\n</div><div class='long'><p>Provides the user ID of the user's supervisor.</p>\n</div></div></div><div id='property-UUI' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-property-UUI' class='name expandable'>UUI</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Retrieves the user-user info (UUI) associated with the interaction's contact. ...</div><div class='long'><p>Retrieves the user-user info (UUI) associated with the interaction's contact. UUI is call (contact) related data\nthat can be transferred with a call through ISDN or SIP signaling.</p>\n\n<p>The value of the property is a string that represents the UUI data associated with the contact.\nA value of <strong>null</strong> indicates that no UUI data exists for the contact.</p>\n\n<p>UUI data associated with the contact may be either string or binary data.  If it is binary, then the value of this\n<em>UUI</em> property will be the binary data that has been base-64 (radix-64) encoded.</p>\n\n<p>The UUI data associated with the contact can be changed by calling the <a href=\"#!/api/MobileCCS.Interaction-method-SetUUI\" rel=\"MobileCCS.Interaction-method-SetUUI\" class=\"docClass\">Interaction.SetUUI</a> method.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-BargeIn' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-method-BargeIn' class='name expandable'>BargeIn</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Elevates the observing Interaction on the contact associated with the MonitoredInteraction to a \"barge-in\" state, all...</div><div class='long'><p>Elevates the observing Interaction on the contact associated with the <em>MonitoredInteraction</em> to a \"barge-in\" state, allowing the supervisor\nto fully participate in the contact as if conferenced in on the user-customer contact.</p>\n\n<p>If this method is successful, the <a href=\"#!/api/MobileCCS.Interaction-property-ParticipationReason\" rel=\"MobileCCS.Interaction-property-ParticipationReason\" class=\"docClass\">ParticipationReason</a> property on the supervisor's\n<em>Interaction</em> object will be set to <strong>BargeIn</strong>, triggering an <em>UPDATE</em> notification on the callback method registered by the application\nwhen the <a href=\"#!/api/MobileCCS.Session-method-OpenInteractions\" rel=\"MobileCCS.Session-method-OpenInteractions\" class=\"docClass\">OpenInteractions</a> method was called.</p>\n\n<p>If a failure occurs an <em>ERROR</em> notification will be received on the callback method registered by the application when the\n<a href=\"#!/api/MobileCCS.MonitoredUser-method-MonitorInteractions\" rel=\"MobileCCS.MonitoredUser-method-MonitorInteractions\" class=\"docClass\">MonitorInteractions</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.MonitoredInteraction-property-CanBargeIn\" rel=\"MobileCCS.MonitoredInteraction-property-CanBargeIn\" class=\"docClass\">CanBargeIn</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidRequest\" rel=\"MobileCCS.ErrorCode-property-InvalidRequest\" class=\"docClass\">InvalidRequest</a></td>\n            <td>The interaction represents a non-skillset call, but the supervisor has not been granted the ability to barge-in on non-skillset calls.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-MissingContactType\" rel=\"MobileCCS.ErrorCode-property-MissingContactType\" class=\"docClass\">MissingContactType</a></td>\n            <td>The interaction is for a contact type (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> that the supervisor is not configured for.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-NoAgentPresent\" rel=\"MobileCCS.ErrorCode-property-NoAgentPresent\" class=\"docClass\">NoAgentPresent</a></td>\n            <td>The supervisor is not logged in to the Contact Center.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OperationNotSupported\" rel=\"MobileCCS.ErrorCode-property-OperationNotSupported\" class=\"docClass\">OperationNotSupported</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OutOfService\" rel=\"MobileCCS.ErrorCode-property-OutOfService\" class=\"docClass\">OutOfService</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-GetIntrinsic' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-method-GetIntrinsic' class='name expandable'>GetIntrinsic</a>( <span class='pre'>name</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>This is a helper method that can be used to query for a specified intrinsic value rather than using\nthe Intrinsics pr...</div><div class='long'><p>This is a helper method that can be used to query for a specified intrinsic value rather than using\nthe <a href=\"#!/api/MobileCCS.BaseInteraction-property-Intrinsics\" rel=\"MobileCCS.BaseInteraction-property-Intrinsics\" class=\"docClass\">Intrinsics</a> property directly.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : String<div class='sub-desc'><p>The name of the intrinsic to query for.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The value of the specified intrinsic or <strong>null</strong> if the intrinsic is not present.</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>name</strong> argument is anything but a non-empty string.</p>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-Observe' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-method-Observe' class='name expandable'>Observe</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates an observing Interaction to the contact associated with the MonitoredInteraction, allowing a supervisor to\nli...</div><div class='long'><p>Creates an observing Interaction to the contact associated with the <em>MonitoredInteraction</em>, allowing a supervisor to\nlisten to (or observe) the contact without being heard.</p>\n\n<p>If this method is successful, a new <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object will be created that has the same\ncontact ID as this <em>MonitoredInteraction</em>.  The <a href=\"#!/api/MobileCCS.Interaction-property-ParticipationReason\" rel=\"MobileCCS.Interaction-property-ParticipationReason\" class=\"docClass\">ParticipationReason</a> property\non the new <em>Interaction</em> object will be set to <strong>Observe</strong>.  The new <em>Interaction</em> object is received by the client application\nas a <em>NEW</em> notification on the callback method registered by the application when the\n<a href=\"#!/api/MobileCCS.Session-method-OpenInteractions\" rel=\"MobileCCS.Session-method-OpenInteractions\" class=\"docClass\">Session.OpenInteractions</a> method was called.</p>\n\n<p>If a failure occurs an <em>ERROR</em> notification will be received on the callback method registered by the application when\nthe <a href=\"#!/api/MobileCCS.MonitoredUser-method-MonitorInteractions\" rel=\"MobileCCS.MonitoredUser-method-MonitorInteractions\" class=\"docClass\">MonitoredUser.MonitorInteractions</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.MonitoredInteraction-property-CanObserve\" rel=\"MobileCCS.MonitoredInteraction-property-CanObserve\" class=\"docClass\">CanObserve</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DestinationStateInvalid\" rel=\"MobileCCS.ErrorCode-property-DestinationStateInvalid\" class=\"docClass\">DestinationStateInvalid</a></td>\n            <td>The interaction is not in a state that supports the ability to observe the call (e.g. **Ringing** state).</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidRequest\" rel=\"MobileCCS.ErrorCode-property-InvalidRequest\" class=\"docClass\">InvalidRequest</a></td>\n            <td>The interaction represents a non-skillset call, but the supervisor has not been granted the ability to observe non-skillset calls.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-MissingContactType\" rel=\"MobileCCS.ErrorCode-property-MissingContactType\" class=\"docClass\">MissingContactType</a></td>\n            <td>The interaction is for a contact type (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> that the supervisor is not configured for.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-NoAgentPresent\" rel=\"MobileCCS.ErrorCode-property-NoAgentPresent\" class=\"docClass\">NoAgentPresent</a></td>\n            <td>The supervisor is not logged in to the Contact Center.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OperationNotSupported\" rel=\"MobileCCS.ErrorCode-property-OperationNotSupported\" class=\"docClass\">OperationNotSupported</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OutOfService\" rel=\"MobileCCS.ErrorCode-property-OutOfService\" class=\"docClass\">OutOfService</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-Whisper' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.MonitoredInteraction'>MobileCCS.MonitoredInteraction</span><br/></div><a href='#!/api/MobileCCS.MonitoredInteraction-method-Whisper' class='name expandable'>Whisper</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates an Interaction in \"whisper\" mode to the contact associated with the MonitoredInteraction, allowing a supervis...</div><div class='long'><p>Creates an Interaction in \"whisper\" mode to the contact associated with the <em>MonitoredInteraction</em>, allowing a supervisor to\nlisten to all parties on the contact and speak to the supervised user without being heard by any other parties.  This allows the\nsupervisor to coach the supervised user.</p>\n\n<p>If this method is successful, a new <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object will be created that has the same\ncontact ID as this <em>MonitoredInteraction</em>.  The <a href=\"#!/api/MobileCCS.Interaction-property-ParticipationReason\" rel=\"MobileCCS.Interaction-property-ParticipationReason\" class=\"docClass\">ParticipationReason</a> property\non the new <em>Interaction</em> object will be set to <strong>Whisper</strong>.  The new <em>Interaction</em> object is received by the client application\nas a <em>NEW</em> notification on the callback method registered by the application when the\n<a href=\"#!/api/MobileCCS.Session-method-OpenInteractions\" rel=\"MobileCCS.Session-method-OpenInteractions\" class=\"docClass\">Session.OpenInteractions</a> method was called.</p>\n\n<p>If a failure occurs an <em>ERROR</em> notification will be received on the callback method registered by the application when\nthe <a href=\"#!/api/MobileCCS.MonitoredUser-method-MonitorInteractions\" rel=\"MobileCCS.MonitoredUser-method-MonitorInteractions\" class=\"docClass\">MonitoredUser.MonitorInteractions</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.MonitoredInteraction-property-CanWhisper\" rel=\"MobileCCS.MonitoredInteraction-property-CanWhisper\" class=\"docClass\">CanWhisper</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-MissingContactType\" rel=\"MobileCCS.ErrorCode-property-MissingContactType\" class=\"docClass\">MissingContactType</a></td>\n            <td>The interaction is for a contact type (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> that the supervisor is not configured for.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-NoAgentPresent\" rel=\"MobileCCS.ErrorCode-property-NoAgentPresent\" class=\"docClass\">NoAgentPresent</a></td>\n            <td>The supervisor is not logged in to the Contact Center.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OperationNotSupported\" rel=\"MobileCCS.ErrorCode-property-OperationNotSupported\" class=\"docClass\">OperationNotSupported</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OutOfService\" rel=\"MobileCCS.ErrorCode-property-OutOfService\" class=\"docClass\">OutOfService</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setDefaultPropertyValues' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-method-setDefaultPropertyValues' class='name expandable'>setDefaultPropertyValues</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Sets default property values prior to applying an update received from the server. ...</div><div class='long'><p>Sets default property values prior to applying an update received from the server.</p>\n</div></div></div><div id='method-updateDerivedProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseInteraction' rel='MobileCCS.BaseInteraction' class='defined-in docClass'>MobileCCS.BaseInteraction</a><br/></div><a href='#!/api/MobileCCS.BaseInteraction-method-updateDerivedProperties' class='name expandable'>updateDerivedProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates derived property values after applying an update received from the server. ...</div><div class='long'><p>Updates derived property values after applying an update received from the server.</p>\n</div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});