Ext.data.JsonP.MobileCCS_Session({"tagname":"class","name":"MobileCCS.Session","autodetected":{},"files":[{"filename":"ccs-session.js","href":null}],"extends":"CCSObject","members":[{"name":"ACWCodes","tagname":"property","owner":"MobileCCS.Session","id":"property-ACWCodes","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"LastLoginTime","tagname":"property","owner":"MobileCCS.Session","id":"property-LastLoginTime","meta":{"readonly":true}},{"name":"NRRCCodes","tagname":"property","owner":"MobileCCS.Session","id":"property-NRRCCodes","meta":{"readonly":true}},{"name":"NumUsers","tagname":"property","owner":"MobileCCS.Session","id":"property-NumUsers","meta":{"readonly":true}},{"name":"Timezones","tagname":"property","owner":"MobileCCS.Session","id":"property-Timezones","meta":{"readonly":true}},{"name":"Version","tagname":"property","owner":"MobileCCS.Session","id":"property-Version","meta":{"readonly":true}},{"name":"GetInteraction","tagname":"method","owner":"MobileCCS.Session","id":"method-GetInteraction","meta":{}},{"name":"GetResource","tagname":"method","owner":"MobileCCS.Session","id":"method-GetResource","meta":{}},{"name":"GetUser","tagname":"method","owner":"MobileCCS.Session","id":"method-GetUser","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"OpenInteractions","tagname":"method","owner":"MobileCCS.Session","id":"method-OpenInteractions","meta":{}},{"name":"OpenResources","tagname":"method","owner":"MobileCCS.Session","id":"method-OpenResources","meta":{}},{"name":"OpenUsers","tagname":"method","owner":"MobileCCS.Session","id":"method-OpenUsers","meta":{}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.Session","short_doc":"The Session class represents an active authenticated session to the server. ...","component":false,"superclasses":["CCSObject"],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><strong>MobileCCS.Session</strong></div></div></pre><div class='doc-contents'><p>The <em>Session</em> class represents an active authenticated session to the server.</p>\n\n<p>A client application receives an instance of this class when it successfully signs in to the\nserver through the callback function passed to the <a href=\"#!/api/MobileCCS.Client-method-SignIn\" rel=\"MobileCCS.Client-method-SignIn\" class=\"docClass\">SignIn</a>\nmethod of the <a href=\"#!/api/MobileCCS.Client\" rel=\"MobileCCS.Client\" class=\"docClass\">Client</a> object it created.</p>\n\n<p>Once the client application has obtained the <em>Session</em> object, it can then proceed to request\naccess to the <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a>, <a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">Resource</a> and\n<a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> objects available to it by calling the appropriate\nmethod(s) on the <em>Session</em> object.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-ACWCodes' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-property-ACWCodes' class='name expandable'>ACWCodes</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The after call work codes and their names associated with the session. ...</div><div class='long'><p>The after call work codes and their names associated with the session.</p>\n\n<p> <strong>CodeType</strong> - A string that indicates the type of codes in the list (in this case it will be \"ACW\").\n <strong>Codes</strong> - A Javascript Object whose properties provide the ACW code numbers and associated display names.</p>\n\n<p>The list of ACW code number/name pairs can be read from the <em>Codes</em> object using standard Javascript as shown in the example below:</p>\n\n<pre><code>var num, // The ACW code number\n    name; // The display name for the ACW code\nfor (num in list.Codes) {\n    if (list.Codes.hasOwnProperty(num)) {\n        name = list.Codes[num];\n        // Do something with \"num\" and/or \"name\" ...\n    }\n}\n</code></pre>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-LastLoginTime' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-property-LastLoginTime' class='name expandable'>LastLoginTime</a> : Date<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The server time of the last successful login for the currently connected user. ...</div><div class='long'><p>The server time of the last successful login for the currently connected user.</p>\n\n<p>The value of the property is a Javascript <em>Date</em> object that provides the Universal Coordinated Time (UTC) server time\nof the previous successful login by the same user or <strong>null</strong> if the user has never previously connected.</p>\n</div></div></div><div id='property-NRRCCodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-property-NRRCCodes' class='name expandable'>NRRCCodes</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The not ready reason codes and their names associated with the session. ...</div><div class='long'><p>The not ready reason codes and their names associated with the session.</p>\n\n<p> <strong>CodeType</strong> - A string that indicates the type of codes in the list (in this case it will be \"NRRC\").\n <strong>Codes</strong> - A Javascript Object whose properties provide the NRRC code numbers and associated display names.</p>\n\n<p>The list of NRRC code number/name pairs can be read from the <em>Codes</em> object using standard Javascript as shown in the example below:</p>\n\n<pre><code>var num, // The NRRC code number\n    name; // The display name for the NRRC code\nfor (num in list.Codes) {\n    if (list.Codes.hasOwnProperty(num)) {\n        name = list.Codes[num];\n        // Do something with \"num\" and/or \"name\" ...\n    }\n}\n</code></pre>\n</div></div></div><div id='property-NumUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-property-NumUsers' class='name expandable'>NumUsers</a> : Number<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The number of users (see <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a>) associated with the session.</p>\n</div><div class='long'><p>The number of users (see <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a>) associated with the session.</p>\n</div></div></div><div id='property-Timezones' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-property-Timezones' class='name expandable'>Timezones</a> : Object[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Array of zones and the hour difference associated with the session.</p>\n</div><div class='long'><p>Array of zones and the hour difference associated with the session.</p>\n</div></div></div><div id='property-Version' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-property-Version' class='name expandable'>Version</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The version of the server.</p>\n</div><div class='long'><p>The version of the server.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-GetInteraction' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-method-GetInteraction' class='name expandable'>GetInteraction</a>( <span class='pre'>interactionid</span> ) : <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">MobileCCS.Interaction</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Finds an Interaction object given the object's ID. ...</div><div class='long'><p>Finds an <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object given the object's ID.</p>\n\n<p>Note that the <a href=\"#!/api/MobileCCS.Session-method-OpenInteractions\" rel=\"MobileCCS.Session-method-OpenInteractions\" class=\"docClass\">OpenInteractions</a> method must be called to download the <em>Interaction</em> objects from the server before this method can be used.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>interactionid</span> : String<div class='sub-desc'><p>The ID of the <em>Interaction</em> object to find.  This is the value of the <a href=\"#!/api/MobileCCS.Interaction-property-ID\" rel=\"MobileCCS.Interaction-property-ID\" class=\"docClass\">MobileCCS.Interaction.ID</a> field of the <em>Interaction</em> object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">MobileCCS.Interaction</a></span><div class='sub-desc'><p>The return value will be an <em>Interaction</em> object if the object was found or <strong>null</strong> if the ID specified does not identify an <em>Interaction</em>\n                  object associated with the session.</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>interactionid</strong> argument is anything but a non-empty string.</p>\n</div></li></ul></div></div></div><div id='method-GetResource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-method-GetResource' class='name expandable'>GetResource</a>( <span class='pre'>resourceid</span> ) : <a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">MobileCCS.Resource</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Finds a Resource object given the object's ID. ...</div><div class='long'><p>Finds a <a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">Resource</a> object given the object's ID.</p>\n\n<p>Note that the <a href=\"#!/api/MobileCCS.Session-method-OpenResources\" rel=\"MobileCCS.Session-method-OpenResources\" class=\"docClass\">OpenResources</a> method must be called to download the <em>Resource</em> objects from the server before this method can be used.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>resourceid</span> : String<div class='sub-desc'><p>The ID of the <em>Resource</em> object to find.  This is the value of the <a href=\"#!/api/MobileCCS.Resource-property-ID\" rel=\"MobileCCS.Resource-property-ID\" class=\"docClass\">MobileCCS.Resource.ID</a> field of the <em>Resource</em> object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">MobileCCS.Resource</a></span><div class='sub-desc'><p>The return value will be a <em>Resource</em> object if the object was found or <strong>null</strong> if the ID specified does not identify a <em>Resource</em>\n                  object associated with the session.</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>resourceid</strong> argument is anything but a non-empty string.</p>\n</div></li></ul></div></div></div><div id='method-GetUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-method-GetUser' class='name expandable'>GetUser</a>( <span class='pre'>userid</span> ) : <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">MobileCCS.User</a><span class=\"signature\"></span></div><div class='description'><div class='short'>Finds a User object given the object's ID. ...</div><div class='long'><p>Finds a <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a> object given the object's ID.</p>\n\n<p>Note that the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method must be called to download the <em>User</em> objects from the server before this method can be used.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>userid</span> : String<div class='sub-desc'><p>The ID of the <em>User</em> object to find.  This is the value of the <a href=\"#!/api/MobileCCS.User-property-ID\" rel=\"MobileCCS.User-property-ID\" class=\"docClass\">MobileCCS.User.ID</a> field of the <em>User</em> object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">MobileCCS.User</a></span><div class='sub-desc'><p>The return value will be a <em>User</em> object if the object was found or <strong>null</strong> if the ID specified does not identify a <em>User</em>\n                  object associated with the session.</p>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>userid</strong> argument is anything but a non-empty string.</p>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-OpenInteractions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-method-OpenInteractions' class='name expandable'>OpenInteractions</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens the path with the server to start the flow of events for all the interactions associated with the session. ...</div><div class='long'><p>Opens the path with the server to start the flow of events for all the interactions associated with the session.\nThe initial <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> objects and subsequent updates to these objects are received by the\napplication through a callback function argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which will be one of\nthe values defined in <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>.  The second argument will be a <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a>\nobject for the <em>NEW</em>, <em>UPDATE</em> and <em>DELETE</em> notification types and an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>NEW</em> notification indicates that a new <em>Interaction</em> object is being delivered to the application.  Immediately following the\ninvocation of this method, a <em>NEW</em> notification will be received for each <em>Interaction</em> object active in the session.\nAn <em>UPDATE</em> notification indicates that some property or properties of the interaction identifed by the supplied\n<em>notifyObject</em> has changed and the newly supplied <em>Interaction</em> object represents a complete update of the <em>Interaction</em> object.\nA <em>DELETE</em> notification indicates that the identified interaction has been deleted and the client application should discontinue\nthe use of the identified object.</p>\n\n<p><em>ERROR</em> notifications received on this callback function indicate the failure of some method call made by the client application\non one of the previously received <em>Interaction</em> objects. The accompanying <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details\nas to the source and cause of the error.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when interaction-level events occur.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>handler</strong> argument is incorrect.</p>\n</div></li></ul></div></div></div><div id='method-OpenResources' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-method-OpenResources' class='name expandable'>OpenResources</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens the path with the server to start the flow of events for all resources associated with the Session. ...</div><div class='long'><p>Opens the path with the server to start the flow of events for all resources associated with the Session.\nresources.  The initial <a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">Resource</a> objects and subsequent updates to these objects are received by the\napplication through a callback function argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which will be one of\nthe values defined in <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>.  The second argument will be a <a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">Resource</a>\nobject for the <em>NEW</em>, <em>UPDATE</em> and <em>DELETE</em> notification types and an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>NEW</em> notification indicates that a new <em>Resource</em> object is being delivered to the application.  Immediately following the\ninvocation of this method, a <em>NEW</em> notification will be received for each <em>Resource</em> object in the session.\nAn <em>UPDATE</em> notification indicates that some property or properties of the resource identifed by the supplied\n<em>notifyObject</em> has changed and the newly supplied <em>Resource</em> object represents a complete update of the <em>Resource</em> object.\nA <em>DELETE</em> notification indicates that the identified resource has been deleted and the client application should discontinue\nthe use of the identified object.</p>\n\n<p><em>ERROR</em> notifications received on this callback function indicate the failure of some method call made by the client application\non one of the previously received <em>Resource</em> objects. The accompanying <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details\nas to the source and cause of the error.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when resource-level events occur.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">Resource</a>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>handler</strong> argument is incorrect.</p>\n</div></li></ul></div></div></div><div id='method-OpenUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.Session'>MobileCCS.Session</span><br/></div><a href='#!/api/MobileCCS.Session-method-OpenUsers' class='name expandable'>OpenUsers</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Opens the path with the server to start the flow of events for all users associated with the Session. ...</div><div class='long'><p>Opens the path with the server to start the flow of events for all users associated with the Session.\nusers.  The initial <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a> objects and subsequent updates to these objects are received by the\napplication through a callback function argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which will be one of\nthe values defined in <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>.  The second argument will be a <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a>\nobject for the <em>NEW</em>, <em>UPDATE</em> and <em>DELETE</em> notification types and an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>NEW</em> notification indicates that a new <em>User</em> object is being delivered to the application.  Immediately following the\ninvocation of this method, a <em>NEW</em> notification will be received for each <em>User</em> object in the session.\nAn <em>UPDATE</em> notification indicates that some property or properties of the user identifed by the supplied\n<em>notifyObject</em> has changed and the newly supplied <em>User</em> object represents a complete update of the <em>User</em> object.\nA <em>DELETE</em> notification indicates that the identified user has been deleted and the client application should discontinue\nthe use of the identified object.</p>\n\n<p><em>ERROR</em> notifications received on this callback function indicate the failure of some method call made by the client application\non one of the previously received <em>User</em> objects. The accompanying <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details\nas to the source and cause of the error.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when user-level events occur.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <a href=\"#!/api/MobileCCS.User\" rel=\"MobileCCS.User\" class=\"docClass\">User</a>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>handler</strong> argument is incorrect.</p>\n</div></li></ul></div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});