 /* jshint -W097 */
 "use strict";
 angular.module('refClientJS.main', ['ui.router', 'LocalStorageModule', 'ngSanitize',
                        'refClientJS.session', 'refClientJS.signedin',
                        'refClientJS.user', 'refClientJS.resources',
                    'refClientJS.interactions', 'refClientJS.attachments', 'refClientJS.emailMedia', 'refClientJS.webchatMedia', 'ui.bootstrap', 'refClientJS.alerts', 'refClientJS.supervisor', 'ui.grid',
                    'refClientJS.customerHistory', 'refClientJS.customerDetails', 'refClientJS.customerName'])

 //the index.html file has within it a UI-view tag which marks where the html within the templates listed below will be placed on the page 
 //$stateProvider is defined by the UI.router module
 //The json object below defines the states signin and signedin with their associated templates which are swapped into the page as these states change 
 
 .config(["$stateProvider", function ($stateProvider) {
     //need to call the state function to define our state
     $stateProvider.state('signin', {
             url: '/signin',
             views: {
                 'main': {
                     templateUrl: 'signin/signin.tpl.html',
                     controller: 'MainCtrl'
                 }
             },
             data: {
                 pageTitle: "Sign in"
             }
         })
         .state('signedin', {
             url: '/signedin',
             views: {
                 'main': {
                     templateUrl: 'signedin/signedin.tpl.html',
                     controller: 'SignedinCtrl'
                 }
             },
             data: {
                 pageTitle: "Welcome to the Contact Center"
             }
         });

 }])


 //Entry point to the Contact center, collect the  windows domain username and password and provde a button to sign into the contact center and create a session

 .controller("MainCtrl", ["$scope", "sessionService", "clientData", "$state", "alertsData", "alertsService", "localStorageService", function ($scope, sessionService, clientData, $state, alertsData, alertsService, localStorageService) {

         window.onbeforeunload = function (e) {
             return "Your session with the contact center will end and you will need to sign back in";
         };
         $scope.signingin = false;
     
         // temporary set values of server scope var to the local storage value
         $scope.server = localStorageService.get('server');
         $scope.username = localStorageService.get('username');
         $scope.password = localStorageService.get('password');

         window.SigninScope = $scope;
         
         $scope.alerts = alertsData.alerts;

         //function called when the user clicks submit on sign in form because ng-submit set to execute function signin()
         $scope.signin = function () {
             $scope.signingin = true;
             
             // temporary store latest server and username in browser cache
             localStorageService.set('server', $scope.server);
             localStorageService.set('username', $scope.username);
             localStorageService.set('password', $scope.password);
             
             //sessionService will manage the session of the user             
             sessionService.signIn($scope.server, $scope.username, $scope.password);


         };
        
        $scope.alertsChangeCB = function (newValue, oldValue) {
           
            $scope.alerts = newValue;

        };
        $scope.$watchCollection(function () {
                return alertsData.alerts;
            },
            $scope.alertsChangeCB,
            true);
         $scope.isSignedIn = function (returnedData) {
             //change the view to that of a signed in agent presenting the log in button
             console.log('JSDemoClient: MainCtrl: isSignedIn: ' + clientData.client.IsConnected);
             if (clientData.client.IsConnected) {
                 return true;
             }
             return false;

         };

         $scope.ClientCB = function (newValue, oldValue) {
            if(newValue)
            {
                $scope.signingin = false;
            }
            else
            {
                $scope.signingin = true;
            }
        };

        $scope.clearAlerts = function () {
            alertsService.clearAlerts();
        };

        $scope.closeAlert = function (index) {
            alertsService.closeAlert(index);
        };

         $scope.$watchCollection(function () {
                return clientData.client;
            },
            $scope.ClientCB,
            true);


     }]);