Ext.data.JsonP.MobileCCS_User({"tagname":"class","name":"MobileCCS.User","autodetected":{},"files":[{"filename":"ccs-user.js","href":null}],"extends":"MobileCCS.BaseUser","members":[{"name":"CanAfterCallWork","tagname":"property","owner":"MobileCCS.User","id":"property-CanAfterCallWork","meta":{"readonly":true}},{"name":"CanLogin","tagname":"property","owner":"MobileCCS.User","id":"property-CanLogin","meta":{"readonly":true}},{"name":"CanLoginOffsite","tagname":"property","owner":"MobileCCS.User","id":"property-CanLoginOffsite","meta":{"readonly":true}},{"name":"CanLogout","tagname":"property","owner":"MobileCCS.User","id":"property-CanLogout","meta":{"readonly":true}},{"name":"CanMonitorUsers","tagname":"property","owner":"MobileCCS.User","id":"property-CanMonitorUsers","meta":{"readonly":true}},{"name":"CanNotReady","tagname":"property","owner":"MobileCCS.User","id":"property-CanNotReady","meta":{"readonly":true}},{"name":"CanOriginateEmail","tagname":"property","owner":"MobileCCS.User","id":"property-CanOriginateEmail","meta":{"readonly":true}},{"name":"CanReady","tagname":"property","owner":"MobileCCS.User","id":"property-CanReady","meta":{"readonly":true}},{"name":"CanRecoverOffsite","tagname":"property","owner":"MobileCCS.User","id":"property-CanRecoverOffsite","meta":{"readonly":true}},{"name":"CanSetLanguage","tagname":"property","owner":"MobileCCS.User","id":"property-CanSetLanguage","meta":{"readonly":true}},{"name":"Code","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-Code","meta":{"readonly":true}},{"name":"ContactTypes","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-ContactTypes","meta":{"readonly":true}},{"name":"FirstName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-FirstName","meta":{"readonly":true}},{"name":"FullName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-FullName","meta":{"readonly":true}},{"name":"ID","tagname":"property","owner":"CCSObject","id":"property-ID","meta":{"readonly":true}},{"name":"IsMultimedia","tagname":"property","owner":"MobileCCS.User","id":"property-IsMultimedia","meta":{"readonly":true}},{"name":"IsPomNailedUp","tagname":"property","owner":"MobileCCS.User","id":"property-IsPomNailedUp","meta":{"readonly":true}},{"name":"LastName","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-LastName","meta":{"readonly":true}},{"name":"LoginID","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-LoginID","meta":{"readonly":true}},{"name":"Notification","tagname":"property","owner":"MobileCCS.User","id":"property-Notification","meta":{"readonly":true}},{"name":"OffsiteStatus","tagname":"property","owner":"MobileCCS.User","id":"property-OffsiteStatus","meta":{"readonly":true}},{"name":"PomZones","tagname":"property","owner":"MobileCCS.User","id":"property-PomZones","meta":{"readonly":true}},{"name":"Roles","tagname":"property","owner":"MobileCCS.User","id":"property-Roles","meta":{"readonly":true}},{"name":"Session","tagname":"property","owner":"MobileCCS.User","id":"property-Session","meta":{"readonly":true}},{"name":"State","tagname":"property","owner":"MobileCCS.BaseUser","id":"property-State","meta":{"readonly":true}},{"name":"SupervisorName","tagname":"property","owner":"MobileCCS.User","id":"property-SupervisorName","meta":{"readonly":true}},{"name":"UserSyncMessage","tagname":"property","owner":"MobileCCS.User","id":"property-UserSyncMessage","meta":{"readonly":true}},{"name":"UserSyncStatus","tagname":"property","owner":"MobileCCS.User","id":"property-UserSyncStatus","meta":{"readonly":true}},{"name":"VoiceResource","tagname":"property","owner":"MobileCCS.User","id":"property-VoiceResource","meta":{"readonly":true}},{"name":"AfterCallWork","tagname":"method","owner":"MobileCCS.User","id":"method-AfterCallWork","meta":{}},{"name":"ClearNotification","tagname":"method","owner":"MobileCCS.User","id":"method-ClearNotification","meta":{}},{"name":"GetAfterCallWorkCodes","tagname":"method","owner":"MobileCCS.User","id":"method-GetAfterCallWorkCodes","meta":{}},{"name":"GetNotReadyReasonCodes","tagname":"method","owner":"MobileCCS.User","id":"method-GetNotReadyReasonCodes","meta":{}},{"name":"GetOffsiteSettings","tagname":"method","owner":"MobileCCS.User","id":"method-GetOffsiteSettings","meta":{}},{"name":"HasContactType","tagname":"method","owner":"CCSObject","id":"method-HasContactType","meta":{}},{"name":"IsFunctionAvailable","tagname":"method","owner":"CCSObject","id":"method-IsFunctionAvailable","meta":{"protected":true}},{"name":"Login","tagname":"method","owner":"MobileCCS.User","id":"method-Login","meta":{}},{"name":"LoginOffsite","tagname":"method","owner":"MobileCCS.User","id":"method-LoginOffsite","meta":{}},{"name":"Logout","tagname":"method","owner":"MobileCCS.User","id":"method-Logout","meta":{}},{"name":"MonitorUsers","tagname":"method","owner":"MobileCCS.User","id":"method-MonitorUsers","meta":{}},{"name":"NotReady","tagname":"method","owner":"MobileCCS.User","id":"method-NotReady","meta":{}},{"name":"OriginateEmail","tagname":"method","owner":"MobileCCS.User","id":"method-OriginateEmail","meta":{}},{"name":"Ready","tagname":"method","owner":"MobileCCS.User","id":"method-Ready","meta":{}},{"name":"RecoverOffsite","tagname":"method","owner":"MobileCCS.User","id":"method-RecoverOffsite","meta":{}},{"name":"Retrieve","tagname":"method","owner":"MobileCCS.User","id":"method-Retrieve","meta":{}},{"name":"SetLanguage","tagname":"method","owner":"MobileCCS.User","id":"method-SetLanguage","meta":{}},{"name":"UnmonitorUsers","tagname":"method","owner":"MobileCCS.User","id":"method-UnmonitorUsers","meta":{}},{"name":"updateDerivedProperties","tagname":"method","owner":"MobileCCS.BaseUser","id":"method-updateDerivedProperties","meta":{"protected":true}},{"name":"updateProperties","tagname":"method","owner":"CCSObject","id":"method-updateProperties","meta":{"protected":true}},{"name":"uriToName","tagname":"method","owner":"CCSObject","id":"method-uriToName","meta":{"protected":true}}],"alternateClassNames":[],"aliases":{},"id":"class-MobileCCS.User","short_doc":"The User object represents a user in the Contact Center. ...","component":false,"superclasses":["CCSObject","MobileCCS.BaseUser"],"subclasses":[],"mixedInto":[],"mixins":[],"parentMixins":[],"requires":[],"uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/CCSObject' rel='CCSObject' class='docClass'>CCSObject</a><div class='subclass '><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='docClass'>MobileCCS.BaseUser</a><div class='subclass '><strong>MobileCCS.User</strong></div></div></div></pre><div class='doc-contents'><p>The <em>User</em> object represents a user in the Contact Center. A user is either an Agent, a supervisor, or both.\nOnce retrieved from the server, <em>User</em> objects provide the client application with all information pertinent\nto the user and provide full control.</p>\n\n<p>If the <em>User</em> object represents a user with a supervisor role within the Contact Center, the client application\nmay obtain access to the Users that the supervisor is responsible for, each of which is represented by\na <a href=\"#!/api/MobileCCS.MonitoredUser\" rel=\"MobileCCS.MonitoredUser\" class=\"docClass\">MonitoredUser</a> object.  <em>MonitoredUser</em> objects have many properties in common with <em>User</em> objects,\nbut provide a smaller set of functions that are limited those functions that a supervisor would use to manage\nhis or her Users.  Similarly, each User's current set of interactions (contacts currently being handled by\nthe User) can be obtained and are represented by\n<a href=\"#!/api/MobileCCS.MonitoredInteraction\" rel=\"MobileCCS.MonitoredInteraction\" class=\"docClass\">MonitoredInteraction</a> objects.</p>\n\n<p><em>User</em> objects are retrieved from the server by calling the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a>\nmethod on the <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object.  <em>MonitoredUser</em> objects are retrieved by calling the\n<a href=\"#!/api/MobileCCS.User-method-MonitorUsers\" rel=\"MobileCCS.User-method-MonitorUsers\" class=\"docClass\">MonitorUsers</a> method on the <em>User</em> object.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-CanAfterCallWork' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanAfterCallWork' class='name expandable'>CanAfterCallWork</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Returns true if the user is logged in to the Contact Center and is either currently handling a\nContact Center contact...</div><div class='long'><p>Returns <strong>true</strong> if the user is logged in to the Contact Center and is either currently handling a\nContact Center contact or has just completed one.  In these circumstances the user can be put into\nan After Call Work (ACW) state by calling the <a href=\"#!/api/MobileCCS.User-method-AfterCallWork\" rel=\"MobileCCS.User-method-AfterCallWork\" class=\"docClass\">AfterCallWork</a> method.</p>\n</div></div></div><div id='property-CanLogin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanLogin' class='name expandable'>CanLogin</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user can be logged in to the Contact Center by calling the <a href=\"#!/api/MobileCCS.User-method-Login\" rel=\"MobileCCS.User-method-Login\" class=\"docClass\">Login</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user can be logged in to the Contact Center by calling the <a href=\"#!/api/MobileCCS.User-method-Login\" rel=\"MobileCCS.User-method-Login\" class=\"docClass\">Login</a> method.</p>\n</div></div></div><div id='property-CanLoginOffsite' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanLoginOffsite' class='name expandable'>CanLoginOffsite</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user can be logged in to the Contact Center in offsite user mode by calling\nthe <a href=\"#!/api/MobileCCS.User-method-LoginOffsite\" rel=\"MobileCCS.User-method-LoginOffsite\" class=\"docClass\">LoginOffsite</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user can be logged in to the Contact Center in offsite user mode by calling\nthe <a href=\"#!/api/MobileCCS.User-method-LoginOffsite\" rel=\"MobileCCS.User-method-LoginOffsite\" class=\"docClass\">LoginOffsite</a> method.</p>\n</div></div></div><div id='property-CanLogout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanLogout' class='name expandable'>CanLogout</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user can be logged out of the Contact Center by calling the <a href=\"#!/api/MobileCCS.User-method-Logout\" rel=\"MobileCCS.User-method-Logout\" class=\"docClass\">Logout</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user can be logged out of the Contact Center by calling the <a href=\"#!/api/MobileCCS.User-method-Logout\" rel=\"MobileCCS.User-method-Logout\" class=\"docClass\">Logout</a> method.</p>\n</div></div></div><div id='property-CanMonitorUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanMonitorUsers' class='name expandable'>CanMonitorUsers</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Returns true if the user has a supervisor role and can request to monitor other users using the method MonitorUsers m...</div><div class='long'><p>Returns <strong>true</strong> if the user has a supervisor role and can request to monitor other users using the method <a href=\"#!/api/MobileCCS.User-method-MonitorUsers\" rel=\"MobileCCS.User-method-MonitorUsers\" class=\"docClass\">MonitorUsers</a> method.</p>\n</div></div></div><div id='property-CanNotReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanNotReady' class='name expandable'>CanNotReady</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Returns true if the user is logged in to the Contact Center and can be set to a Not Ready state\nby calling the NotRea...</div><div class='long'><p>Returns <strong>true</strong> if the user is logged in to the Contact Center and can be set to a Not Ready state\nby calling the <a href=\"#!/api/MobileCCS.User-method-NotReady\" rel=\"MobileCCS.User-method-NotReady\" class=\"docClass\">NotReady</a> method.</p>\n\n<p>This property will also be <strong>true</strong> if the user is already in the Not Ready state as it then indicates\nthat the Not Ready Reason code currently set by the user can be changed.</p>\n</div></div></div><div id='property-CanOriginateEmail' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanOriginateEmail' class='name expandable'>CanOriginateEmail</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user can initiate an outgoing email using the <a href=\"#!/api/MobileCCS.User-method-OriginateEmail\" rel=\"MobileCCS.User-method-OriginateEmail\" class=\"docClass\">OriginateEmail</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user can initiate an outgoing email using the <a href=\"#!/api/MobileCCS.User-method-OriginateEmail\" rel=\"MobileCCS.User-method-OriginateEmail\" class=\"docClass\">OriginateEmail</a> method.</p>\n</div></div></div><div id='property-CanReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanReady' class='name expandable'>CanReady</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user is logged in to the Contact Center and can be set to a Ready state\nby calling the <a href=\"#!/api/MobileCCS.User-method-Ready\" rel=\"MobileCCS.User-method-Ready\" class=\"docClass\">Ready</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user is logged in to the Contact Center and can be set to a Ready state\nby calling the <a href=\"#!/api/MobileCCS.User-method-Ready\" rel=\"MobileCCS.User-method-Ready\" class=\"docClass\">Ready</a> method.</p>\n</div></div></div><div id='property-CanRecoverOffsite' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanRecoverOffsite' class='name expandable'>CanRecoverOffsite</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Returns true if the user is currently in offsite mode and the client application can attempt\nrecovery of the offsite ...</div><div class='long'><p>Returns <strong>true</strong> if the user is currently in offsite mode and the client application can attempt\nrecovery of the offsite call by calling the <a href=\"#!/api/MobileCCS.User-method-RecoverOffsite\" rel=\"MobileCCS.User-method-RecoverOffsite\" class=\"docClass\">RecoverOffsite</a> method.</p>\n</div></div></div><div id='property-CanSetLanguage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-CanSetLanguage' class='name expandable'>CanSetLanguage</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the user language can be set using the <a href=\"#!/api/MobileCCS.User-method-SetLanguage\" rel=\"MobileCCS.User-method-SetLanguage\" class=\"docClass\">SetLanguage</a> method.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the user language can be set using the <a href=\"#!/api/MobileCCS.User-method-SetLanguage\" rel=\"MobileCCS.User-method-SetLanguage\" class=\"docClass\">SetLanguage</a> method.</p>\n</div></div></div><div id='property-Code' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-Code' class='name expandable'>Code</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>When not null, this property provides the Contact Center code currently associated with the agent. ...</div><div class='long'><p>When not <strong>null</strong>, this property provides the Contact Center code currently associated with the agent.</p>\n\n<p>This will be either a Not Ready Reason or After Call Work code depending upon the current state of the agent.\nThese Contact Center codes are used to provide a finer-grained accounting of how the agent's time was spent\nthroughout the day.</p>\n\n<p>The <em>Code</em> object returned by this property contains the following members:</p>\n\n<ul>\n<li><strong>Number</strong> - A string that is the actual code entered by the agent.</li>\n<li><strong>Name</strong> - A string that is the display name defined for this code.</li>\n</ul>\n\n</div></div></div><div id='property-ContactTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-ContactTypes' class='name expandable'>ContactTypes</a> : String[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A list of contact types that can be handled by this user. ...</div><div class='long'><p>A list of contact types that can be handled by this user.</p>\n\n<p>This property allows the client to determine what contact types the agent is capable of handling.</p>\n\n<p>Contact types are defined by the <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a> class.</p>\n</div></div></div><div id='property-FirstName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-FirstName' class='name expandable'>FirstName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The first (given) name of the user.</p>\n</div><div class='long'><p>The first (given) name of the user.</p>\n</div></div></div><div id='property-FullName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-FullName' class='name expandable'>FullName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The full name of the user, combining both first and last name. ...</div><div class='long'><p>The full name of the user, combining both first and last name.  The full name of the user is formed\nfrom the first and last names as \"FirstName LastName\". That is, the full name is a string which includes\nthe first and last names separated by a single space.</p>\n</div></div></div><div id='property-ID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-property-ID' class='name expandable'>ID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A unique identifier for the object. ...</div><div class='long'><p>A unique identifier for the object.</p>\n\n<p>ID values are only guaranteed to be unique among objects of the same type. Client applications should\nnot rely on the value of the <em>ID</em> property for anything other than uniquely identifying an instance of\na particular object type, as the actual value of the <em>ID</em> property may be changed in future releases.</p>\n</div></div></div><div id='property-IsMultimedia' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-IsMultimedia' class='name expandable'>IsMultimedia</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Indicates that the Contact Center user handles at least one multimedia contact type.</p>\n</div><div class='long'><p>Indicates that the Contact Center user handles at least one multimedia contact type.</p>\n</div></div></div><div id='property-IsPomNailedUp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-IsPomNailedUp' class='name expandable'>IsPomNailedUp</a> : Boolean<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>Returns <strong>true</strong> if the nail up call to the outbound server is active on the user endpoint.</p>\n</div><div class='long'><p>Returns <strong>true</strong> if the nail up call to the outbound server is active on the user endpoint.</p>\n</div></div></div><div id='property-LastName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-LastName' class='name expandable'>LastName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The last name of the user.</p>\n</div><div class='long'><p>The last name of the user.</p>\n</div></div></div><div id='property-LoginID' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-LoginID' class='name expandable'>LoginID</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The login ID of the user. ...</div><div class='long'><p>The login ID of the user.  This is the ID used to log in to the Contact Center.</p>\n</div></div></div><div id='property-Notification' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-Notification' class='name expandable'>Notification</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>When not null, this property provides the last notification sent to the user. ...</div><div class='long'><p>When not <strong>null</strong>, this property provides the last notification sent to the user.</p>\n\n<p>A notification can be sent to a user as the result of some administrative operation being performed on the\nuser (e.g. an User force logged off by his/her supervisor). The <em>Notification</em> property only contains the\nlatest notification sent to the user.  No history of prior notifications is retained by the system.</p>\n\n<p>The object returned by this property contains the following members:</p>\n\n<ul>\n<li><strong>Code</strong> - A string that indicates the type of operation that generated the notification (see below).  This code\n           can be used to provide a localized message to be displayed by the client application.</li>\n<li><strong>Text</strong> - A string containing the non-localized text associated with the notification.</li>\n<li><strong>Tokens</strong> - An array of strings containing tokens to be inserted into a localized message.  The number and content\n             of these tokens is dependent on the notification code (see below).</li>\n</ul>\n\n\n<p>The possible notification codes (and the associated tokens) are described below:</p>\n\n<ul>\n<li>\"ForceLogOff\" - Indicates that the User has been force logged out by a supervisor.  The name of the supervisor\n                that performed the operation is supplied in the first token string.</li>\n<li>\"ForceReady\" - Indicates that the User has been force into the ready state by a supervisor.  The name of the supervisor\n                that performed the operation is supplied in the first token string.</li>\n<li>\"ForceNotReady\" - Indicates that the User has been force into the not ready state by a supervisor.  The name of the supervisor\n                that performed the operation is supplied in the first token string.</li>\n</ul>\n\n\n<p>To acknowledge the notification and clear it from the <em>User</em> object, the <a href=\"#!/api/MobileCCS.User-method-ClearNotification\" rel=\"MobileCCS.User-method-ClearNotification\" class=\"docClass\">ClearNotification</a> method should\nbe called.</p>\n</div></div></div><div id='property-OffsiteStatus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-OffsiteStatus' class='name expandable'>OffsiteStatus</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Provides the offsite user status of the Contact Center user. ...</div><div class='long'><p>Provides the offsite user status of the Contact Center user.  If the \"offsite user\" feature is not supported, then the value of this\nproperty will be <strong>null</strong>.  Otherwise the property value will be an <em>OffsiteStatus</em> object with the following members:</p>\n\n<ul>\n<li><strong>State</strong> - A string that indicates the current state of the offsite call (see below).</li>\n<li><strong>Phone</strong> - A string containing the current offsite phone number set for the user. The value will be <strong>null</strong> if the user is not in\n            offsite mode.  Otherwise it will be set to the phone number supplied during login via the <a href=\"#!/api/MobileCCS.User-method-LoginOffsite\" rel=\"MobileCCS.User-method-LoginOffsite\" class=\"docClass\">LoginOffsite</a> method.</li>\n</ul>\n\n\n<p>Possible offsite call states are:</p>\n\n<ul>\n<li>\"Unknown\" - The offsite call state is unknown.</li>\n<li>\"Inactive\" - The user is not in offsite mode.</li>\n<li>\"Idle\" - The offsite call has not been initiated.</li>\n<li>\"Ringing\" - The call representing the permanent connection to the Contact Center is ringing on the user's offsite phone.</li>\n<li>\"Connected\" - The call representing the permanent connection to the Contact Center is connected to the user's offsite phone.</li>\n<li>\"Failed\" - The call representing the permanent connection to the Contact Center failed to be set up.</li>\n</ul>\n\n</div></div></div><div id='property-PomZones' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-PomZones' class='name expandable'>PomZones</a> : Object<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Provides an array of POM zones, created on the experience portal and selected at log in time they are used to map MPP...</div><div class='long'><p>Provides an array of POM zones, created on the experience portal and selected at log in time they are used to map MPP servers ensuring the\nclosest to the Users' location is used by a campaign</p>\n</div></div></div><div id='property-Roles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-Roles' class='name expandable'>Roles</a> : String[]<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Provides a list of the roles that this user has in the Contact Center. ...</div><div class='long'><p>Provides a list of the roles that this user has in the Contact Center.  Possible roles are:</p>\n\n<ul>\n<li>\"User\" - The user has the role of an User in the Contact Center, thereby being able to receive and\n          handle Contact Center contacts.</li>\n<li>\"Supervisor\" - The user has the role of a Supervisor in the Contact Center.  A user with this role is\n               able to monitor and coach the Users that are assigned to him or her.</li>\n</ul>\n\n</div></div></div><div id='property-Session' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-Session' class='name expandable'>Session</a> : <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">MobileCCS.Session</a><span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object that the <em>User</em> object is associated with.</p>\n</div><div class='long'><p>The <a href=\"#!/api/MobileCCS.Session\" rel=\"MobileCCS.Session\" class=\"docClass\">Session</a> object that the <em>User</em> object is associated with.</p>\n</div></div></div><div id='property-State' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-property-State' class='name expandable'>State</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>The state of the agent. ...</div><div class='long'><p>The state of the agent.  This will be one of the following:</p>\n\n<ul>\n<li>\"Invalid\" - The user has either been removed from the Contact Center or unassigned from the session.\n            The client application should cease using this agent object when in this state.  Note that this\n            state will be set in any <em>DELETE</em> notifications for <em>MonitoredUser</em> objects.</li>\n<li>\"LoggedOut\" - Indicates that the agent is not currently logged in to the Contact Center.</li>\n<li>\"Ready\" - Indicates that the agent is logged in to the Contact Center and ready to receive incoming contacts.</li>\n<li>\"ReadyAfterCall\" - Indicates that the agent has recently completed handling a Contact Center contact and is\n                   ready to accept another incoming Contact Center contact.</li>\n<li>\"ACWPending\" - Indicates that the agent is currently handling a Contact Center contact and will transition to\n               the After Call Work (ACW) state when the current contact is completed.</li>\n<li>\"ACW\" - Indicates that the agent is in an After Call Work state performing wrapup work associated with the\n        previous Contact Center contact.  When finished with After Call Work the agent should enter the Ready\n        state to become eligible to receive another Contact Center contact.</li>\n<li>\"NotReadyPending\" - Indicates that the agent is currently handling a Contact Center contact and will transition to\n                    the Not Ready state when the current contact is completed.</li>\n<li>\"NotReady\" - Indicates that the agent is logged in to the Contact Center but is not ready to handle incoming\n             Contact Center contacts.</li>\n</ul>\n\n</div></div></div><div id='property-SupervisorName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-SupervisorName' class='name expandable'>SupervisorName</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'><p>The name of the supervisor this user is assigned to.</p>\n</div><div class='long'><p>The name of the supervisor this user is assigned to.</p>\n</div></div></div><div id='property-UserSyncMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-UserSyncMessage' class='name expandable'>UserSyncMessage</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>A non localized message associated with the current UserSyncStatus or null if there is no message associated with the...</div><div class='long'><p>A non localized message associated with the current <a href=\"#!/api/MobileCCS.User-property-UserSyncStatus\" rel=\"MobileCCS.User-property-UserSyncStatus\" class=\"docClass\">UserSyncStatus</a> or null if there is no message associated with the synchronised status</p>\n</div></div></div><div id='property-UserSyncStatus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-UserSyncStatus' class='name expandable'>UserSyncStatus</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Returns the current synchronised status of the User object. ...</div><div class='long'><p>Returns the current synchronised status of the <em>User</em> object.</p>\n\n<p>Identifies if the state of the <em>User</em> object is out of sync in the case where multiple providers are servicing the <em>User</em>.\nMultiple providers can be required if a user is administered with multiple contact types. For example, if the user is administered with\n<a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">POM_Outbound and Voice</a>, the state of the user needs to be synchronised between POM and the Contact Center.\nIf a state mismatch occurs between the two providers the users state is deemed out of sync.\nThis property can be used to identify what actions need to be taken to resynchronise the users state.</p>\n\n<p>If the sync status is anything other than Synchronised or NotApplicable, <em>User</em> object will return\na non-localized message explaining the current UserSyncStatus.</p>\n</div></div></div><div id='property-VoiceResource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-property-VoiceResource' class='name expandable'>VoiceResource</a> : String<span class=\"signature\"><span class='readonly' >readonly</span></span></div><div class='description'><div class='short'>Identifies the Resource object that will be used to make and receive Voice contacts. ...</div><div class='long'><p>Identifies the <a href=\"#!/api/MobileCCS.Resource\" rel=\"MobileCCS.Resource\" class=\"docClass\">Resource</a> object that will be used to make and receive Voice contacts.  There should be a <em>Resource</em>\nobject available in the session with a corresponding ID value.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-AfterCallWork' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-AfterCallWork' class='name expandable'>AfterCallWork</a>( <span class='pre'>code</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the user into an After Call Work (ACW) state (if not already in that state) with the specified ACW code. ...</div><div class='long'><p>Sets the user into an After Call Work (ACW) state (if not already in that state) with the specified ACW code.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center and is either active on, or has just\ncompleted a Contact Center call.  If successful, the user will transition to the <strong>ACW</strong> or <strong>ACWPending</strong> state\nand an <em>UPDATE</em> notification for this user object will be received. If a failure occurs an <em>ERROR</em> notification\nwill be received.  These notifications occur on the callback method registered by the application when the\n<a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanAfterCallWork\" rel=\"MobileCCS.User-property-CanAfterCallWork\" class=\"docClass\">CanAfterCallWork</a> property to determine when it is possible to call this method, and\nby obtaining the list of valid ACW codes by calling the <a href=\"#!/api/MobileCCS.User-method-GetAfterCallWorkCodes\" rel=\"MobileCCS.User-method-GetAfterCallWorkCodes\" class=\"docClass\">GetAfterCallWorkCodes</a> method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is not logged in.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidParameter\" rel=\"MobileCCS.ErrorCode-property-InvalidParameter\" class=\"docClass\">InvalidParameter</a></td>\n            <td>The \"code\" parameter specifies an invalid ACW code (e.g. contains non-numeric characters).</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ParameterOutOfRange\" rel=\"MobileCCS.ErrorCode-property-ParameterOutOfRange\" class=\"docClass\">ParameterOutOfRange</a></td>\n            <td>The \"code\" parameter specifies an ACW code that is too long.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>code</span> : String<div class='sub-desc'><p>Specifies the ACW code to assign to the user.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>code</strong> argument is null or an empty string.</p>\n</div></li></ul></div></div></div><div id='method-ClearNotification' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-ClearNotification' class='name expandable'>ClearNotification</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Clears any notification currently set on the user (see the Notification property). ...</div><div class='long'><p>Clears any notification currently set on the user (see the <a href=\"#!/api/MobileCCS.User-property-Notification\" rel=\"MobileCCS.User-property-Notification\" class=\"docClass\">Notification</a> property).</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-GetAfterCallWorkCodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-GetAfterCallWorkCodes' class='name expandable'>GetAfterCallWorkCodes</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the defined set of After Call Work (ACW) codes from the server for this user. ...</div><div class='long'><p>Retrieves the defined set of After Call Work (ACW) codes from the server for this user.  The code list\nis passed to the callback function supplied by the <em>handler</em> argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which is defined in\n<a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a> and will be one of either <em>RESPONSE</em> or <em>ERROR</em>.  The second argument will be a\n<em>CodeList</em> object for the <em>RESPONSE</em> notification type or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>RESPONSE</em> notification indicates that a <em>CodeList</em> object is being returned containing the defined set of After Call Work codes.\nThe format of the <em>CodeList</em> object is as follows:</p>\n\n<ul>\n<li><strong>CodeType</strong> - A string that indicates the type of codes in the list (in this case it will be \"ACW\").</li>\n<li><strong>Codes</strong> - A Javascript Object whose properties provide the ACW code numbers and associated display names.</li>\n</ul>\n\n\n<p>The list of ACW code number/name pairs can be read from the <em>Codes</em> object using standard Javascript as shown in the example below:</p>\n\n<pre><code>var num, // The ACW code number\n    name; // The display name for the ACW code\nfor (num in list.Codes) {\n    if (list.Codes.hasOwnProperty(num)) {\n        name = list.Codes[num];\n        // Do something with \"num\" and/or \"name\" ...\n    }\n}\n</code></pre>\n\n<p>An <em>ERROR</em> notification received on this callback function indicates the failure of the method call. The accompanying\n<a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the source and cause of the error.</p>\n\n<p>Possible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when the response arrives.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <em>CodeList</em>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-GetNotReadyReasonCodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-GetNotReadyReasonCodes' class='name expandable'>GetNotReadyReasonCodes</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the defined set of Not Ready Reason codes from the server for this user. ...</div><div class='long'><p>Retrieves the defined set of Not Ready Reason codes from the server for this user.  The code list\nis passed to the callback function supplied by the <em>handler</em> argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which is defined in\n<a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a> and will be one of either <em>RESPONSE</em> or <em>ERROR</em>.  The second argument will be a\n<em>CodeList</em> object for the <em>RESPONSE</em> notification type or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>RESPONSE</em> notification indicates that a <em>CodeList</em> object is being returned containing the defined set of Not Ready Reason codes.\nThe format of the <em>CodeList</em> object is as follows:</p>\n\n<ul>\n<li><strong>CodeType</strong> - A string that indicates the type of codes in the list (in this case it will be \"NRRC\").</li>\n<li><strong>Codes</strong> - A Javascript Object whose properties provide the Not Ready Reason code numbers and associated display names.</li>\n</ul>\n\n\n<p>The list of Not Ready Reason code number/name pairs can be read from the <em>Codes</em> object using standard Javascript as shown in the example below:</p>\n\n<pre><code>var num, // The Not Ready Reason code number\n    name; // The display name for the Not Ready Reason code\nfor (num in list.Codes) {\n    if (list.Codes.hasOwnProperty(num)) {\n        name = list.Codes[num];\n        // Do something with \"num\" and/or \"name\" ...\n    }\n}\n</code></pre>\n\n<p>An <em>ERROR</em> notification received on this callback function indicates the failure of the method call. The accompanying\n<a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the source and cause of the error.</p>\n\n<p>Possible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when the response arrives.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <em>CodeList</em>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-GetOffsiteSettings' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-GetOffsiteSettings' class='name expandable'>GetOffsiteSettings</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the offsite user settings from the server for this user. ...</div><div class='long'><p>Retrieves the offsite user settings from the server for this user.  The settings information\nis passed to the callback function supplied by the <em>handler</em> argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which is defined in\n<a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a> and will be one of either <em>RESPONSE</em> or <em>ERROR</em>.  The second argument will be an\n<em>OffsiteSettings</em> object for the <em>RESPONSE</em> notification type or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>RESPONSE</em> notification indicates that a <em>OffsiteSettings</em> object is being returned containing the user's current\noffsite settings.  The format of the <em>OffsiteSettings</em> object is as follows:</p>\n\n<ul>\n<li><strong>Mode</strong> - A string which provides the user's configured offsite mode (see below).</li>\n<li><strong>Phones</strong> - An array of strings, each of which is a pre-configured offsite phone number for the user.\n             If the <em>AlternatePhoneAllowed</em> setting (see below) is disabled, then the user must chose one of these\n             pre-configured numbers when logging in in offsite mode.</li>\n<li><strong>AlternatePhoneAllowed</strong> - A boolean which, when <strong>true</strong>, indicates that the user can supply another phone number\n                            besides the ones pre-configured in the <em>Phones</em> list.</li>\n</ul>\n\n\n<p>The <em>Mode</em> field can have the following possible values:</p>\n\n<ul>\n<li>\"Disabled\" - Indicates that the user is not configured for working in offsite mode and must work at the Contact\n             Center office location.</li>\n<li>\"Optional\" - Indicates that the user is configured for working in offsite mode and can work either at the Contact\n             Center office location or offsite.</li>\n<li>\"Mandatory\" - Indicates that the user can only work in offsite mode.</li>\n</ul>\n\n\n<p>An <em>ERROR</em> notification received on this callback function indicates the failure of the method call. The accompanying\n<a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details as to the source and cause of the error.</p>\n\n<p>Possible errors for this method are listed below.  If the meaning of the error code in the context of this method\ndiffers significantly from the generic description given for that error code, then a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when the response arrives.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <em>CodeList</em>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-HasContactType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-HasContactType' class='name expandable'>HasContactType</a>( <span class='pre'>contacttype</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Determines if a particular contact type is supported by the object. ...</div><div class='long'><p>Determines if a particular contact type is supported by the object.  Note that this method only\napplies to objects that contain a <strong>ContactTypes</strong> property.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contacttype</span> : String<div class='sub-desc'><p>The contact type to check for (see <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">MobileCCS.ContactTypes</a>).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the specified contact type is supported.  When called on objects\n                   that do not have a <strong>ContactTypes</strong> property, this method will always return <strong>false</strong>.</p>\n</div></li></ul></div></div></div><div id='method-IsFunctionAvailable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-IsFunctionAvailable' class='name expandable'>IsFunctionAvailable</a>( <span class='pre'>funcName</span> ) : Boolean<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines if a particular function is currently available on the object. ...</div><div class='long'><p>Determines if a particular function is currently available on the object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funcName</span> : String<div class='sub-desc'><p>The name of the function to query for availability.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>Returns <strong>true</strong> if the function is currently available.</p>\n</div></li></ul></div></div></div><div id='method-Login' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-Login' class='name expandable'>Login</a>( <span class='pre'>[password], [zone]</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs the user into the Contact Center. ...</div><div class='long'><p>Logs the user into the Contact Center.</p>\n\n<p>This method may be invoked when the user is not logged in to the Contact Center.  If successful, the\nuser will transition to the <strong>NotReady</strong> state and an <em>UPDATE</em> notification for this user object will be\nreceived. If a failure occurs an <em>ERROR</em> notification will be received.  These notifications occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanLogin\" rel=\"MobileCCS.User-property-CanLogin\" class=\"docClass\">CanLogin</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning / Notes</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ActiveAgentLimitExceeded\" rel=\"MobileCCS.ErrorCode-property-ActiveAgentLimitExceeded\" class=\"docClass\">ActiveAgentLimitExceeded</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AgentAlreadyLoggedIn\" rel=\"MobileCCS.ErrorCode-property-AgentAlreadyLoggedIn\" class=\"docClass\">AgentAlreadyLoggedIn</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AgentConfigurationIncomplete\" rel=\"MobileCCS.ErrorCode-property-AgentConfigurationIncomplete\" class=\"docClass\">AgentConfigurationIncomplete</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AgentLicenseRequestDenied\" rel=\"MobileCCS.ErrorCode-property-AgentLicenseRequestDenied\" class=\"docClass\">AgentLicenseRequestDenied</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AgentLoginFailed\" rel=\"MobileCCS.ErrorCode-property-AgentLoginFailed\" class=\"docClass\">AgentLoginFailed</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is already logged in.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-LicenseLimitExceeded\" rel=\"MobileCCS.ErrorCode-property-LicenseLimitExceeded\" class=\"docClass\">LicenseLimitExceeded</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-MultimediaAgentLimitExceeded\" rel=\"MobileCCS.ErrorCode-property-MultimediaAgentLimitExceeded\" class=\"docClass\">MultimediaAgentLimitExceeded</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-MultimediaOperationDisabled\" rel=\"MobileCCS.ErrorCode-property-MultimediaOperationDisabled\" class=\"docClass\">MultimediaOperationDisabled</a></td>\n        </tr>\n       \n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-VoiceResourceHasActiveCall\" rel=\"MobileCCS.ErrorCode-property-VoiceResourceHasActiveCall\" class=\"docClass\">VoiceResourceHasActiveCall</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>password</span> : String (optional)<div class='sub-desc'><p>The user's password for logging into the Contact Center.  If the user can handle multimedia contacts the password\n                           argument should be provided as this password is used to log the user into the Contact Center Multimedia server.</p>\n</div></li><li><span class='pre'>zone</span> : Object (optional)<div class='sub-desc'><ul>\n<li>if the user is provisioned with <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">POM_Outbound</a>, they can optionally choose the pom zone for login.\n                           the argument can be null if the user is not provisioned with <a href=\"#!/api/MobileCCS.ContactTypes\" rel=\"MobileCCS.ContactTypes\" class=\"docClass\">POM_Outbound</a> or if they want\n                           to use the default zone.</li>\n</ul>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-LoginOffsite' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-LoginOffsite' class='name expandable'>LoginOffsite</a>( <span class='pre'>phone, [password]</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs the user into the Contact Center in offsite mode. ...</div><div class='long'><p>Logs the user into the Contact Center in offsite mode.</p>\n\n<p>This method attempts to login the user in offsite mode, whereby the user's normal voice phoneset is put into a telecommuter\nmode with Contact Center calls being directed to the phone number specified by the <em>phone</em> argument.\nThis redirection is performed as a permanent call that is nailed up for the duration of the user's login session.\nThe phone number specified is also controlled by the user's offsite configuration.  The user may be able to enter any desired\nphone number or pick from a list of preconfigured phone numbers or both.  The user's offsite configuration information can be\nobtained by calling the <a href=\"#!/api/MobileCCS.User-method-GetOffsiteSettings\" rel=\"MobileCCS.User-method-GetOffsiteSettings\" class=\"docClass\">GetOffsiteSettings</a> method.</p>\n\n<p>This method may be invoked when the user is not logged in to the Contact Center.  If successful, the\nuser will transition to the <strong>NotReady</strong> state and an <em>UPDATE</em> notification for this user object will be\nreceived. If a failure occurs an <em>ERROR</em> notification will be received.  These notifications occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanLoginOffsite\" rel=\"MobileCCS.User-property-CanLoginOffsite\" class=\"docClass\">CanLoginOffsite</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ActiveAgentLimitExceeded\" rel=\"MobileCCS.ErrorCode-property-ActiveAgentLimitExceeded\" class=\"docClass\">ActiveAgentLimitExceeded</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AgentConfigurationIncomplete\" rel=\"MobileCCS.ErrorCode-property-AgentConfigurationIncomplete\" class=\"docClass\">AgentConfigurationIncomplete</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AgentLicenseRequestDenied\" rel=\"MobileCCS.ErrorCode-property-AgentLicenseRequestDenied\" class=\"docClass\">AgentLicenseRequestDenied</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-AgentLoginFailed\" rel=\"MobileCCS.ErrorCode-property-AgentLoginFailed\" class=\"docClass\">AgentLoginFailed</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is already logged in.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-LicenseLimitExceeded\" rel=\"MobileCCS.ErrorCode-property-LicenseLimitExceeded\" class=\"docClass\">LicenseLimitExceeded</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-MultimediaAgentLimitExceeded\" rel=\"MobileCCS.ErrorCode-property-MultimediaAgentLimitExceeded\" class=\"docClass\">MultimediaAgentLimitExceeded</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-MultimediaOperationDisabled\" rel=\"MobileCCS.ErrorCode-property-MultimediaOperationDisabled\" class=\"docClass\">MultimediaOperationDisabled</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OffsiteCallSetupFailed\" rel=\"MobileCCS.ErrorCode-property-OffsiteCallSetupFailed\" class=\"docClass\">OffsiteCallSetupFailed</a></td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OperationNotSupported\" rel=\"MobileCCS.ErrorCode-property-OperationNotSupported\" class=\"docClass\">OperationNotSupported</a></td>\n            <td>The ability to login in offsite mode is not supported by the back-end service provider.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ParameterOutOfRange\" rel=\"MobileCCS.ErrorCode-property-ParameterOutOfRange\" class=\"docClass\">ParameterOutOfRange</a></td>\n            <td>The \"phone\" argument specified a phone number that is not pre-configured for the user and the\n            <b>AlternatePhoneAllowed</b> offsite setting for the user is disabled.<br/>\n            The offsite settings for the user can be retrieved by calling the <a href=\"#!/api/MobileCCS.User-method-GetOffsiteSettings\" rel=\"MobileCCS.User-method-GetOffsiteSettings\" class=\"docClass\">GetOffsiteSettings</a> method.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-VoiceResourceHasActiveCall\" rel=\"MobileCCS.ErrorCode-property-VoiceResourceHasActiveCall\" class=\"docClass\">VoiceResourceHasActiveCall</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>phone</span> : String<div class='sub-desc'><p>The offsite phone number that should be used to send calls to the user.</p>\n</div></li><li><span class='pre'>password</span> : String (optional)<div class='sub-desc'><p>The user's password for logging into the Contact Center.  If the user can handle multimedia contacts the password\n                           argument should be provided as this password is used to log the user into the Contact Center Multimedia server.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>phone</strong> argument is null or an empty string.</p>\n</div></li></ul></div></div></div><div id='method-Logout' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-Logout' class='name expandable'>Logout</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs the user out of the Contact Center. ...</div><div class='long'><p>Logs the user out of the Contact Center.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center.  If successful, the\nuser will transition to the <strong>LoggedOut</strong> state and an <em>UPDATE</em> notification for this user object will be\nreceived. If the user is active on a contact, the transition to the <strong>LoggedOut</strong> state will be delayed until the\ncontact ends. If a failure occurs an <em>ERROR</em> notification will be received.  These notifications occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanLogout\" rel=\"MobileCCS.User-property-CanLogout\" class=\"docClass\">CanLogout</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is not logged in.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-MonitorUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-MonitorUsers' class='name expandable'>MonitorUsers</a>( <span class='pre'>handler</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>For User objects that have the \"Supervisor\" role, this method retrieves the users that report to this supervisor and ...</div><div class='long'><p>For <em>User</em> objects that have the \"Supervisor\" role, this method retrieves the users that report to this supervisor and begins\nthe flow of events that update these users.  The initial <a href=\"#!/api/MobileCCS.MonitoredUser\" rel=\"MobileCCS.MonitoredUser\" class=\"docClass\">MonitoredUser</a> objects and subsequent updates to\nthese objects are received by the application through a callback function argument whose function signature should be as follows:</p>\n\n<pre><code>callbackFunc(notifyType, notifyObject)\n</code></pre>\n\n<p>The first argument to the callback function identifies the type of notification being supplied, which will be one of\nthe values defined in <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>.  The second argument will be a <a href=\"#!/api/MobileCCS.MonitoredUser\" rel=\"MobileCCS.MonitoredUser\" class=\"docClass\">MonitoredUser</a>\nobject for the <em>NEW</em>, <em>UPDATE</em> and <em>DELETE</em> notification types and an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object for the\n<em>ERROR</em> notification type.</p>\n\n<p>A <em>NEW</em> notification indicates that a new <em>MonitoredUser</em> object is being delivered to the application.  Immediately following the\ninvocation of this method, a <em>NEW</em> notification will be received for user assigned to the supervisor.\nAn <em>UPDATE</em> notification indicates that some property or properties of the user identifed by the supplied\n<em>notifyObject</em> has changed and the newly supplied <em>MonitoredUser</em> object represents a complete update of the <em>MonitoredUser</em> object.\nA <em>DELETE</em> notification indicates that the identified user has either been removed from the system or assigned to a different\nsupervisor.  Upon receiving a <em>DELETE</em> notification the client application should discontinue the use of the identified object.</p>\n\n<p><em>ERROR</em> notifications received on this callback function indicate the failure of some method call made by the client application\non one of the previously received <em>MonitoredUser</em> objects. The accompanying <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object provides details\nas to the source and cause of the error.</p>\n\n<p>To stop monitoring the events associated with the supervisor's users, the <a href=\"#!/api/MobileCCS.User-method-UnmonitorUsers\" rel=\"MobileCCS.User-method-UnmonitorUsers\" class=\"docClass\">UnmonitorUsers</a> method should be called.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>handler</span> : Function<div class='sub-desc'><p>This mandatory callback function is called when user events occur.  See above for\n                             a description of this callback function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>notifyType</span> : String<div class='sub-desc'><p>Identifies the type of notification being supplied (see <a href=\"#!/api/MobileCCS.NotifyTypes\" rel=\"MobileCCS.NotifyTypes\" class=\"docClass\">NotifyTypes</a>).</p>\n</div></li><li><span class='pre'>notifyObject</span> : Object<div class='sub-desc'><p>Depending on the notification type, this will be either a <a href=\"#!/api/MobileCCS.MonitoredUser\" rel=\"MobileCCS.MonitoredUser\" class=\"docClass\">MonitoredUser</a>\n                                     object or an <a href=\"#!/api/MobileCCS.Error\" rel=\"MobileCCS.Error\" class=\"docClass\">Error</a> object.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Throws</h3><ul><li><span class='pre'>TypeError</span><div class='sub-desc'><p>If the <strong>handler</strong> argument is a function.</p>\n</div></li><li><span class='pre'><a href=\"#!/api/MobileCCS.InvalidOperationError\" rel=\"MobileCCS.InvalidOperationError\" class=\"docClass\">MobileCCS.InvalidOperationError</a></span><div class='sub-desc'><p>If the \"Supervisor\" role is not present (see <a href=\"#!/api/MobileCCS.User-property-Roles\" rel=\"MobileCCS.User-property-Roles\" class=\"docClass\">Roles</a>.)</p>\n</div></li></ul></div></div></div><div id='method-NotReady' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-NotReady' class='name expandable'>NotReady</a>( <span class='pre'>[code]</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the user into a Not Ready state (if not already in Not Ready state) with an optional Not Ready Reason code. ...</div><div class='long'><p>Sets the user into a Not Ready state (if not already in Not Ready state) with an optional Not Ready Reason code.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center.  If successful, the\nuser will transition to the <strong>NotReady</strong> or <strong>NotReadyPending</strong> state and an <em>UPDATE</em> notification for this user object will be\nreceived. If a failure occurs an <em>ERROR</em> notification will be received.  These notifications occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanNotReady\" rel=\"MobileCCS.User-property-CanNotReady\" class=\"docClass\">CanNotReady</a> property to determine when it is possible to call this method, and\nby obtaining the list of valid Not Ready Reason codes by calling the <a href=\"#!/api/MobileCCS.User-method-GetNotReadyReasonCodes\" rel=\"MobileCCS.User-method-GetNotReadyReasonCodes\" class=\"docClass\">GetNotReadyReasonCodes</a> method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The User is not logged in.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidParameter\" rel=\"MobileCCS.ErrorCode-property-InvalidParameter\" class=\"docClass\">InvalidParameter</a></td>\n            <td>The \"code\" parameter specifies an invalid not ready reason code (e.g. contains non-numeric characters).</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ParameterOutOfRange\" rel=\"MobileCCS.ErrorCode-property-ParameterOutOfRange\" class=\"docClass\">ParameterOutOfRange</a></td>\n            <td>The \"code\" parameter specifies a not ready reason code that is too long.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>code</span> : String (optional)<div class='sub-desc'><p>Specifies the Not Ready Reason code to assign to the user.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-OriginateEmail' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-OriginateEmail' class='name expandable'>OriginateEmail</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Initiate an outgoing email interaction to be sent to a customer. ...</div><div class='long'><p>Initiate an outgoing email interaction to be sent to a customer.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center and is assigned to an email skillset.</p>\n\n<p>If successful, a new <a href=\"#!/api/MobileCCS.Interaction\" rel=\"MobileCCS.Interaction\" class=\"docClass\">Interaction</a> object will be created through a <em>NEW</em> notification\nrepresenting the new outgoing email. The new interaction will be in the <em>Initiated</em> state.\nIf a failure occurs an <em>ERROR</em> notification will be received.  These notifications occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanOriginateEmail\" rel=\"MobileCCS.User-property-CanOriginateEmail\" class=\"docClass\">CanOriginateEmail</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The User is not logged in.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-Ready' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-Ready' class='name expandable'>Ready</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Puts the user into a ready state. ...</div><div class='long'><p>Puts the user into a ready state.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center and in a non-ready state.  If successful, the\nuser will transition to the <strong>Ready</strong> state and an <em>UPDATE</em> notification for this user object will be\nreceived. If a failure occurs an <em>ERROR</em> notification will be received.  These notifications occur on the callback method\nregistered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanReady\" rel=\"MobileCCS.User-property-CanReady\" class=\"docClass\">CanReady</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The User is not logged in.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-RecoverOffsite' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-RecoverOffsite' class='name expandable'>RecoverOffsite</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Recovers the user's permanent offsite call when it has been inadvertently dropped or transferred. ...</div><div class='long'><p>Recovers the user's permanent offsite call when it has been inadvertently dropped or transferred.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center in offsite user mode.  If successful, this method\nimmediately puts the user in Not Ready state if not currently in Not Ready state.  It then attempts to re-establish the offsite\ncall from the Contact Center's native switch to the user's offsite phone set.  If a failure occurs an <em>ERROR</em> notification will\nbe received on the callback method registered by the application when the <a href=\"#!/api/MobileCCS.Session-method-OpenUsers\" rel=\"MobileCCS.Session-method-OpenUsers\" class=\"docClass\">OpenUsers</a> method was called.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanRecoverOffsite\" rel=\"MobileCCS.User-property-CanRecoverOffsite\" class=\"docClass\">CanRecoverOffsite</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-DeviceStateError\" rel=\"MobileCCS.ErrorCode-property-DeviceStateError\" class=\"docClass\">DeviceStateError</a></td>\n            <td>The ability to recover the offsite call is not allowed at the current time.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-InvalidAgentState\" rel=\"MobileCCS.ErrorCode-property-InvalidAgentState\" class=\"docClass\">InvalidAgentState</a></td>\n            <td>The user is not logged in.</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-OperationNotSupported\" rel=\"MobileCCS.ErrorCode-property-OperationNotSupported\" class=\"docClass\">OperationNotSupported</a></td>\n            <td>Either the user is not associated with a voice resource, or the offsite user feature is\n            not supported by the underlying switching platform or the voice resource itself.</td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-Retrieve' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-Retrieve' class='name expandable'>Retrieve</a>( <span class='pre'>contactId</span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>This method allows the application to pull the contact. ...</div><div class='long'><p>This method allows the application to pull the contact.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center and is in NotReady state. If successful, agent will receive requested contact.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the CanRetrieve property to determine when it is possible to call this method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contactId</span> : String<div class='sub-desc'><p>This is ID of contact which should be retreived</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-SetLanguage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-SetLanguage' class='name expandable'>SetLanguage</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>Set the language of the user. ...</div><div class='long'><p>Set the language of the user.</p>\n\n<p>This method may be invoked when the user is logged in to the Contact Center.</p>\n\n<p>Possible errors for this method are listed below.\nMost errors can be prevented by using the <a href=\"#!/api/MobileCCS.User-property-CanSetLanguage\" rel=\"MobileCCS.User-property-CanSetLanguage\" class=\"docClass\">CanSetLanguage</a> property to determine when it is possible to call this method.\nIf the meaning of the error code in the context of this method differs significantly from the generic description given for that error code,\nthen a context-specific meaning is given.</p>\n\n<table style=\"max-width:900px;\">\n    <tbody valign=\"top\">\n        <tr style=\"font-weight:bold\">\n            <td>Error Codes</td>\n            <td>Context-Specific Meaning</td>\n        </tr>\n        <tr>\n            <td><a href=\"#!/api/MobileCCS.ErrorCode-property-ServerCommunicationFailure\" rel=\"MobileCCS.ErrorCode-property-ServerCommunicationFailure\" class=\"docClass\">ServerCommunicationFailure</a></td>\n        </tr>\n    </tbody>\n</table>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-UnmonitorUsers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='MobileCCS.User'>MobileCCS.User</span><br/></div><a href='#!/api/MobileCCS.User-method-UnmonitorUsers' class='name expandable'>UnmonitorUsers</a>( <span class='pre'></span> ) : void<span class=\"signature\"></span></div><div class='description'><div class='short'>This method causes the set of MonitoredUser objects associated with this User to be discarded and will cease the flow...</div><div class='long'><p>This method causes the set of <em>MonitoredUser</em> objects associated with this <em>User</em> to be discarded and will cease the flow of events\nthat update these objects.  Upon calling this method the client application should no longer use any <em>MonitoredUser</em> objects it received\nfrom the callback function supplied when it called the <a href=\"#!/api/MobileCCS.User-method-MonitorUsers\" rel=\"MobileCCS.User-method-MonitorUsers\" class=\"docClass\">MonitorUsers</a> method.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>void</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-updateDerivedProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/MobileCCS.BaseUser' rel='MobileCCS.BaseUser' class='defined-in docClass'>MobileCCS.BaseUser</a><br/></div><a href='#!/api/MobileCCS.BaseUser-method-updateDerivedProperties' class='name expandable'>updateDerivedProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates derived property values after applying an update received from the server. ...</div><div class='long'><p>Updates derived property values after applying an update received from the server.</p>\n</div></div></div><div id='method-updateProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-updateProperties' class='name expandable'>updateProperties</a>( <span class='pre'>data</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Updates property values from an update received from the server. ...</div><div class='long'><p>Updates property values from an update received from the server.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-uriToName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/CCSObject' rel='CCSObject' class='defined-in docClass'>CCSObject</a><br/></div><a href='#!/api/CCSObject-method-uriToName' class='name expandable'>uriToName</a>( <span class='pre'>uri</span> ) : String<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Given a URI, this method extracts the name portion from the URI. ...</div><div class='long'><p>Given a URI, this method extracts the name portion from the URI.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>uri</span> : String<div class='sub-desc'><p>The URI string to extract the name portion from.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name portion of the URI.  This may be identical to the URI if the input string is not a URI.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{}});